/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.ghostcounter;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.features.combat.ghostcounter.GhostCounter;
import at.hannibal2.skyhanni.features.combat.ghostcounter.GhostData;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0019\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0017J\u0019\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0019J)\u0010\u001c\u001a\u00020\f*\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u001e\u00a2\u0006\u0004\b\u0012\u0010\u001fJ!\u0010\"\u001a\u00020\f*\u00020\f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014\u00a2\u0006\u0004\b\"\u0010\u0017J\u0017\u0010$\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/combat/ghostcounter/GhostUtil;", "", "<init>", "()V", "", "reset", "", "isUsingCTGhostCounter", "()Z", "", "millis", "", "", "prettyTime", "(J)Ljava/util/Map;", "importCTGhostCounterData", "Lat/hannibal2/skyhanni/features/combat/ghostcounter/GhostData$Option;", "option", "formatText", "(Ljava/lang/String;Lat/hannibal2/skyhanni/features/combat/ghostcounter/GhostData$Option;)Ljava/lang/String;", "", "value", "session", "(Ljava/lang/String;II)Ljava/lang/String;", "t", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "level", "nextLevel", "preFormat", "(Ljava/lang/String;Ljava/lang/String;II)Ljava/lang/String;", "", "(Ljava/lang/String;DD)Ljava/lang/String;", "currentKill", "killNeeded", "formatBestiary", "number", "percent", "(D)Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGhostUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GhostUtil.kt\nat/hannibal2/skyhanni/features/combat/ghostcounter/GhostUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class GhostUtil {
    @NotNull
    public static final GhostUtil INSTANCE = new GhostUtil();

    private GhostUtil() {
    }

    public final void reset() {
        for (GhostData.Option opt : GhostData.Option.getEntries()) {
            GhostData.Option.set$default(opt, 0.0, false, 2, null);
            opt.set(0.0, true);
        }
        if (GhostCounter.INSTANCE.getStorage() != null) {
            GhostCounter.INSTANCE.getStorage().totalMF = 0.0;
        }
        GhostCounter.INSTANCE.update();
    }

    public final boolean isUsingCTGhostCounter() {
        return GhostCounter.INSTANCE.getGhostCounterV3File().exists() && GhostCounter.INSTANCE.getGhostCounterV3File().isFile();
    }

    @NotNull
    public final Map<String, String> prettyTime(long millis) {
        Object object;
        Map<String, String> map2;
        long seconds = millis / (long)1000 % (long)60;
        long minutes = millis / (long)1000 / (long)60 % (long)60;
        long hours = millis / (long)1000 / (long)60 / (long)60 % (long)24;
        long days = millis / (long)1000 / (long)60 / (long)60 / (long)24;
        Map<String, String> $this$prettyTime_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        if (millis < 0L) {
            $this$prettyTime_u24lambda_u240.clear();
            object = Unit.INSTANCE;
        } else if (minutes == 0L && hours == 0L && days == 0L) {
            object = $this$prettyTime_u24lambda_u240.put("seconds", String.valueOf(seconds));
        } else if (hours == 0L && days == 0L) {
            $this$prettyTime_u24lambda_u240.put("seconds", String.valueOf(seconds));
            object = $this$prettyTime_u24lambda_u240.put("minutes", String.valueOf(minutes));
        } else if (days == 0L) {
            $this$prettyTime_u24lambda_u240.put("seconds", String.valueOf(seconds));
            $this$prettyTime_u24lambda_u240.put("minutes", String.valueOf(minutes));
            object = $this$prettyTime_u24lambda_u240.put("hours", String.valueOf(hours));
        } else {
            $this$prettyTime_u24lambda_u240.put("seconds", String.valueOf(seconds));
            $this$prettyTime_u24lambda_u240.put("minutes", String.valueOf(minutes));
            $this$prettyTime_u24lambda_u240.put("hours", String.valueOf(hours));
            object = $this$prettyTime_u24lambda_u240.put("days", String.valueOf(days));
        }
        return MapsKt.build(map2);
    }

    public final void importCTGhostCounterData() {
        JsonObject json;
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object == null || (object = ((ProfileSpecificStorage)object).ghostCounter) == null) {
            return;
        }
        Object c = object;
        if (this.isUsingCTGhostCounter()) {
            if (((ProfileSpecificStorage.GhostCounter)c).ctDataImported) {
                ChatUtils.INSTANCE.userError("You already imported GhostCounterV3 data!");
                return;
            }
            json = (JsonObject)ConfigManager.Companion.getGson().fromJson((Reader)new FileReader(GhostCounter.INSTANCE.getGhostCounterV3File()), JsonObject.class);
            GhostData.Option.add$default(GhostData.Option.GHOSTSINCESORROW, json.get("ghostsSinceSorrow").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.SORROWCOUNT, json.get("sorrowCount").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.BAGOFCASH, json.get("BagOfCashCount").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.PLASMACOUNT, json.get("PlasmaCount").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.VOLTACOUNT, json.get("VoltaCount").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.GHOSTLYBOOTS, json.get("GhostlyBootsCount").getAsDouble(), false, 2, null);
            GhostData.Option.add$default(GhostData.Option.KILLS, json.get("ghostsKilled").getAsDouble(), false, 2, null);
            if (GhostCounter.INSTANCE.getStorage() != null) {
                ProfileSpecificStorage.GhostCounter ghostCounter = GhostCounter.INSTANCE.getStorage();
                GhostCounter.INSTANCE.getStorage().totalMF = ghostCounter != null ? ghostCounter.totalMF + json.get("TotalMF").getAsDouble() : json.get("TotalMF").getAsDouble();
            }
        } else {
            ErrorManager.INSTANCE.skyHanniError("GhostCounterV3 ChatTriggers module not found!", new Pair[0]);
            throw new KotlinNothingValueException();
        }
        GhostData.Option.add$default(GhostData.Option.TOTALDROPS, json.get("TotalDrops").getAsDouble(), false, 2, null);
        ((ProfileSpecificStorage.GhostCounter)c).ctDataImported = true;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aImported data successfully!", false, null, 6, null);
    }

    @NotNull
    public final String formatText(@NotNull String $this$formatText, @NotNull GhostData.Option option) {
        Intrinsics.checkNotNullParameter($this$formatText, "<this>");
        Intrinsics.checkNotNullParameter((Object)option, "option");
        return this.formatText($this$formatText, GhostData.Option.getInt$default(option, false, 1, null), option.getInt(true));
    }

    @NotNull
    public final String formatText(@NotNull String $this$formatText, int value, int session) {
        Intrinsics.checkNotNullParameter($this$formatText, "<this>");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$formatText, "%value%", NumberUtil.INSTANCE.addSeparators(value), false, 4, null), "%session%", NumberUtil.INSTANCE.addSeparators(session), false, 4, null), "&", "\u00a7", false, 4, null);
    }

    public static /* synthetic */ String formatText$default(GhostUtil ghostUtil, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return ghostUtil.formatText(string2, n, n2);
    }

    @NotNull
    public final String formatText(@NotNull String $this$formatText, @NotNull String t) {
        Intrinsics.checkNotNullParameter($this$formatText, "<this>");
        Intrinsics.checkNotNullParameter(t, "t");
        return StringsKt.replace$default(StringsKt.replace$default($this$formatText, "%value%", t, false, 4, null), "&", "\u00a7", false, 4, null);
    }

    @NotNull
    public final String preFormat(@NotNull String $this$preFormat, @NotNull String t, int level, int nextLevel) {
        Intrinsics.checkNotNullParameter($this$preFormat, "<this>");
        Intrinsics.checkNotNullParameter(t, "t");
        return nextLevel == 26 ? StringsKt.replace$default(StringsKt.replace$default($this$preFormat, "%value%", t, false, 4, null), "%display%", "25", false, 4, null) : StringsKt.replace$default(StringsKt.replace$default($this$preFormat, "%value%", t, false, 4, null), "%display%", level + "->" + (SkyHanniMod.feature.combat.ghostCounter.showMax ? "25" : Integer.valueOf(nextLevel)), false, 4, null);
    }

    @NotNull
    public final String formatText(@NotNull String $this$formatText, double value, double session) {
        Intrinsics.checkNotNullParameter($this$formatText, "<this>");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$formatText, "%value%", NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(value, 2)), false, 4, null), "%session%", NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(session, 2)), false, 4, null), "&", "\u00a7", false, 4, null);
    }

    @NotNull
    public final String formatBestiary(@NotNull String $this$formatBestiary, int currentKill, int killNeeded) {
        Object object;
        Object currentLevel;
        block9: {
            block8: {
                Double bestiaryNextLevel;
                block7: {
                    Object object2;
                    block6: {
                        Intrinsics.checkNotNullParameter($this$formatBestiary, "<this>");
                        ProfileSpecificStorage.GhostCounter ghostCounter = GhostCounter.INSTANCE.getStorage();
                        bestiaryNextLevel = ghostCounter != null ? Double.valueOf(ghostCounter.bestiaryNextLevel) : null;
                        object2 = bestiaryNextLevel;
                        if (object2 == null) break block6;
                        double it = ((Number)object2).doubleValue();
                        boolean bl = false;
                        String string2 = (int)it < 0 ? "25" : String.valueOf((int)it - 1);
                        object2 = string2;
                        if (string2 != null) break block7;
                    }
                    object2 = currentLevel = "\u00a7cNo Bestiary Level Data!";
                }
                if ((object = bestiaryNextLevel) == null) break block8;
                double it = ((Number)object).doubleValue();
                boolean bl = false;
                String string3 = GhostCounter.INSTANCE.getConfig().showMax ? "25" : String.valueOf((int)it);
                object = string3;
                if (string3 != null) break block9;
            }
            object = "\u00a7cNo Bestiary Level data!";
        }
        Object nextLevel = object;
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$formatBestiary, "%currentKill%", GhostCounter.INSTANCE.getConfig().showMax ? NumberUtil.INSTANCE.addSeparators(GhostCounter.INSTANCE.getBestiaryCurrentKill()) : NumberUtil.INSTANCE.addSeparators(currentKill), false, 4, null), "%percentNumber%", this.percent(GhostCounter.INSTANCE.getBestiaryCurrentKill()), false, 4, null), "%killNeeded%", NumberUtil.shortFormat$default(NumberUtil.INSTANCE, killNeeded, false, 1, null), false, 4, null), "%currentLevel%", (String)currentLevel, false, 4, null), "%nextLevel%", (String)nextLevel, false, 4, null), "&", "\u00a7", false, 4, null);
    }

    private final String percent(double number) {
        return String.valueOf(RangesKt.coerceAtMost(100.0, NumberUtil.INSTANCE.roundTo(number / (double)100000 * (double)100, 4)));
    }
}

