/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.bingo;

import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoRanksJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.bingo.card.goals.BingoGoal;
import at.hannibal2.skyhanni.features.bingo.card.goals.GoalType;
import at.hannibal2.skyhanni.features.bingo.card.goals.HiddenGoalData;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u001b\u00a2\u0006\u0004\b\u0019\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e\u00a2\u0006\u0004\b%\u0010\u0016R\"\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(RQ\u0010.\u001aB\u0012\f\u0012\n +*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n +*\u0004\u0018\u00010\u001b0\u001b +* \u0012\f\u0012\n +*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n +*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010&0*8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001f\u00102\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u001b0\u001b0/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001f\u00104\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u001b0\u001b0/8F\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\"\u00106\u001a\u0002058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u0010\u001f\"\u0004\b9\u0010:R\u001b\u0010@\u001a\u00020;8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u001b\u0010F\u001a\u00020A8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\u00a8\u0006G"}, d2={"Lat/hannibal2/skyhanni/features/bingo/BingoAPI;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "text", "", "getRankFromScoreboard", "(Ljava/lang/String;)Ljava/lang/Integer;", "getIconFromScoreboard", "(Ljava/lang/String;)Ljava/lang/String;", "getRank", "searchRank", "getIcon", "(I)Ljava/lang/String;", "itemName", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "getData", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "Lat/hannibal2/skyhanni/features/bingo/card/goals/BingoGoal;", "(Lat/hannibal2/skyhanni/features/bingo/card/goals/BingoGoal;)Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "", "getStartOfMonthInMillis", "()J", "", "percentage", "getCommunityPercentageColor", "(D)Ljava/lang/String;", "rank", "getBingoIcon", "", "ranks", "Ljava/util/Map;", "data", "", "kotlin.jvm.PlatformType", "getBingoGoals", "()Ljava/util/Map;", "bingoGoals", "", "getPersonalGoals", "()Ljava/util/List;", "personalGoals", "getCommunityGoals", "communityGoals", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastBingoCardOpenTime", "J", "getLastBingoCardOpenTime-uFjCsEo", "setLastBingoCardOpenTime-gJLAdNM", "(J)V", "Ljava/util/regex/Pattern;", "detectionPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getDetectionPattern", "()Ljava/util/regex/Pattern;", "detectionPattern", "Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BingoSession;", "bingoStorage$delegate", "Lkotlin/Lazy;", "getBingoStorage", "()Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BingoSession;", "bingoStorage", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBingoAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoAPI.kt\nat/hannibal2/skyhanni/features/bingo/BingoAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,122:1\n774#2:123\n865#2,2:124\n774#2:126\n865#2,2:127\n12#3,7:129\n12#3,7:136\n1#4:143\n535#5:144\n520#5,6:145\n381#5,7:151\n*S KotlinDebug\n*F\n+ 1 BingoAPI.kt\nat/hannibal2/skyhanni/features/bingo/BingoAPI\n*L\n30#1:123\n30#1:124,2\n31#1:126\n31#1:127,2\n72#1:129,7\n73#1:136,7\n86#1:144\n86#1:145,6\n96#1:151,7\n*E\n"})
public final class BingoAPI {
    @NotNull
    public static final BingoAPI INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static Map<String, Integer> ranks;
    @NotNull
    private static Map<String, BingoData> data;
    private static long lastBingoCardOpenTime;
    @NotNull
    private static final RepoPattern detectionPattern$delegate;
    @NotNull
    private static final Lazy bingoStorage$delegate;

    private BingoAPI() {
    }

    public final Map<Integer, BingoGoal> getBingoGoals() {
        return this.getBingoStorage().goals;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BingoGoal> getPersonalGoals() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBingoGoals().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoGoal it = (BingoGoal)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == GoalType.PERSONAL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BingoGoal> getCommunityGoals() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBingoGoals().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoGoal it = (BingoGoal)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == GoalType.COMMUNITY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final long getLastBingoCardOpenTime-uFjCsEo() {
        return lastBingoCardOpenTime;
    }

    public final void setLastBingoCardOpenTime-gJLAdNM(long l) {
        lastBingoCardOpenTime = l;
    }

    private final Pattern getDetectionPattern() {
        return (Pattern)detectionPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Bingo Card");
        if (!LorenzUtils.INSTANCE.isBingoProfile()) {
            event.addIrrelevant("not on bingo");
            return;
        }
        event.addData(BingoAPI::onDebugDataCollect$lambda$2);
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "BingoRanks";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            object = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, BingoRanksJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        ranks = ((BingoRanksJson)object).getRanks();
        constant$iv = "Bingo";
        type$iv = null;
        gson$iv = event.getGson();
        $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            object = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, BingoJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        data = ((BingoJson)object).getBingoTips();
    }

    @Nullable
    public final Integer getRankFromScoreboard(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return RegexUtils.INSTANCE.matches(this.getDetectionPattern(), text) ? this.getRank(text) : null;
    }

    @Nullable
    public final String getIconFromScoreboard(@NotNull String text) {
        String string2;
        Intrinsics.checkNotNullParameter(text, "text");
        Integer n = this.getRankFromScoreboard(text);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string2 = INSTANCE.getIcon(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public final Integer getRank(@NotNull String text) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(text, "text");
            Iterable iterable = ranks.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)text, (CharSequence)it.getKey(), false, 2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (Integer)entry.getValue() : null;
    }

    @Nullable
    public final String getIcon(int searchRank) {
        Object v0;
        block1: {
            Iterable iterable = ranks.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() == searchRank)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (String)entry.getKey() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BingoData getData(@NotNull String itemName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemName, "itemName");
        Map<String, BingoData> $this$filter$iv = data;
        boolean $i$f$filter = false;
        Map<String, BingoData> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            String[] stringArray = new String[]{" (Community Goal)"};
            if (!StringsKt.startsWith$default(itemName, (String)StringsKt.split$default((CharSequence)it.getKey(), stringArray, false, 0, 6, null).get(0), false, 2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (BingoData)CollectionsKt.firstOrNull(destination$iv$iv.values());
    }

    @Nullable
    public final BingoData getData(@NotNull BingoGoal $this$getData) {
        Intrinsics.checkNotNullParameter($this$getData, "<this>");
        return $this$getData.getType() == GoalType.COMMUNITY ? this.getData($this$getData.getDisplayName()) : data.get($this$getData.getDisplayName());
    }

    @NotNull
    public final PlayerSpecificStorage.BingoSession getBingoStorage() {
        Lazy lazy = bingoStorage$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (PlayerSpecificStorage.BingoSession)t;
    }

    private final long getStartOfMonthInMillis() {
        return OffsetDateTime.of(TimeUtils.INSTANCE.getCurrentLocalDate().plusDays(5L).withDayOfMonth(1), LocalTime.MIDNIGHT, ZoneOffset.UTC).toEpochSecond();
    }

    @NotNull
    public final String getCommunityPercentageColor(double percentage) {
        return (percentage < 0.01 ? "\u00a7a" : (percentage < 0.05 ? "\u00a7e" : (percentage < 0.1 ? "\u00a76" : (percentage < 0.25 ? "\u00a76" : "\u00a7c")))) + LorenzUtils.INSTANCE.formatPercentage(percentage);
    }

    @NotNull
    public final String getBingoIcon(int rank) {
        String string2 = this.getIcon(rank);
        if (string2 == null) {
            string2 = "";
        }
        String rankIcon = string2;
        return rank != -1 ? rankIcon + ' ' + rank : rankIcon;
    }

    private static final Unit onDebugDataCollect$lambda$2(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("bingoGoals: " + INSTANCE.getBingoGoals().size());
        Map<Integer, BingoGoal> map2 = INSTANCE.getBingoGoals();
        Intrinsics.checkNotNullExpressionValue(map2, "<get-bingoGoals>(...)");
        for (Map.Entry<Integer, BingoGoal> bingoGoal : map2.entrySet()) {
            BingoGoal goal = bingoGoal.getValue();
            $this$addData.add("  type: '" + (Object)((Object)goal.getType()) + '\'');
            $this$addData.add("  displayName: '" + goal.getDisplayName() + '\'');
            $this$addData.add("  description: '" + goal.getDescription() + '\'');
            $this$addData.add("  guide: '" + goal.getGuide() + '\'');
            $this$addData.add("  done: '" + goal.getDone() + '\'');
            $this$addData.add("  highlight: '" + goal.getHighlight() + '\'');
            $this$addData.add("  communityGoalPercentage: '" + goal.getCommuntyGoalPercentage() + '\'');
            HiddenGoalData hiddenGoalData = goal.getHiddenGoalData();
            $this$addData.add("  hiddenGoalData");
            $this$addData.add("    unknownTip: '" + hiddenGoalData.getUnknownTip() + '\'');
            $this$addData.add("    nextHintTime: '" + hiddenGoalData.getNextHintTime-FghU774() + '\'');
            $this$addData.add("    tipNote: '" + hiddenGoalData.getTipNote() + '\'');
            $this$addData.add(" ");
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final PlayerSpecificStorage.BingoSession bingoStorage_delegate$lambda$8() {
        Object object;
        void $this$getOrPut$iv;
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        if (playerSpecificStorage == null) {
            throw new IllegalStateException("playerSpecific is null".toString());
        }
        PlayerSpecificStorage playerSpecific = playerSpecificStorage;
        Map<Long, PlayerSpecificStorage.BingoSession> map2 = playerSpecific.bingoSessions;
        Intrinsics.checkNotNullExpressionValue(map2, "bingoSessions");
        Map<Long, PlayerSpecificStorage.BingoSession> map3 = map2;
        Long key$iv = INSTANCE.getStartOfMonthInMillis();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PlayerSpecificStorage.BingoSession answer$iv = new PlayerSpecificStorage.BingoSession();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PlayerSpecificStorage.BingoSession)object;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BingoAPI.class, "detectionPattern", "getDetectionPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new BingoAPI();
        ranks = MapsKt.emptyMap();
        data = MapsKt.emptyMap();
        lastBingoCardOpenTime = SimpleTimeMark.Companion.farPast();
        detectionPattern$delegate = RepoPattern.Companion.pattern("bingo.detection.scoreboard", " \u00a7.\u24b7 \u00a7.Bingo");
        bingoStorage$delegate = LazyKt.lazy(BingoAPI::bingoStorage_delegate$lambda$8);
    }
}

