/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.elements.GuiElementSlider;
import at.hannibal2.skyhanni.deps.moulconfig.gui.elements.GuiElementTextField;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorSlider
extends GuiOptionEditor {
    private final GuiElementSlider slider;
    private final GuiElementTextField textField;

    public GuiOptionEditorSlider(ProcessedOption option, float minValue, float maxValue, float minStep) {
        super(option);
        if (minStep < 0.0f) {
            minStep = 0.01f;
        }
        float floatVal = this.getFloatValue();
        this.textField = new GuiElementTextField(this.getStringifiedFloatValue(), 56);
        this.slider = new GuiElementSlider(0, 0, 80, minValue, maxValue, minStep, floatVal, val -> {
            option.set(val);
            this.textField.setText(this.getStringifiedFloatValue());
        });
    }

    public String getStringifiedFloatValue() {
        String strVal;
        float floatVal = this.getFloatValue();
        if (floatVal % 1.0f == 0.0f) {
            strVal = Integer.toString((int)floatVal);
        } else {
            strVal = Float.toString(floatVal);
            strVal = strVal.replaceAll("(\\.\\d\\d\\d)\\d+", "$1");
            strVal = strVal.replaceAll("0+$", "");
        }
        return strVal;
    }

    public float getFloatValue() {
        return ((Number)this.option.get()).floatValue();
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int sliderWidth = (fullWidth - 5) * 3 / 4;
        int textFieldWidth = (fullWidth - 5) / 4;
        if (!Mouse.isButtonDown((int)0)) {
            this.slider.setValue(this.getFloatValue());
        }
        this.slider.x = x + width / 6 - fullWidth / 2;
        this.slider.y = y + height - 7 - 14;
        this.slider.width = sliderWidth;
        this.slider.render();
        if (this.textField.getFocus()) {
            this.textField.setOptions(24);
            this.textField.setSize(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10, 16);
        } else {
            this.textField.setText(this.getStringifiedFloatValue());
            this.textField.setSize(textFieldWidth, 16);
            this.textField.setOptions(56);
        }
        this.textField.render(x + width / 6 - fullWidth / 2 + sliderWidth + 5, y + height - 7 - 14);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int sliderWidth = (fullWidth - 5) * 3 / 4;
        int textFieldWidth = (fullWidth - 5) / 4;
        this.slider.x = x + width / 6 - fullWidth / 2;
        this.slider.y = y + height - 7 - 14;
        this.slider.width = sliderWidth;
        if (this.slider.mouseInput(mouseX, mouseY)) {
            this.textField.unfocus();
            return true;
        }
        if (this.textField.getFocus()) {
            textFieldWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10;
        }
        int textFieldX = x + width / 6 - fullWidth / 2 + sliderWidth + 5;
        int textFieldY = y + height - 7 - 14;
        this.textField.setSize(textFieldWidth, 16);
        if (Mouse.getEventButtonState() && (Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1)) {
            if (mouseX > textFieldX && mouseX < textFieldX + textFieldWidth && mouseY > textFieldY && mouseY < textFieldY + 16) {
                this.textField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                return true;
            }
            this.textField.unfocus();
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (Keyboard.getEventKeyState() && this.textField.getFocus()) {
            this.textField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            try {
                this.textField.setCustomBorderColour(-1);
                float f = Float.parseFloat(this.textField.getText());
                if (this.option.set(Float.valueOf(f))) {
                    this.slider.setValue(f);
                } else {
                    this.textField.setCustomBorderColour(-16776961);
                }
            }
            catch (Exception e) {
                this.textField.setCustomBorderColour(-65536);
            }
            return true;
        }
        return false;
    }
}

