/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.ComponentEditor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.util.Locale;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorButton
extends ComponentEditor {
    private final int runnableId;
    private String buttonText;
    private final Config config;
    private boolean isUsingRunnable;
    private final GuiComponent delegate = this.wrapComponent(new GuiComponent(){

        @Override
        public int getWidth() {
            return 48;
        }

        @Override
        public int getHeight() {
            return 16;
        }

        @Override
        public void render(@NotNull GuiImmediateContext context2) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IMinecraft.instance.bindTexture(GuiTextures.BUTTON);
            context2.getRenderContext().drawTexturedRect(0.0f, 0.0f, context2.getWidth(), context2.getHeight());
            context2.getRenderContext().drawStringCenteredScaledMaxWidth(GuiOptionEditorButton.this.buttonText, context2.getRenderContext().getMinecraft().getDefaultFontRenderer(), (float)context2.getWidth() / 2.0f, (float)context2.getHeight() / 2.0f, false, context2.getWidth() - 4, -13619152);
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
            MouseEvent.Click click;
            if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && context2.isHovered() && click.getMouseButton() == 0) {
                GuiOptionEditorButton.this.onClick();
                return true;
            }
            return super.mouseEvent(mouseEvent, context2);
        }
    });

    public GuiOptionEditorButton(ProcessedOption option, int runnableId, String buttonText, Config config) {
        super(option);
        this.runnableId = runnableId;
        this.config = config;
        this.buttonText = buttonText;
        boolean bl = this.isUsingRunnable = option.getType() == Runnable.class;
        if (this.buttonText == null) {
            this.buttonText = "";
        }
    }

    public void onClick() {
        if (this.isUsingRunnable) {
            ((Runnable)this.option.get()).run();
        } else {
            this.config.executeRunnable(this.runnableId);
        }
    }

    @Override
    public boolean fulfillsSearch(String word) {
        return super.fulfillsSearch(word) || this.buttonText.toLowerCase(Locale.ROOT).contains(word);
    }

    @Override
    public GuiComponent getDelegate() {
        return this.delegate;
    }
}

