/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;

public class ScrollPanelComponent
extends GuiComponent {
    final int width;
    final int height;
    final GuiComponent child;
    int scrollOffset;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor2) {
        return visitor2.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(GuiImmediateContext context2) {
        context2.getRenderContext().pushMatrix();
        int x = context2.getRenderOffsetX();
        int y = context2.getRenderOffsetY();
        context2.getRenderContext().pushScissor(x, y, x + this.width, y + this.height);
        context2.getRenderContext().translate(0.0f, -this.scrollOffset, 0.0f);
        this.child.render(context2.translatedNonRendering(0, -this.scrollOffset, this.width, this.height));
        context2.getRenderContext().popScissor();
        context2.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context2) {
        return this.child.keyboardEvent(event, context2.translatedNonRendering(0, -this.scrollOffset, this.width, this.height));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context2) {
        if (this.child.mouseEvent(mouseEvent, context2.translatedNonRendering(0, -this.scrollOffset, this.width, this.height))) {
            return true;
        }
        if (context2.isHovered() && mouseEvent instanceof MouseEvent.Scroll) {
            this.scrollOffset = (int)Math.max(0.0f, Math.min((float)this.scrollOffset - ((MouseEvent.Scroll)mouseEvent).getDWheel(), (float)(this.child.getHeight() - this.height)));
            return true;
        }
        return false;
    }

    public ScrollPanelComponent(int width, int height, GuiComponent child) {
        this.width = width;
        this.height = height;
        this.child = child;
    }
}

