/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00028\u00002\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001f\u001a\u0004\b \u0010!R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/ScaleComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiComponent;", "child", "Ljava/util/function/Supplier;", "", "scaleFactor", "<init>", "(Lio/github/notenoughupdates/moulconfig/gui/GuiComponent;Ljava/util/function/Supplier;)V", "T", "initial", "Ljava/util/function/BiFunction;", "visitor", "foldChildren", "(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "", "getHeight", "()I", "getWidth", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/KeyboardEvent;", "event", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiImmediateContext;", "context", "", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiComponent;", "getChild", "()Lio/github/notenoughupdates/moulconfig/gui/GuiComponent;", "Ljava/util/function/Supplier;", "getScaleFactor", "()Ljava/util/function/Supplier;", "common"})
public final class ScaleComponent
extends GuiComponent {
    @NotNull
    private final GuiComponent child;
    @NotNull
    private final Supplier<Float> scaleFactor;

    public ScaleComponent(@NotNull GuiComponent child, @NotNull Supplier<Float> scaleFactor) {
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(scaleFactor, "scaleFactor");
        this.child = child;
        this.scaleFactor = scaleFactor;
    }

    @NotNull
    public final GuiComponent getChild() {
        return this.child;
    }

    @NotNull
    public final Supplier<Float> getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public int getWidth() {
        return (int)(((Number)this.scaleFactor.get()).floatValue() * (float)this.child.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)(((Number)this.scaleFactor.get()).floatValue() * (float)this.child.getHeight());
    }

    @Override
    public <T> T foldChildren(T initial, @NotNull BiFunction<GuiComponent, T, T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(@NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        context2.getRenderContext().pushMatrix();
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue(f, "scaleFactor.get()");
        float s = ((Number)f).floatValue();
        context2.getRenderContext().scale(s, s, 1.0f);
        this.child.render(context2.scaled(s));
        context2.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(context2, "context");
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue(f, "scaleFactor.get()");
        return this.child.keyboardEvent(event, context2.scaled(((Number)f).floatValue()));
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(mouseEvent, "mouseEvent");
        Intrinsics.checkNotNullParameter(context2, "context");
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue(f, "scaleFactor.get()");
        return this.child.mouseEvent(mouseEvent, context2.scaled(((Number)f).floatValue()));
    }
}

