/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui;

import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class GuiComponent {
    protected final IMinecraft mc = IMinecraft.instance;
    GuiContext context;

    protected GuiComponent() {
    }

    public void setContext(GuiContext context2) {
        this.context = context2;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void requestFocus() {
        this.context.setFocusedElement(this);
    }

    public boolean isFocused() {
        return this.context.getFocusedElement() == this;
    }

    public boolean isInFocus() {
        return this.foldRecursive(false, (element, isFocused) -> isFocused != false || element.isFocused());
    }

    public void onLostFocus() {
    }

    public final <T> T foldRecursive(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor2) {
        return (T)this.foldChildren(visitor2.apply(this, (GuiComponent)initial), (element, state) -> element.foldRecursive(state, visitor2));
    }

    public <T> T foldChildren(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor2) {
        return initial;
    }

    public abstract void render(@NotNull GuiImmediateContext var1);

    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        return false;
    }

    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context2) {
        return false;
    }

    public GuiContext getContext() {
        return this.context;
    }
}

