/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.features.dev.RepositoryConfig;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.LorenzEvent;
import at.hannibal2.skyhanni.events.NeuRepositoryReloadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.chat.Text;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b \u0010!J\u0019\u0010#\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010&\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00062\b\b\u0002\u0010+\u001a\u00020\u000b\u00a2\u0006\u0004\b,\u0010\u001bJ\u000f\u0010-\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b-\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010.R\u0014\u00102\u001a\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0018\u00103\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0017\u00105\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b5\u0010.\u001a\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010;\u001a\u00020:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0014\u0010>\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoManager;", "", "Ljava/io/File;", "configLocation", "<init>", "(Ljava/io/File;)V", "", "loadRepoInformation", "()V", "updateRepo", "reloadLocalRepo", "", "command", "Ljava/util/concurrent/CompletableFuture;", "fetchRepository", "(Z)Ljava/util/concurrent/CompletableFuture;", "", "answerMessage", "Ljava/lang/Void;", "reloadRepository", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "joinEvent", "displayRepoStatus", "(Z)V", "file", "Lcom/google/gson/JsonObject;", "getJsonFromFile", "(Ljava/io/File;)Lcom/google/gson/JsonObject;", "getCommitApiUrl", "()Ljava/lang/String;", "commitId", "getDownloadUrl", "(Ljava/lang/String;)Ljava/lang/String;", "json", "writeJson", "(Lcom/google/gson/JsonObject;Ljava/io/File;)V", "Lio/github/moulberry/notenoughupdates/events/RepositoryReloadEvent;", "onNeuRepoReload", "(Lio/github/moulberry/notenoughupdates/events/RepositoryReloadEvent;)V", "manual", "resetRepositoryLocation", "checkRepoLocation", "Ljava/io/File;", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson", "latestRepoCommit", "Ljava/lang/String;", "repoLocation", "getRepoLocation", "()Ljava/io/File;", "error", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastRepoUpdate", "J", "Ljava/util/concurrent/atomic/AtomicBoolean;", "atomicShouldManuallyReload", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoManager.kt\nat/hannibal2/skyhanni/data/repo/RepoManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class RepoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File configLocation;
    @Nullable
    private String latestRepoCommit;
    @NotNull
    private final File repoLocation;
    private boolean error;
    private long lastRepoUpdate;
    @NotNull
    private final AtomicBoolean atomicShouldManuallyReload;
    @NotNull
    private static final List<String> successfulConstants = new ArrayList();
    @NotNull
    private static final List<String> unsuccessfulConstants = new ArrayList();
    @Nullable
    private static String lastConstant;

    public RepoManager(@NotNull File configLocation) {
        Intrinsics.checkNotNullParameter(configLocation, "configLocation");
        this.configLocation = configLocation;
        this.repoLocation = new File(this.configLocation, "repo");
        this.lastRepoUpdate = SimpleTimeMark.Companion.farPast();
        this.atomicShouldManuallyReload = new AtomicBoolean(false);
    }

    private final Gson getGson() {
        return ConfigManager.Companion.getGson();
    }

    @NotNull
    public final File getRepoLocation() {
        return this.repoLocation;
    }

    public final void loadRepoInformation() {
        this.atomicShouldManuallyReload.set(true);
        CompletionStage completionStage = ((Companion)RepoManager.Companion).getConfig().repoAutoUpdate ? this.fetchRepository(false).thenRun(() -> RepoManager.reloadRepository$default(this, null, 1, null)) : RepoManager.reloadRepository$default(this, null, 1, null);
    }

    public final void updateRepo() {
        this.atomicShouldManuallyReload.set(true);
        this.checkRepoLocation();
        this.fetchRepository(true).thenRun(() -> RepoManager.updateRepo$lambda$0(this));
    }

    public final void reloadLocalRepo() {
        this.atomicShouldManuallyReload.set(true);
        this.reloadRepository("Repo loaded from local files successfully.");
    }

    private final CompletableFuture<Boolean> fetchRepository(boolean command2) {
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> RepoManager.fetchRepository$lambda$3(this, command2));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    private final CompletableFuture<Void> reloadRepository(String answerMessage) {
        CompletableFuture<Void> comp = new CompletableFuture<Void>();
        if (!this.atomicShouldManuallyReload.get()) {
            return comp;
        }
        ErrorManager.INSTANCE.resetCache();
        DelayedRun.onThread.execute(() -> RepoManager.reloadRepository$lambda$7(this, comp, answerMessage));
        return comp;
    }

    static /* synthetic */ CompletableFuture reloadRepository$default(RepoManager repoManager, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        return repoManager.reloadRepository(string2);
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Repo Status");
        if (unsuccessfulConstants.isEmpty() && !((Collection)successfulConstants).isEmpty()) {
            event.addIrrelevant("Repo working fine");
            return;
        }
        event.addData(RepoManager::onDebugDataCollect$lambda$8);
    }

    public final void displayRepoStatus(boolean joinEvent) {
        if (joinEvent) {
            if (!((Collection)unsuccessfulConstants).isEmpty()) {
                List text = new ArrayList();
                text.add(Text.asComponent$default(Text.INSTANCE, "\u00a7c[SkyHanni-" + SkyHanniMod.Companion.getVersion() + "] \u00a77Repo Issue! Some features may not work. Please report this error on the Discord!", null, 1, null));
                text.add(Text.asComponent$default(Text.INSTANCE, "\u00a77Repo Auto Update Value: \u00a7c" + ((Companion)RepoManager.Companion).getConfig().repoAutoUpdate, null, 1, null));
                text.add(Text.asComponent$default(Text.INSTANCE, "\u00a77If you have Repo Auto Update turned off, please try turning that on.", null, 1, null));
                text.add(Text.asComponent$default(Text.INSTANCE, "\u00a7cUnsuccessful Constants \u00a77(" + unsuccessfulConstants.size() + "):", null, 1, null));
                for (String constant : unsuccessfulConstants) {
                    text.add(Text.asComponent$default(Text.INSTANCE, "   \u00a7e- \u00a77" + constant, null, 1, null));
                }
                Object[] objectArray = new Object[]{text};
                Text.send$default(Text.INSTANCE, Text.INSTANCE.multiline(objectArray), 0, 1, null);
            }
            return;
        }
        if (unsuccessfulConstants.isEmpty() && !((Collection)successfulConstants).isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Repo working fine! Commit hash: " + this.latestRepoCommit, false, "\u00a7a", 2, null);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Repo has errors! Commit has: ");
        String string2 = this.latestRepoCommit;
        if (string2 == null) {
            string2 = "null";
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, stringBuilder.append(string2).toString(), false, "\u00a7c", 2, null);
        if (!((Collection)successfulConstants).isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Successful Constants \u00a77(" + successfulConstants.size() + "):", false, "\u00a7a", 2, null);
        }
        for (String constant : successfulConstants) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "   \u00a7a- \u00a77" + constant, false, null, 4, null);
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Unsuccessful Constants \u00a77(" + unsuccessfulConstants.size() + "):", false, null, 6, null);
        for (String constant : unsuccessfulConstants) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "   \u00a7e- \u00a77" + constant, false, null, 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject getJsonFromFile(File file) {
        try {
            Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                JsonObject jsonObject2 = (JsonObject)this.getGson().fromJson((Reader)reader, JsonObject.class);
                return jsonObject2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    private final String getCommitApiUrl() {
        String repoUser = ((Companion)RepoManager.Companion).getConfig().location.user;
        String repoName = ((Companion)RepoManager.Companion).getConfig().location.name;
        String repoBranch = ((Companion)RepoManager.Companion).getConfig().location.branch;
        String string2 = "https://api.github.com/repos/%s/%s/commits/%s";
        Object[] objectArray = new Object[]{repoUser, repoName, repoBranch};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    private final String getDownloadUrl(String commitId) {
        String repoUser = ((Companion)RepoManager.Companion).getConfig().location.user;
        String repoName = ((Companion)RepoManager.Companion).getConfig().location.name;
        String string2 = "https://github.com/%s/%s/archive/%s.zip";
        Object[] objectArray = new Object[]{repoUser, repoName, commitId};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeJson(@Nullable JsonObject json, @NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        file.createNewFile();
        Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            writer.write(this.getGson().toJson((JsonElement)json));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @SubscribeEvent
    public final void onNeuRepoReload(@NotNull io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new NeuRepositoryReloadEvent().postAndCatch();
    }

    public final void resetRepositoryLocation(boolean manual) {
        String defaultUser = "hannibal002";
        String defaultName = "SkyHanni-Repo";
        String defaultBranch = "main";
        RepositoryConfig.RepositoryLocation $this$resetRepositoryLocation_u24lambda_u2412 = ((Companion)RepoManager.Companion).getConfig().location;
        boolean bl = false;
        if (Intrinsics.areEqual($this$resetRepositoryLocation_u24lambda_u2412.user, defaultUser) && Intrinsics.areEqual($this$resetRepositoryLocation_u24lambda_u2412.name, defaultName) && Intrinsics.areEqual($this$resetRepositoryLocation_u24lambda_u2412.branch, defaultBranch)) {
            if (manual) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Repo settings are already on default!", false, null, 6, null);
            }
            return;
        }
        $this$resetRepositoryLocation_u24lambda_u2412.user = defaultUser;
        $this$resetRepositoryLocation_u24lambda_u2412.name = defaultName;
        $this$resetRepositoryLocation_u24lambda_u2412.branch = defaultBranch;
        if (manual) {
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Reset Repo settings to default. Click \u00a7aUpdate Repo Now \u00a7ein config or run /shupdaterepo to update!", () -> RepoManager.resetRepositoryLocation$lambda$12$lambda$11(this), "\u00a7eClick to update the repo!", 0L, false, null, false, 120, null);
        }
    }

    public static /* synthetic */ void resetRepositoryLocation$default(RepoManager repoManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        repoManager.resetRepositoryLocation(bl);
    }

    private final void checkRepoLocation() {
        block3: {
            block2: {
                String string2 = ((Companion)RepoManager.Companion).getConfig().location.user;
                Intrinsics.checkNotNullExpressionValue(string2, "user");
                if (((CharSequence)string2).length() == 0) break block2;
                String string3 = ((Companion)RepoManager.Companion).getConfig().location.name;
                Intrinsics.checkNotNullExpressionValue(string3, "name");
                if (((CharSequence)string3).length() == 0) break block2;
                String string4 = ((Companion)RepoManager.Companion).getConfig().location.branch;
                Intrinsics.checkNotNullExpressionValue(string4, "branch");
                if (!(((CharSequence)string4).length() == 0)) break block3;
            }
            ChatUtils.INSTANCE.userError("Invalid Repo settings detected, resetting default settings.");
            RepoManager.resetRepositoryLocation$default(this, false, 1, null);
        }
    }

    private static final void updateRepo$lambda$0(RepoManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.reloadRepository("Repo updated successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean fetchRepository$lambda$3(RepoManager this$0, boolean $command) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            JsonObject jsonObject2;
            Object commits;
            JsonObject currentCommitJSON;
            block31: {
                block30: {
                    Pair[] pairArray;
                    currentCommitJSON = this$0.getJsonFromFile(new File(this$0.configLocation, "currentCommit.json"));
                    this$0.latestRepoCommit = null;
                    try {
                        Closeable closeable = new InputStreamReader(new URL(this$0.getCommitApiUrl()).openStream());
                        pairArray = null;
                        try {
                            Object inReader = (InputStreamReader)closeable;
                            boolean bl = false;
                            Object object = this$0.getGson().fromJson((Reader)inReader, JsonObject.class);
                            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
                            commits = (JsonObject)object;
                            this$0.latestRepoCommit = commits.get("sha").getAsString();
                            inReader = Unit.INSTANCE;
                        }
                        catch (Throwable inReader) {
                            pairArray = inReader;
                            throw inReader;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, (Throwable)pairArray);
                        }
                    }
                    catch (Exception e) {
                        pairArray = new Pair[]{TuplesKt.to("command", $command), TuplesKt.to("currentCommitJSON", currentCommitJSON)};
                        ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while loading data from repo", pairArray, false, false, false, 56, null);
                    }
                    if (this$0.latestRepoCommit == null) break block30;
                    String string2 = this$0.latestRepoCommit;
                    Intrinsics.checkNotNull(string2);
                    if (!(((CharSequence)string2).length() == 0)) break block31;
                }
                return false;
            }
            File file = new File(this$0.configLocation, "repo");
            if (file.exists() && Intrinsics.areEqual((jsonObject2 = currentCommitJSON) != null && (jsonObject2 = jsonObject2.get("sha")) != null ? jsonObject2.getAsString() : null, this$0.latestRepoCommit) && unsuccessfulConstants.isEmpty()) {
                if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(this$0.lastRepoUpdate), DurationKt.toDuration(1, DurationUnit.MINUTES)) < 0) {
                    if ($command) {
                        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77The repo is already up to date!", false, null, 6, null);
                        this$0.atomicShouldManuallyReload.set(false);
                    }
                    return false;
                }
            }
            this$0.lastRepoUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
            RepoUtils.INSTANCE.recursiveDelete(this$0.repoLocation);
            this$0.repoLocation.mkdirs();
            File itemsZip = new File(this$0.repoLocation, "sh-repo-main.zip");
            try {
                itemsZip.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
            URL url = new URL(this$0.getDownloadUrl(this$0.latestRepoCommit));
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(15000);
            urlConnection.setReadTimeout(30000);
            try {
                commits = urlConnection.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream is = (InputStream)commits;
                    boolean bl = false;
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)itemsZip);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)commits, throwable);
                }
            }
            catch (IOException e) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("url", url), TuplesKt.to("command", $command)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed to download SkyHanni Repo", pairArray, false, false, false, 56, null);
                return false;
            }
            String string3 = itemsZip.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string3, "getAbsolutePath(...)");
            String string4 = this$0.repoLocation.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string4, "getAbsolutePath(...)");
            RepoUtils.INSTANCE.unzipIgnoreFirstFolder(string3, string4);
            if (currentCommitJSON == null || !Intrinsics.areEqual(currentCommitJSON.get("sha").getAsString(), this$0.latestRepoCommit)) {
                JsonObject newCurrentCommitJSON = new JsonObject();
                newCurrentCommitJSON.addProperty("sha", this$0.latestRepoCommit);
                try {
                    this$0.writeJson(newCurrentCommitJSON, new File(this$0.configLocation, "currentCommit.json"));
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("command", $command)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed to download SkyHanni Repo", pairArray, false, false, false, 56, null);
        }
        return true;
    }

    private static final Unit reloadRepository$lambda$7$lambda$5(RepoManager this$0, Throwable it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.error = true;
        String string2 = lastConstant;
        if (string2 != null) {
            String it2 = string2;
            boolean bl = false;
            unsuccessfulConstants.add(it2);
        }
        lastConstant = null;
        return Unit.INSTANCE;
    }

    private static final Unit reloadRepository$lambda$7$lambda$6() {
        SkyHanniMod.Companion.getRepo().updateRepo();
        return Unit.INSTANCE;
    }

    private static final void reloadRepository$lambda$7(RepoManager this$0, CompletableFuture $comp, String $answerMessage) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($comp, "$comp");
        Intrinsics.checkNotNullParameter($answerMessage, "$answerMessage");
        this$0.error = false;
        successfulConstants.clear();
        unsuccessfulConstants.clear();
        lastConstant = null;
        LorenzEvent.postAndCatchAndBlock$default(new RepositoryReloadEvent(this$0.repoLocation, this$0.getGson()), false, false, true, arg_0 -> RepoManager.reloadRepository$lambda$7$lambda$5(this$0, arg_0), 3, null);
        $comp.complete(null);
        if (((CharSequence)$answerMessage).length() > 0 && !this$0.error) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7a" + $answerMessage, false, null, 6, null);
        }
        if (this$0.error) {
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Error with the repo detected, try /shupdaterepo to fix it!", RepoManager::reloadRepository$lambda$7$lambda$6, "\u00a7eClick to update the repo!", 0L, false, "\u00a7c", false, 88, null);
            if (unsuccessfulConstants.isEmpty()) {
                unsuccessfulConstants.add("All Constants");
            }
        }
    }

    private static final Unit onDebugDataCollect$lambda$8(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Successful Constants (" + successfulConstants.size() + "):");
        $this$addData.add("Unsuccessful Constants (" + unsuccessfulConstants.size() + "):");
        Iterator iterator2 = ((Iterable)unsuccessfulConstants).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            String constant = (String)iterator2.next();
            $this$addData.add("   - " + constant);
            if (i2 != 5) continue;
            $this$addData.add("...");
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit resetRepositoryLocation$lambda$12$lambda$11(RepoManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.updateRepo();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoManager$Companion;", "", "<init>", "()V", "", "constant", "", "setLastConstant", "(Ljava/lang/String;)V", "getRepoLocation", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/features/dev/RepositoryConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/RepositoryConfig;", "config", "", "successfulConstants", "Ljava/util/List;", "getSuccessfulConstants", "()Ljava/util/List;", "unsuccessfulConstants", "getUnsuccessfulConstants", "lastConstant", "Ljava/lang/String;", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        private final RepositoryConfig getConfig() {
            return SkyHanniMod.feature.dev.repo;
        }

        @NotNull
        public final List<String> getSuccessfulConstants() {
            return successfulConstants;
        }

        @NotNull
        public final List<String> getUnsuccessfulConstants() {
            return unsuccessfulConstants;
        }

        public final void setLastConstant(@NotNull String constant) {
            Intrinsics.checkNotNullParameter(constant, "constant");
            String string2 = lastConstant;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                Companion.getSuccessfulConstants().add(it);
            }
            lastConstant = constant;
        }

        @NotNull
        public final String getRepoLocation() {
            return this.getConfig().location.user + '/' + this.getConfig().location.name + '/' + this.getConfig().location.branch;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

