/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.hypixel.chat;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.hypixel.chat.event.AbstractChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.CoopChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.GuildChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.NpcChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.PartyChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.PlayerAllChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.PlayerShowItemChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.PrivateMessageChatEvent;
import at.hannibal2.skyhanni.data.hypixel.chat.event.SystemMessageEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.utils.ComponentMatcher;
import at.hannibal2.skyhanni.utils.ComponentMatcherUtils;
import at.hannibal2.skyhanni.utils.ComponentSpan;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\u00020\n*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\bJ\u001b\u0010\u000f\u001a\u00020\u0006*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0016\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010#\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u001fR\u001b\u0010&\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001d\u001a\u0004\b%\u0010\u001fR\u001b\u0010)\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001d\u001a\u0004\b(\u0010\u001fR\u001b\u0010,\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001d\u001a\u0004\b+\u0010\u001fR\u001b\u0010/\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u001d\u001a\u0004\b.\u0010\u001fR\u001b\u00102\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u001d\u001a\u0004\b1\u0010\u001fR\u001b\u00105\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u001d\u001a\u0004\b4\u0010\u001f\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/data/hypixel/chat/PlayerChatManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/utils/ComponentMatcher;", "", "isGlobalChat", "(Lat/hannibal2/skyhanni/utils/ComponentMatcher;Lat/hannibal2/skyhanni/events/LorenzChatEvent;)Z", "sendSystemMessage", "Lat/hannibal2/skyhanni/data/hypixel/chat/event/AbstractChatEvent;", "postChat", "(Lat/hannibal2/skyhanni/data/hypixel/chat/event/AbstractChatEvent;Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "cancelled", "", "blockedReason", "Lnet/minecraft/util/IChatComponent;", "chatComponent", "handleChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;ZLjava/lang/String;Lnet/minecraft/util/IChatComponent;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "globalPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getGlobalPattern", "()Ljava/util/regex/Pattern;", "globalPattern", "partyPattern$delegate", "getPartyPattern", "partyPattern", "coopPattern$delegate", "getCoopPattern", "coopPattern", "guildPattern$delegate", "getGuildPattern", "guildPattern", "privateMessagePattern$delegate", "getPrivateMessagePattern", "privateMessagePattern", "itemShowPattern$delegate", "getItemShowPattern", "itemShowPattern", "privateIslandRankPattern$delegate", "getPrivateIslandRankPattern", "privateIslandRankPattern", "privateIslandGuestPattern$delegate", "getPrivateIslandGuestPattern", "privateIslandGuestPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPlayerChatManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerChatManager.kt\nat/hannibal2/skyhanni/data/hypixel/chat/PlayerChatManager\n+ 2 ComponentMatcherUtils.kt\nat/hannibal2/skyhanni/utils/ComponentMatcherUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n52#2:232\n52#2:234\n52#2:236\n52#2:238\n52#2:240\n52#2:242\n52#2:244\n52#2:246\n1#3:233\n1#3:235\n1#3:237\n1#3:239\n1#3:241\n1#3:243\n1#3:245\n1#3:247\n*S KotlinDebug\n*F\n+ 1 PlayerChatManager.kt\nat/hannibal2/skyhanni/data/hypixel/chat/PlayerChatManager\n*L\n118#1:232\n124#1:234\n129#1:236\n138#1:238\n145#1:240\n161#1:242\n179#1:244\n185#1:246\n118#1:233\n124#1:235\n129#1:237\n138#1:239\n145#1:241\n161#1:243\n179#1:245\n185#1:247\n*E\n"})
public final class PlayerChatManager {
    @NotNull
    public static final PlayerChatManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern globalPattern$delegate;
    @NotNull
    private static final RepoPattern partyPattern$delegate;
    @NotNull
    private static final RepoPattern coopPattern$delegate;
    @NotNull
    private static final RepoPattern guildPattern$delegate;
    @NotNull
    private static final RepoPattern privateMessagePattern$delegate;
    @NotNull
    private static final RepoPattern itemShowPattern$delegate;
    @NotNull
    private static final RepoPattern privateIslandRankPattern$delegate;
    @NotNull
    private static final RepoPattern privateIslandGuestPattern$delegate;

    private PlayerChatManager() {
    }

    private final Pattern getGlobalPattern() {
        return (Pattern)globalPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getPartyPattern() {
        return (Pattern)partyPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getCoopPattern() {
        return (Pattern)coopPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getGuildPattern() {
        return (Pattern)guildPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getPrivateMessagePattern() {
        return (Pattern)privateMessagePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    private final Pattern getItemShowPattern() {
        return (Pattern)itemShowPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[5]);
    }

    private final Pattern getPrivateIslandRankPattern() {
        return (Pattern)privateIslandRankPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[6]);
    }

    private final Pattern getPrivateIslandGuestPattern() {
        return (Pattern)privateIslandGuestPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[7]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        ComponentMatcherUtils this_$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ComponentSpan chatComponent = ComponentMatcherUtils.INSTANCE.intoSpan(event.getChatComponent()).stripHypixelMessage();
        ComponentMatcherUtils componentMatcherUtils = ComponentMatcherUtils.INSTANCE;
        Pattern $this$matchStyledMatcher$iv = this.getCoopPattern();
        boolean $i$f$matchStyledMatcher = false;
        ComponentMatcher it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        boolean bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            ComponentSpan author = $this$onChat_u24lambda_u240.groupOrThrow("author");
            ComponentSpan message = $this$onChat_u24lambda_u240.groupOrThrow("message");
            INSTANCE.postChat(new CoopChatEvent(author, message, event.getChatComponent(), null, 8, null), event);
            return;
        }
        this_$iv = ComponentMatcherUtils.INSTANCE;
        $this$matchStyledMatcher$iv = this.getPartyPattern();
        $i$f$matchStyledMatcher = false;
        it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            INSTANCE.postChat(new PartyChatEvent($this$onChat_u24lambda_u241.groupOrThrow("author"), $this$onChat_u24lambda_u241.groupOrThrow("message"), event.getChatComponent(), null, 8, null), event);
            return;
        }
        this_$iv = ComponentMatcherUtils.INSTANCE;
        $this$matchStyledMatcher$iv = this.getGuildPattern();
        $i$f$matchStyledMatcher = false;
        it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            INSTANCE.postChat(new GuildChatEvent($this$onChat_u24lambda_u242.groupOrThrow("author"), $this$onChat_u24lambda_u242.groupOrThrow("message"), $this$onChat_u24lambda_u242.group("guildRank"), event.getChatComponent(), null, 16, null), event);
            return;
        }
        this_$iv = ComponentMatcherUtils.INSTANCE;
        $this$matchStyledMatcher$iv = this.getPrivateMessagePattern();
        $i$f$matchStyledMatcher = false;
        it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl5 = false;
            String direction = $this$onChat_u24lambda_u243.groupOrThrow("direction").getText();
            ComponentSpan author = $this$onChat_u24lambda_u243.groupOrThrow("author");
            ComponentSpan message = $this$onChat_u24lambda_u243.groupOrThrow("message");
            INSTANCE.postChat(new PrivateMessageChatEvent(direction, author, message, event.getChatComponent(), null, 16, null), event);
            return;
        }
        this_$iv = ComponentMatcherUtils.INSTANCE;
        $this$matchStyledMatcher$iv = this.getItemShowPattern();
        $i$f$matchStyledMatcher = false;
        it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u244 = it$iv;
            boolean bl6 = false;
            ComponentSpan level = $this$onChat_u24lambda_u244.group("level");
            ComponentSpan author = $this$onChat_u24lambda_u244.groupOrThrow("author");
            ComponentSpan action = $this$onChat_u24lambda_u244.groupOrThrow("action");
            ComponentSpan itemName = $this$onChat_u24lambda_u244.groupOrThrow("itemName");
            INSTANCE.postChat(new PlayerShowItemChatEvent(level, action, author, itemName, author.plus(action).plus(itemName), event.getChatComponent(), null, 64, null), event);
            return;
        }
        this_$iv = ComponentMatcherUtils.INSTANCE;
        $this$matchStyledMatcher$iv = this.getGlobalPattern();
        $i$f$matchStyledMatcher = false;
        it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, chatComponent);
        bl = false;
        if (it$iv.matches()) {
            ComponentMatcher $this$onChat_u24lambda_u245 = it$iv;
            boolean bl7 = false;
            if (INSTANCE.isGlobalChat($this$onChat_u24lambda_u245, event)) {
                return;
            }
        }
        this.sendSystemMessage(event);
    }

    private final boolean isGlobalChat(ComponentMatcher $this$isGlobalChat, LorenzChatEvent event) {
        ComponentSpan author = null;
        author = $this$isGlobalChat.groupOrThrow("author");
        ComponentSpan message = $this$isGlobalChat.groupOrThrow("message").removePrefix("\u00a7f");
        if (StringsKt.contains$default((CharSequence)author.getText(), "[NPC]", false, 2, null)) {
            this.postChat(new NpcChatEvent(author, message, event.getChatComponent(), null, 8, null), event);
            return true;
        }
        ComponentSpan privateIslandRank = null;
        ComponentSpan privateIslandGuest = null;
        if (LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND) || LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND_GUEST)) {
            ComponentSpan suffix;
            ComponentSpan prefix;
            Pattern $this$matchStyledMatcher$iv;
            ComponentMatcherUtils this_$iv;
            ComponentMatcherUtils componentMatcherUtils = ComponentMatcherUtils.INSTANCE;
            Pattern pattern = this.getPrivateIslandGuestPattern();
            ComponentSpan span$iv = author;
            boolean $i$f$matchStyledMatcher = false;
            ComponentMatcher it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, span$iv);
            boolean bl = false;
            if (it$iv.matches()) {
                ComponentMatcher $this$isGlobalChat_u24lambda_u246 = it$iv;
                boolean bl2 = false;
                privateIslandGuest = $this$isGlobalChat_u24lambda_u246.groupOrThrow("guest");
                prefix = $this$isGlobalChat_u24lambda_u246.groupOrThrow("prefix");
                suffix = $this$isGlobalChat_u24lambda_u246.groupOrThrow("suffix");
                author = prefix.plus(suffix);
            }
            this_$iv = ComponentMatcherUtils.INSTANCE;
            $this$matchStyledMatcher$iv = this.getPrivateIslandRankPattern();
            span$iv = author;
            $i$f$matchStyledMatcher = false;
            it$iv = this_$iv.styledMatcher($this$matchStyledMatcher$iv, span$iv);
            bl = false;
            if (it$iv.matches()) {
                ComponentMatcher $this$isGlobalChat_u24lambda_u247 = it$iv;
                boolean bl3 = false;
                privateIslandRank = $this$isGlobalChat_u24lambda_u247.groupOrThrow("privateIslandRank");
                prefix = $this$isGlobalChat_u24lambda_u247.groupOrThrow("prefix");
                suffix = $this$isGlobalChat_u24lambda_u247.groupOrThrow("suffix");
                author = prefix.plus(suffix);
            }
        }
        this.postChat(new PlayerAllChatEvent($this$isGlobalChat.group("level"), privateIslandRank, privateIslandGuest, $this$isGlobalChat.groupOrThrow("chatColor").getText(), author, message, event.getChatComponent(), null, 128, null), event);
        return true;
    }

    private final void sendSystemMessage(LorenzChatEvent event) {
        SystemMessageEvent $this$sendSystemMessage_u24lambda_u248 = new SystemMessageEvent(event.getMessage(), event.getChatComponent(), null, 4, null);
        boolean bl = false;
        boolean cancelled = $this$sendSystemMessage_u24lambda_u248.postAndCatch();
        INSTANCE.handleChat(event, cancelled, $this$sendSystemMessage_u24lambda_u248.getBlockedReason(), $this$sendSystemMessage_u24lambda_u248.getChatComponent());
    }

    private final void postChat(AbstractChatEvent $this$postChat, LorenzChatEvent event) {
        boolean cancelled = $this$postChat.postAndCatch();
        this.handleChat(event, cancelled, $this$postChat.getBlockedReason(), $this$postChat.getChatComponent());
    }

    private final void handleChat(LorenzChatEvent $this$handleChat, boolean cancelled, String blockedReason, IChatComponent chatComponent) {
        if (cancelled) {
            $this$handleChat.cancel();
        }
        String string2 = blockedReason;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            $this$handleChat.setBlockedReason(it);
        }
        $this$handleChat.setChatComponent(chatComponent);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "globalPattern", "getGlobalPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "partyPattern", "getPartyPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "coopPattern", "getCoopPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "guildPattern", "getGuildPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "privateMessagePattern", "getPrivateMessagePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "itemShowPattern", "getItemShowPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "privateIslandRankPattern", "getPrivateIslandRankPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PlayerChatManager.class, "privateIslandGuestPattern", "getPrivateIslandGuestPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PlayerChatManager();
        patternGroup = RepoPattern.Companion.group("data.chat.player");
        globalPattern$delegate = patternGroup.pattern("global", "(?:\\[(?<level>\\d+)] )?(?<author>.+)(?<chatColor>\u00a7f|\u00a77): (?<message>.*)");
        partyPattern$delegate = patternGroup.pattern("party", "\u00a79Party \u00a78> (?<author>[^:]*)\u00a7f: (?<message>.*)");
        coopPattern$delegate = patternGroup.pattern("coop", "\u00a7bCo-op > (?<author>[^:]+)\u00a7f: (?<message>.*)");
        guildPattern$delegate = patternGroup.pattern("guild", "\u00a72Guild > (?<author>.+?) ?(?<guildRank>\u00a7e\\[\\w*])?\u00a7f: (?<message>.*)");
        privateMessagePattern$delegate = patternGroup.pattern("privatemessage", "^(?!From stash: )(?<direction>From|To) (?<author>[^:]*): (?<message>.*)");
        itemShowPattern$delegate = patternGroup.pattern("itemshow", "(?:\u00a78\\[(?<levelColor>\u00a7.)(?<level>\\d+)\u00a78] )?(?<author>.*)\u00a7f\u00a77 (?<action>is (?:holding|friends with a|wearing)|has) (?<itemName>.*)");
        privateIslandRankPattern$delegate = patternGroup.pattern("privateislandrank", "(?<prefix>.*?)(?<privateIslandRank>\u00a7.\\[(?!MVP(\u00a7.\\++)?\u00a7.]|VIP\\+*|YOU\u00a7.TUBE|ADMIN|MOD|GM)[^]]+\\]) (?<suffix>.*)");
        privateIslandGuestPattern$delegate = patternGroup.pattern("privateislandguest", "(?<prefix>.*)(?<guest>\u00a7a\\[\u270c] )(?<suffix>.*)");
    }
}

