/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.misc.TrackerConfig;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001b\u0010\u0010\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/data/TrackerManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlayFirst", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "onRenderOverlayLast", "", "", "args", "commandEditTracker", "([Ljava/lang/String;)V", "", "hasChanged", "Z", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "commandEditTrackerSuccess", "getCommandEditTrackerSuccess", "setCommandEditTrackerSuccess", "1.8.9"})
public final class TrackerManager {
    @NotNull
    public static final TrackerManager INSTANCE = new TrackerManager();
    private static boolean hasChanged;
    private static boolean dirty;
    private static boolean commandEditTrackerSuccess;

    private TrackerManager() {
    }

    public final boolean getDirty() {
        return dirty;
    }

    public final void setDirty(boolean bl) {
        dirty = bl;
    }

    public final boolean getCommandEditTrackerSuccess() {
        return commandEditTrackerSuccess;
    }

    public final void setCommandEditTrackerSuccess(boolean bl) {
        commandEditTrackerSuccess = bl;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        TrackerConfig.HideCheapItemsConfig config = SkyHanniMod.feature.misc.tracker.hideCheapItems;
        Property[] propertyArray = new Property[]{config.alwaysShowBest, config.minPrice, config.enabled};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, TrackerManager::onConfigLoad$lambda$0);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onRenderOverlayFirst(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (hasChanged) {
            dirty = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onRenderOverlayLast(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (hasChanged) {
            dirty = false;
            hasChanged = false;
        }
    }

    public final void commandEditTracker(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length < 2) {
            ChatUtils.INSTANCE.userError("Usage: /shedittracker <item name> <amount>");
            return;
        }
        Integer n = NumberUtil.INSTANCE.formatIntOrUserError(ArraysKt.last(args2));
        if (n == null) {
            return;
        }
        int amount = n;
        if (amount == 0) {
            ChatUtils.INSTANCE.userError("Amount can not be zero!");
            return;
        }
        String rawName = CollectionsKt.joinToString$default(ArraysKt.dropLast(args2, 1), " ", null, null, 0, null, null, 62, null);
        NEUInternalName internalName = NEUInternalName.Companion.fromItemNameOrInternalName(rawName);
        if (!internalName.isKnownItem()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "No item found for '" + rawName + "'!", false, null, 6, null);
            return;
        }
        commandEditTrackerSuccess = false;
        new ItemAddEvent(internalName, amount, ItemAddManager.Source.COMMAND).postAndCatch();
        if (!commandEditTrackerSuccess) {
            ChatUtils.INSTANCE.userError("Could not edit the Item Tracker! Does this item belong to this tracker? Is the tracker active right now?");
        }
    }

    private static final void onConfigLoad$lambda$0() {
        hasChanged = true;
    }
}

