/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.LocationFixJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.utils.LocationUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR(\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/data/LocationFixData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/data/IslandType;", "skyBlockIsland", "", "fixLocation", "(Lat/hannibal2/skyhanni/data/IslandType;)Ljava/lang/String;", "", "", "Lat/hannibal2/skyhanni/data/LocationFixData$LocationFix;", "locationFixes", "Ljava/util/Map;", "LocationFix", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nLocationFixData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationFixData.kt\nat/hannibal2/skyhanni/data/LocationFixData\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n12#2,7:45\n1#3:52\n*S KotlinDebug\n*F\n+ 1 LocationFixData.kt\nat/hannibal2/skyhanni/data/LocationFixData\n*L\n21#1:45,7\n*E\n"})
public final class LocationFixData {
    @NotNull
    public static final LocationFixData INSTANCE = new LocationFixData();
    @NotNull
    private static Map<IslandType, List<LocationFix>> locationFixes = new LinkedHashMap();

    private LocationFixData() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        LocationFixJson locationFixJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "LocationFix";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            locationFixJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, LocationFixJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        LocationFixJson data2 = locationFixJson;
        locationFixes.clear();
        for (at.hannibal2.skyhanni.data.jsonobjects.repo.LocationFix fix : data2.getLocationFixes().values()) {
            IslandType island = IslandType.Companion.getByName(fix.getIslandName());
            AxisAlignedBB area = fix.getA().axisAlignedTo(fix.getB());
            String realLocation = fix.getRealLocation();
            List<LocationFix> list = locationFixes.get((Object)island);
            LocationFix locationFix = new LocationFix(area, realLocation);
            if (list == null) {
                locationFixes.put(island, CollectionsKt.listOf(locationFix));
                continue;
            }
            locationFixes.put(island, CollectionsKt.plus((Collection)list, locationFix));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String fixLocation(@NotNull IslandType skyBlockIsland) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)skyBlockIsland, "skyBlockIsland");
            List<LocationFix> list = locationFixes.get((Object)skyBlockIsland);
            if (list == null) return null;
            Iterable iterable = list;
            for (Object t : iterable) {
                LocationFix it = (LocationFix)t;
                boolean bl = false;
                if (!LocationUtils.INSTANCE.isPlayerInside(it.getArea())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        LocationFix locationFix = v0;
        if (locationFix == null) return null;
        String string2 = locationFix.getRealLocation();
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/data/LocationFixData$LocationFix;", "", "Lnet/minecraft/util/AxisAlignedBB;", "area", "", "realLocation", "<init>", "(Lnet/minecraft/util/AxisAlignedBB;Ljava/lang/String;)V", "component1", "()Lnet/minecraft/util/AxisAlignedBB;", "component2", "()Ljava/lang/String;", "copy", "(Lnet/minecraft/util/AxisAlignedBB;Ljava/lang/String;)Lat/hannibal2/skyhanni/data/LocationFixData$LocationFix;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/util/AxisAlignedBB;", "getArea", "Ljava/lang/String;", "getRealLocation", "1.8.9"})
    private static final class LocationFix {
        @NotNull
        private final AxisAlignedBB area;
        @NotNull
        private final String realLocation;

        public LocationFix(@NotNull AxisAlignedBB area, @NotNull String realLocation) {
            Intrinsics.checkNotNullParameter(area, "area");
            Intrinsics.checkNotNullParameter(realLocation, "realLocation");
            this.area = area;
            this.realLocation = realLocation;
        }

        @NotNull
        public final AxisAlignedBB getArea() {
            return this.area;
        }

        @NotNull
        public final String getRealLocation() {
            return this.realLocation;
        }

        @NotNull
        public final AxisAlignedBB component1() {
            return this.area;
        }

        @NotNull
        public final String component2() {
            return this.realLocation;
        }

        @NotNull
        public final LocationFix copy(@NotNull AxisAlignedBB area, @NotNull String realLocation) {
            Intrinsics.checkNotNullParameter(area, "area");
            Intrinsics.checkNotNullParameter(realLocation, "realLocation");
            return new LocationFix(area, realLocation);
        }

        public static /* synthetic */ LocationFix copy$default(LocationFix locationFix, AxisAlignedBB axisAlignedBB, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                axisAlignedBB = locationFix.area;
            }
            if ((n & 2) != 0) {
                string2 = locationFix.realLocation;
            }
            return locationFix.copy(axisAlignedBB, string2);
        }

        @NotNull
        public String toString() {
            return "LocationFix(area=" + this.area + ", realLocation=" + this.realLocation + ')';
        }

        public int hashCode() {
            int result2 = this.area.hashCode();
            result2 = result2 * 31 + this.realLocation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocationFix)) {
                return false;
            }
            LocationFix locationFix = (LocationFix)other;
            if (!Intrinsics.areEqual(this.area, locationFix.area)) {
                return false;
            }
            return Intrinsics.areEqual(this.realLocation, locationFix.realLocation);
        }
    }
}

