/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.events.EntityMoveEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWarpEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/data/EntityMovementData;", "", "<init>", "()V", "Lnet/minecraft/entity/Entity;", "entity", "", "addToTrack", "(Lnet/minecraft/entity/Entity;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Ljava/util/regex/Pattern;", "warpingPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getWarpingPattern", "()Ljava/util/regex/Pattern;", "warpingPattern", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "entityLocation", "Ljava/util/Map;", "1.8.9"})
public final class EntityMovementData {
    @NotNull
    public static final EntityMovementData INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern warpingPattern$delegate;
    @NotNull
    private static final Map<Entity, LorenzVec> entityLocation;

    private EntityMovementData() {
    }

    private final Pattern getWarpingPattern() {
        return (Pattern)warpingPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    public final void addToTrack(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (!entityLocation.containsKey(entity)) {
            entityLocation.put(entity, LorenzVecKt.getLorenzVec(entity));
        }
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        Intrinsics.checkNotNullExpressionValue(entityPlayerSP, "thePlayer");
        this.addToTrack((Entity)entityPlayerSP);
        for (Entity entity : entityLocation.keySet()) {
            LorenzVec oldLocation;
            if (entity.field_70128_L) continue;
            LorenzVec newLocation = LorenzVecKt.getLorenzVec(entity);
            Intrinsics.checkNotNull(entityLocation.get(entity));
            double distance = newLocation.distance(oldLocation);
            if (!(distance > 0.01)) continue;
            entityLocation.put(entity, newLocation);
            new EntityMoveEvent(entity, oldLocation, newLocation, distance).postAndCatch();
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getWarpingPattern(), event.getMessage())) {
            return;
        }
        DelayedRun.INSTANCE.runNextTick(EntityMovementData::onChat$lambda$0);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        entityLocation.clear();
    }

    private static final Unit onChat$lambda$0() {
        new LorenzWarpEvent().postAndCatch();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(EntityMovementData.class, "warpingPattern", "getWarpingPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new EntityMovementData();
        warpingPattern$delegate = RepoPattern.Companion.pattern("data.entity.warping", "\u00a77(?:Warping|Warping you to your SkyBlock island|Warping using transfer token|Finding player|Sending a visit request)\\.\\.\\.");
        entityLocation = new LinkedHashMap();
    }
}

