/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.misc.pets;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.misc.pets.PetExperienceToolTipConfig;
import at.hannibal2.skyhanni.config.features.misc.pets.PetNametagConfig;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PetConfig {
    @Expose
    @ConfigOption(name="Pet Display", desc="Show the currently active pet.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean display = false;
    @Expose
    @ConfigLink(owner=PetConfig.class, field="display")
    public Position displayPos = new Position(-330, -15, false, true);
    @Expose
    @ConfigOption(name="Pet Experience Tooltip", desc="")
    @Accordion
    public PetExperienceToolTipConfig petExperienceToolTip = new PetExperienceToolTipConfig();
    @Expose
    @ConfigOption(name="Pet Nametag", desc="")
    @Accordion
    public PetNametagConfig nametag = new PetNametagConfig();
    @Expose
    @ConfigOption(name="Hide Autopet Messages", desc="Hide the autopet messages from chat.\n\u00a7eRequires the display to be enabled.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean hideAutopet = false;
    @Expose
    @ConfigOption(name="Show Pet Item", desc="Specify the pet items for which icons should be displayed next to pets.")
    @ConfigEditorDraggableList
    public List<PetItemsDisplay> petItemDisplay = new ArrayList<PetItemsDisplay>(Arrays.asList(PetItemsDisplay.XP_SHARE, PetItemsDisplay.TIER_BOOST));
    @Expose
    @ConfigOption(name="Pet Item Scale", desc="The scale at which the Pet Item will be displayed.")
    @ConfigEditorSlider(minValue=0.7f, maxValue=1.5f, minStep=0.05f)
    public float petItemDisplayScale = 0.9f;

    public static enum PetItemsDisplay {
        XP_SHARE("\u00a75\u2698", "Exp Share", "PET_ITEM_EXP_SHARE"),
        TIER_BOOST("\u00a7c\u25cf", "Tier Boost", "PET_ITEM_TIER_BOOST");

        private final String str;
        public final String icon;
        public final String item;

        private PetItemsDisplay(String icon, String name2, String item) {
            this.icon = icon;
            this.item = item;
            this.str = icon + " \u00a7ffor " + name2;
        }

        public String toString() {
            return this.str;
        }
    }
}

