/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.mining;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventType;
import com.google.gson.annotations.Expose;

public class MiningEventConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Show information about upcoming Dwarven Mines and Crystal Hollows mining events.\n\u00a7eAlso enables sending data from your client. May take up to a minute to sync new events.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = false;
    @Expose
    @ConfigOption(name="Show Outside Mining Islands", desc="Show the event tracker even if you're outside of the Dwarven Mines or Crystal Hollows.")
    @ConfigEditorBoolean
    public boolean outsideMining = false;
    @Expose
    @ConfigOption(name="What to Show", desc="Choose which island's events are shown in the GUI.")
    @ConfigEditorDropdown
    public ShowType showType = ShowType.ALL;
    @Expose
    @ConfigOption(name="Compressed Format", desc="Compress the event names so that they are shorter.")
    @ConfigEditorDropdown
    public MiningEventType.Companion.CompressFormat compressedFormat = MiningEventType.Companion.CompressFormat.DEFAULT;
    @Expose
    @ConfigOption(name="Compressed Island", desc="Show the islands only as an icon.")
    @ConfigEditorBoolean
    public boolean islandAsIcon = false;
    @Expose
    @ConfigOption(name="Show Passed Events", desc="Show the most recently passed event at the start, greyed out.\n\u00a7eTakes a little while to save the last event.")
    @ConfigEditorBoolean
    public boolean passedEvents = false;
    @Expose
    @ConfigLink(owner=MiningEventConfig.class, field="enabled")
    public Position position = new Position(200, 60, false, true);

    public static enum ShowType {
        ALL("All Mining Islands"),
        CRYSTAL("Crystal Hollows Only"),
        DWARVEN("Dwarven Mines Only"),
        CURRENT("Current Island Only");

        private final String str;

        private ShowType(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

