/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.inventory.customwardrobe;

import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.features.inventory.wardrobe.CustomWardrobeReset;
import com.google.gson.annotations.Expose;

public class SpacingConfig {
    @ConfigOption(name="Reset to Default", desc="Reset all custom wardrobe spacing settings to the default.")
    @ConfigEditorButton(buttonText="Reset")
    public Runnable resetSpacing = CustomWardrobeReset::resetSpacing;
    @Expose
    @ConfigOption(name="Global Scale", desc="Control the scale of the entirety of the wardrobe.")
    @ConfigEditorSlider(minValue=30.0f, maxValue=200.0f, minStep=1.0f)
    public Property<Integer> globalScale = Property.of(100);
    @Expose
    @ConfigOption(name="Outline Thickness", desc="How thick the outline of the hovered slot is.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=15.0f, minStep=1.0f)
    public Property<Integer> outlineThickness = Property.of(5);
    @Expose
    @ConfigOption(name="Outline Blur", desc="Amount of blur of the outline.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=1.0f, minStep=0.1f)
    public Property<Float> outlineBlur = Property.of(Float.valueOf(0.5f));
    @Expose
    @ConfigOption(name="Slot Width", desc="Width of the wardrobe slots.")
    @ConfigEditorSlider(minValue=30.0f, maxValue=100.0f, minStep=1.0f)
    public Property<Integer> slotWidth = Property.of(75);
    @Expose
    @ConfigOption(name="Slot Height", desc="Height of the wardrobe slots.")
    @ConfigEditorSlider(minValue=60.0f, maxValue=200.0f, minStep=1.0f)
    public Property<Integer> slotHeight = Property.of(140);
    @Expose
    @ConfigOption(name="Player Scale", desc="Scale of the players.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=100.0f, minStep=1.0f)
    public Property<Integer> playerScale = Property.of(75);
    @Expose
    @ConfigOption(name="Slots per Row", desc="Max amount of wardrobe slots per row.")
    @ConfigEditorSlider(minValue=5.0f, maxValue=18.0f, minStep=1.0f)
    public Property<Integer> maxPlayersPerRow = Property.of(9);
    @Expose
    @ConfigOption(name="Slots Horizontal Spacing", desc="How much space horizontally between wardrobe slots.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=20.0f, minStep=1.0f)
    public Property<Integer> horizontalSpacing = Property.of(3);
    @Expose
    @ConfigOption(name="Slots Vertical Spacing", desc="How much space vertically between wardrobe slots.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=20.0f, minStep=1.0f)
    public Property<Integer> verticalSpacing = Property.of(3);
    @Expose
    @ConfigOption(name="Slots & Buttons Spacing", desc="How much vertical space there is between wardrobe slots and the buttons.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=40.0f, minStep=1.0f)
    public Property<Integer> buttonSlotsVerticalSpacing = Property.of(10);
    @Expose
    @ConfigOption(name="Button Horizontal Spacing", desc="How much space horizontally between buttons.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=40.0f, minStep=1.0f)
    public Property<Integer> buttonHorizontalSpacing = Property.of(10);
    @Expose
    @ConfigOption(name="Button Vertical Spacing", desc="How much space vertically between buttons.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=40.0f, minStep=1.0f)
    public Property<Integer> buttonVerticalSpacing = Property.of(10);
    @Expose
    @ConfigOption(name="Button Width", desc="Width of the buttons.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=60.0f, minStep=1.0f)
    public Property<Integer> buttonWidth = Property.of(50);
    @Expose
    @ConfigOption(name="Button Height", desc="Height of the buttons.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=60.0f, minStep=1.0f)
    public Property<Integer> buttonHeight = Property.of(20);
    @Expose
    @ConfigOption(name="Background Padding", desc="Space between the edges of the background and the slots.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=20.0f, minStep=1.0f)
    public Property<Integer> backgroundPadding = Property.of(10);
}

