/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorText;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.utils.OSUtils;
import com.google.gson.annotations.Expose;
import org.jetbrains.annotations.NotNull;

public class ChocolateFactoryRabbitWarningConfig {
    @Expose
    @ConfigOption(name="Rabbit Warning", desc="Warn when the rabbit that needs to be clicked appears.")
    @ConfigEditorBoolean
    public boolean rabbitWarning = true;
    @Expose
    @ConfigOption(name="Special Rabbit Warning", desc="Warn when a special rabbit that needs to be clicked appears. (Rabbit The Fish and Golden Rabbits)")
    @ConfigEditorBoolean
    public boolean specialRabbitWarning = true;
    @Expose
    @ConfigOption(name="Warning Sound", desc="The sound that plays for a special rabbit.\n\u00a7eYou can use custom sounds, put it in the \u00a7bskyhanni/sounds \u00a7efolder in your resource pack.\n\u00a7eThen write \u00a7bskyhanni:yourfilename\n\u00a7cMust be a .ogg file")
    @ConfigEditorText
    public Property<String> specialRabbitSound = Property.of("note.pling");
    @Expose
    @ConfigOption(name="Repeat Sound", desc="How many times the sound should be repeated.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=20.0f, minStep=1.0f)
    public int repeatSound = 20;
    @Expose
    @ConfigOption(name="Flash Screen", desc="Choose the stray rabbit type to flash the screen for.")
    @ConfigEditorDropdown
    @NotNull
    public FlashScreenTypeEntry flashScreenType = FlashScreenTypeEntry.SPECIAL;
    @Expose
    @ConfigOption(name="Flash Color", desc="Color of the screen when flashing")
    @ConfigEditorColour
    public String flashColor = "0:127:0:238:255";
    @ConfigOption(name="Sounds", desc="Click to open the list of available sounds.")
    @ConfigEditorButton(buttonText="OPEN")
    public Runnable sounds = () -> OSUtils.openBrowser("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/mapping-and-modding-tutorials/2213619-1-8-all-playsound-sound-arguments");

    public static enum FlashScreenTypeEntry {
        SPECIAL("Special"),
        ALL("All"),
        NONE("None");

        private final String str;

        private FlashScreenTypeEntry(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

