/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryCustomReminderConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryKeybindsConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryRabbitWarningConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateShopPriceConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateUpgradeWarningsConfig;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityCollectionStats;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryStats;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChocolateFactoryConfig {
    @Expose
    @ConfigOption(name="Chocolate Factory Features", desc="Global toggle for all chocolate factory features.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = true;
    @Expose
    @ConfigOption(name="Chocolate Factory Stats", desc="Show general info about your chocolate factory.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean statsDisplay = true;
    @Expose
    @ConfigOption(name="Stats List", desc="Drag text to change what displays in the chocolate factory stats list and what order the text appears in.")
    @ConfigEditorDraggableList
    public List<ChocolateFactoryStats.ChocolateFactoryStat> statsDisplayList = new ArrayList<ChocolateFactoryStats.ChocolateFactoryStat>(Arrays.asList(ChocolateFactoryStats.ChocolateFactoryStat.HEADER, ChocolateFactoryStats.ChocolateFactoryStat.CURRENT, ChocolateFactoryStats.ChocolateFactoryStat.THIS_PRESTIGE, ChocolateFactoryStats.ChocolateFactoryStat.ALL_TIME, ChocolateFactoryStats.ChocolateFactoryStat.TIME_TO_PRESTIGE, ChocolateFactoryStats.ChocolateFactoryStat.EMPTY, ChocolateFactoryStats.ChocolateFactoryStat.PER_SECOND, ChocolateFactoryStats.ChocolateFactoryStat.PER_MINUTE, ChocolateFactoryStats.ChocolateFactoryStat.PER_HOUR, ChocolateFactoryStats.ChocolateFactoryStat.PER_DAY, ChocolateFactoryStats.ChocolateFactoryStat.EMPTY_2, ChocolateFactoryStats.ChocolateFactoryStat.MULTIPLIER, ChocolateFactoryStats.ChocolateFactoryStat.BARN, ChocolateFactoryStats.ChocolateFactoryStat.TIME_TOWER, ChocolateFactoryStats.ChocolateFactoryStat.TIME_TOWER_FULL, ChocolateFactoryStats.ChocolateFactoryStat.LEADERBOARD_POS, ChocolateFactoryStats.ChocolateFactoryStat.TIME_TO_BEST_UPGRADE));
    @Expose
    @ConfigOption(name="Show Stack Sizes", desc="Show additional info as many items in the chocolate menu as the stack size.")
    @ConfigEditorBoolean
    public boolean showStackSizes = true;
    @Expose
    @ConfigOption(name="Highlight Upgrades", desc="Highlight any upgrades that you can afford.\nThe upgrade with a star is the most optimal and the lightest color of green is the most optimal you can afford.")
    @ConfigEditorBoolean
    public boolean highlightUpgrades = true;
    @Expose
    @ConfigOption(name="Use Middle Click", desc="Click on slots with middle click to speed up interactions.")
    @ConfigEditorBoolean
    public boolean useMiddleClick = true;
    @Expose
    @ConfigOption(name="Rabbit Crush Threshold", desc="How close should you be to your barn capacity before being warned about needing to upgrade it.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=20.0f, minStep=1.0f)
    public int barnCapacityThreshold = 6;
    @Expose
    @ConfigOption(name="Rabbit Crush During Hoppity", desc="Only warn about rabbit crush when the Hoppity event is active.")
    @ConfigEditorBoolean
    public boolean rabbitCrushOnlyDuringHoppity = false;
    @Expose
    @ConfigOption(name="Extra Tooltip Stats", desc="Show extra information about upgrades in the tooltip.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean extraTooltipStats = true;
    @Expose
    @ConfigOption(name="Duplicate Rabbit Time", desc="Show the production time of chocolate gained from duplicate rabbits.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean showDuplicateTime = false;
    @Expose
    @ConfigOption(name="Stray Rabbit Time", desc="Show the production time of chocolate gained from stray rabbits.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean showStrayTime = false;
    @Expose
    @ConfigOption(name="Time Tower Usage Warning", desc="Notify when you have a new time tower usage available and continuously warn when your time tower is full.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean timeTowerWarning = false;
    @Expose
    @ConfigOption(name="Time Tower Expiry Reminder", desc="Notify when the time tower ends and you have one or more remaining charges.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean timeTowerReminder = true;
    @Expose
    @ConfigOption(name="Upgrade Warnings", desc="")
    @Accordion
    public ChocolateUpgradeWarningsConfig chocolateUpgradeWarnings = new ChocolateUpgradeWarningsConfig();
    @Expose
    @ConfigLink(owner=ChocolateFactoryConfig.class, field="statsDisplay")
    public Position position = new Position(163, 160, false, true);
    @Expose
    @ConfigOption(name="Compact On Click", desc="Compact the item tooltip when clicking on the chocolate.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean compactOnClick = true;
    @Expose
    @ConfigOption(name="Always Compact", desc="Always compact the item tooltip on the chocolate. Requires the above option to be enabled.")
    @ConfigEditorBoolean
    public boolean compactOnClickAlways = false;
    @Expose
    @ConfigOption(name="Tooltip Move", desc="Move tooltip away from the item you hover over while inside the Chocolate Factory.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean tooltipMove = false;
    @Expose
    @ConfigLink(owner=ChocolateFactoryConfig.class, field="tooltipMove")
    public Position tooltipMovePosition = new Position(-380, 150, false, true);
    @Expose
    @ConfigOption(name="Hoppity Collection Stats", desc="Show info about your Hoppity rabbit collection.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean hoppityCollectionStats = true;
    @Expose
    @ConfigLink(owner=ChocolateFactoryConfig.class, field="hoppityCollectionStats")
    public Position hoppityStatsPosition = new Position(163, 160, false, true);
    @Expose
    @ConfigOption(name="Leaderboard Change", desc="Show the change of your chocolate leaderboard over time in chat.\nThis updates every time you first open the \u00a7e/cf \u00a77menu on a new server.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean leaderboardChange = false;
    @Expose
    @ConfigOption(name="Hoppity Menu Shortcut", desc="Add a Chocolate Factory button in the SkyBlock Menu that runs \u00a7e/chocolatefactory \u00a77on click.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean hoppityMenuShortcut = true;
    @Expose
    @ConfigOption(name="Highlight Found Rabbits", desc="Highlight rabbits that have already been found.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean highlightFoundRabbits = false;
    @Expose
    @ConfigOption(name="Highlight Rabbits", desc="Highlight specific rabbit types in Hoppity's Collection.")
    @ConfigEditorDraggableList
    public List<HoppityCollectionStats.HighlightRabbitTypes> highlightRabbits = new ArrayList<HoppityCollectionStats.HighlightRabbitTypes>(Arrays.asList(HoppityCollectionStats.HighlightRabbitTypes.ABI, HoppityCollectionStats.HighlightRabbitTypes.FACTORY, HoppityCollectionStats.HighlightRabbitTypes.MET, HoppityCollectionStats.HighlightRabbitTypes.NOT_MET, HoppityCollectionStats.HighlightRabbitTypes.SHOP, HoppityCollectionStats.HighlightRabbitTypes.STRAYS));
    @Expose
    @ConfigOption(name="Re-color Missing Rabbit Dyes", desc="Replace the gray dye in Hoppity's Collection with a color for the rarity of the rabbit.")
    @ConfigEditorBoolean
    public boolean rarityDyeRecolor = true;
    @Expose
    @ConfigOption(name="Show Missing Location Rabbits", desc="Show the locations you have yet to find enough egg locations for in order to unlock the rabbit for that location.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean showLocationRequirementsRabbitsInHoppityStats = false;
    @Expose
    @ConfigOption(name="Rabbit Warning", desc="")
    @Accordion
    public ChocolateFactoryRabbitWarningConfig rabbitWarning = new ChocolateFactoryRabbitWarningConfig();
    @Expose
    @ConfigOption(name="Chocolate Shop Price", desc="")
    @Accordion
    public ChocolateShopPriceConfig chocolateShopPrice = new ChocolateShopPriceConfig();
    @Expose
    @ConfigOption(name="Chocolate Factory Keybinds", desc="")
    @Accordion
    public ChocolateFactoryKeybindsConfig keybinds = new ChocolateFactoryKeybindsConfig();
    @Expose
    @ConfigOption(name="Chocolate Factory Custom Reminder", desc="")
    @Accordion
    public ChocolateFactoryCustomReminderConfig customReminder = new ChocolateFactoryCustomReminderConfig();
    @Expose
    @ConfigOption(name="Mythic Rabbit", desc="Blocks running /cf without a \u00a7d\u00a7lMythic Rabbit Pet \u00a77equipped.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean mythicRabbitRequirement = false;
    @Expose
    @ConfigOption(name="Stray Tracker", desc="Track stray rabbits found in the Chocolate Factory menu.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean strayRabbitTracker = true;
    @Expose
    @ConfigLink(owner=ChocolateFactoryConfig.class, field="strayRabbitTracker")
    public Position strayRabbitTrackerPosition = new Position(300, 300, false, true);
}

