/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.garden.cropmilestones;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesOverflowConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.MushroomPetPerkConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.NextConfig;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CropMilestonesConfig {
    @Expose
    @ConfigOption(name="Progress Display", desc="Show the progress and ETA until the next crop milestone is reached and the current crops/minute value.\n\u00a7eRequires a tool with either a counter or Cultivating enchantment for full accuracy.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean progress = true;
    @Expose
    @ConfigOption(name="Overflow", desc="")
    @Accordion
    public CropMilestonesOverflowConfig overflow = new CropMilestonesOverflowConfig();
    @Expose
    @ConfigOption(name="Warn When Close", desc="Warn with title and sound when the next crop milestone upgrade happens in 5 seconds. Useful for switching to a different pet for leveling.")
    @ConfigEditorBoolean
    public boolean warnClose = false;
    @Expose
    @ConfigOption(name="Time Format", desc="Change the highest time unit to show (1h30m vs 90min)")
    @ConfigEditorDropdown
    public Property<TimeFormatEntry> highestTimeFormat = Property.of(TimeFormatEntry.YEAR);
    @Expose
    @ConfigOption(name="Maxed Milestone", desc="Calculate the progress and ETA till maxed milestone (46) instead of next milestone.")
    @ConfigEditorBoolean
    public Property<Boolean> bestShowMaxedNeeded = Property.of(false);
    @Expose
    @ConfigOption(name="Milestone Text", desc="Drag text to change the appearance of the overlay.\nHold a farming tool to show the overlay.")
    @ConfigEditorDraggableList
    public List<MilestoneTextEntry> text = new ArrayList<MilestoneTextEntry>(Arrays.asList(MilestoneTextEntry.TITLE, MilestoneTextEntry.MILESTONE_TIER, MilestoneTextEntry.NUMBER_OUT_OF_TOTAL, MilestoneTextEntry.TIME, MilestoneTextEntry.CROPS_PER_MINUTE, MilestoneTextEntry.BLOCKS_PER_SECOND));
    @Expose
    @ConfigOption(name="Block Broken Precision", desc="The amount of decimals displayed in blocks/second.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=6.0f, minStep=1.0f)
    public int blocksBrokenPrecision = 2;
    @Expose
    @ConfigOption(name="Seconds Before Reset", desc="How many seconds of not farming until blocks/second resets.")
    @ConfigEditorSlider(minValue=2.0f, maxValue=60.0f, minStep=1.0f)
    public int blocksBrokenResetTime = 5;
    @Expose
    @ConfigLink(owner=CropMilestonesConfig.class, field="progress")
    public Position progressDisplayPos = new Position(-400, -200, false, true);
    @Expose
    @ConfigOption(name="Best Crop", desc="")
    @Accordion
    public NextConfig next = new NextConfig();
    @Expose
    @ConfigOption(name="Mushroom Pet Perk", desc="")
    @Accordion
    public MushroomPetPerkConfig mushroomPetPerk = new MushroomPetPerkConfig();

    public static enum MilestoneTextEntry implements HasLegacyId
    {
        TITLE("\u00a76Crop Milestones", 0),
        MILESTONE_TIER("\u00a77Pumpkin Tier 22", 1),
        NUMBER_OUT_OF_TOTAL("\u00a7e12,300\u00a78/\u00a7e100,000", 2),
        TIME("\u00a77In \u00a7b12m 34s", 3),
        CROPS_PER_SECOND("\u00a77Crops/Second\u00a78: \u00a7e205.75"),
        CROPS_PER_MINUTE("\u00a77Crops/Minute\u00a78: \u00a7e12,345", 4),
        CROPS_PER_HOUR("\u00a77Crops/Hour\u00a78: \u00a7e740,700"),
        BLOCKS_PER_SECOND("\u00a77Blocks/Second\u00a78: \u00a7e19.85", 5),
        PERCENTAGE("\u00a77Percentage: \u00a7e12.34%", 6);

        private final String str;
        private final int legacyId;

        private MilestoneTextEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private MilestoneTextEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum TimeFormatEntry implements HasLegacyId
    {
        YEAR("Year", 0),
        DAY("Day", 1),
        HOUR("Hour", 2),
        MINUTE("Minute", 3),
        SECOND("Second", 4);

        private final String str;
        private final int legacyId;

        private TimeFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private TimeFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

