/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.garden;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;

public class SensitivityReducerConfig {
    @Expose
    @ConfigOption(name="Mode", desc="Lower mouse sensitivity while in the garden.")
    @ConfigEditorDropdown
    public Mode mode = Mode.OFF;
    @Expose
    @ConfigOption(name="Keybind", desc="When selected above, press this key to reduce the mouse sensitivity.")
    @ConfigEditorKeybind(defaultKey=49)
    public int keybind = 49;
    @Expose
    @ConfigOption(name="Reducing factor", desc="Change by how much the sensitivity is lowered by.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=50.0f, minStep=1.0f)
    public Property<Float> reducingFactor = Property.of(Float.valueOf(15.0f));
    @Expose
    @ConfigOption(name="Show GUI", desc="Show the GUI element while the feature is enabled.")
    @ConfigEditorBoolean
    public boolean showGUI = true;
    @Expose
    @ConfigOption(name="Only in Ground", desc="Lower sensitivity when standing on the ground.")
    @ConfigEditorBoolean
    public Property<Boolean> onGround = Property.of(false);
    @Expose
    @ConfigOption(name="Disable in Barn", desc="Disable reduced sensitivity in barn plot.")
    @ConfigEditorBoolean
    public Property<Boolean> onlyPlot = Property.of(true);
    @Expose
    @ConfigLink(owner=SensitivityReducerConfig.class, field="showGUI")
    public Position position = new Position(400, 400, 0.8f);

    public static enum Mode {
        OFF("Disabled"),
        TOOL("Holding farming tool"),
        KEYBIND("Holding Keybind");

        private final String str;

        private Mode(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

