/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.fishing.trophyfishing;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrophyFishDisplayConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Show a display of all trophy fishes ever caught.")
    @ConfigEditorBoolean
    @FeatureToggle
    public Property<Boolean> enabled = Property.of(false);
    @Expose
    @ConfigOption(name="When Show", desc="Change when the trophy fish display should be visible in Crimson Isle.")
    @ConfigEditorDropdown
    public Property<WhenToShow> whenToShow = Property.of(WhenToShow.ALWAYS);
    @Expose
    @ConfigOption(name="Keybind", desc="")
    @ConfigEditorKeybind(defaultKey=0)
    public int keybind = 0;
    @Expose
    @ConfigOption(name="Hunter Armor", desc="Only show when wearing a full Hunter Armor.")
    @ConfigEditorBoolean
    public Property<Boolean> requireHunterArmor = Property.of(false);
    @Expose
    @ConfigOption(name="Highlight New", desc="Highlight new trophies green for couple seconds.")
    @ConfigEditorBoolean
    public Property<Boolean> highlightNew = Property.of(true);
    @Expose
    @ConfigOption(name="Extra space", desc="Space between each line of text.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=10.0f, minStep=1.0f)
    public Property<Integer> extraSpace = Property.of(1);
    @Expose
    @ConfigOption(name="Sorted By", desc="Sorting type of items in sack.")
    @ConfigEditorDropdown
    public Property<TrophySorting> sortingType = Property.of(TrophySorting.ITEM_RARITY);
    @Expose
    @ConfigOption(name="Reverse Order", desc="Reverse the sorting order.")
    @ConfigEditorBoolean
    public Property<Boolean> reverseOrder = Property.of(false);
    @Expose
    @ConfigOption(name="Text Order", desc="Drag text to change the line format.")
    @ConfigEditorDraggableList
    public Property<List<TextPart>> textOrder = Property.of(new ArrayList<TextPart>(Arrays.asList(TextPart.NAME, TextPart.ICON, TextPart.TOTAL, TextPart.BRONZE, TextPart.SILVER, TextPart.GOLD, TextPart.DIAMOND)));
    @Expose
    @ConfigOption(name="Show \u2716", desc="Instead of the number 0, show \u00a7c\u2716 \u00a77if not found.")
    @ConfigEditorBoolean
    public Property<Boolean> showCross = Property.of(false);
    @Expose
    @ConfigOption(name="Show \u2714", desc="Instead of the exact numbers, show \u00a7e\u00a7l\u2714 \u00a77if found.")
    @ConfigEditorBoolean
    public Property<Boolean> showCheckmark = Property.of(false);
    @Expose
    @ConfigOption(name="Only Show Missing", desc="Only show Trophy Fishes that are still missing at this rarity.")
    @ConfigEditorDropdown
    public Property<HideCaught> onlyShowMissing = Property.of(HideCaught.NONE);
    @Expose
    @ConfigLink(owner=TrophyFishDisplayConfig.class, field="enabled")
    public Position position = new Position(144, 139, false, true);

    public static enum HideCaught {
        NONE("Show All"),
        BRONZE("Bronze"),
        SILVER("Silver"),
        GOLD("Gold"),
        DIAMOND("Diamond");

        private final String str;

        private HideCaught(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum TextPart {
        ICON("Item Icon"),
        NAME("Item Name"),
        BRONZE("Amount Bronze"),
        SILVER("Amount Silver"),
        GOLD("Amount Gold"),
        DIAMOND("Amount Diamond"),
        TOTAL("Amount Total");

        private final String str;

        private TextPart(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum TrophySorting {
        ITEM_RARITY("Item Rarity"),
        TOTAL_AMOUNT("Total Amount"),
        BRONZE_AMOUNT("Bronze Amount"),
        SILVER_AMOUNT("Silver Amount"),
        GOLD_AMOUNT("Gold Amount"),
        DIAMOND_AMOUNT("Diamond Amount"),
        HIGHEST_RARITY("Highest Rarity"),
        NAME("Name Alphabetical");

        private final String str;

        private TrophySorting(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum WhenToShow {
        ALWAYS("Always"),
        ONLY_IN_INVENTORY("In inventory"),
        ONLY_WITH_ROD_IN_HAND("Rod in hand"),
        ONLY_WITH_KEYBIND("On keybind");

        private final String str;

        private WhenToShow(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

