/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.combat.ghostcounter;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.combat.ghostcounter.textformatting.TextFormattingConfig;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.features.combat.ghostcounter.GhostUtil;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GhostCounterConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Enable the ghost counter (invisible creepers within The Mist in the Dwarven Mines)")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = true;
    @Expose
    @ConfigOption(name="Display Text", desc="Drag text to change the appearance of the overlay.")
    @ConfigEditorDraggableList
    public List<GhostDisplayEntry> ghostDisplayText = new ArrayList<GhostDisplayEntry>(Arrays.asList(GhostDisplayEntry.TITLE, GhostDisplayEntry.GHOSTS_KILLED, GhostDisplayEntry.SORROW, GhostDisplayEntry.GHOST_SINCE_SORROW, GhostDisplayEntry.GHOST_PER_SORROW, GhostDisplayEntry.AVG_MAGIC_FIND, GhostDisplayEntry.SCAVENGER_COINS, GhostDisplayEntry.KILL_COMBO, GhostDisplayEntry.HIGHEST_KILL_COMBO));
    @ConfigOption(name="Text Formatting", desc="")
    @Accordion
    @Expose
    public TextFormattingConfig textFormatting = new TextFormattingConfig();
    @Expose
    @ConfigOption(name="Extra Spaces", desc="Spaces between each line of text.")
    @ConfigEditorSlider(minValue=-5.0f, maxValue=10.0f, minStep=1.0f)
    public int extraSpace = 1;
    @Expose
    @ConfigOption(name="Pause Timer", desc="How many seconds to wait before pausing.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=20.0f, minStep=1.0f)
    public int pauseTimer = 3;
    @Expose
    @ConfigOption(name="Show only in The Mist", desc="Show the overlay only when you are in The Mist.")
    @ConfigEditorBoolean
    public boolean onlyOnMist = true;
    @Expose
    @ConfigOption(name="Max Bestiary", desc="Show progress to max bestiary instead of next level.")
    @ConfigEditorBoolean
    public boolean showMax = false;
    @ConfigOption(name="Reset", desc="Reset the counter.")
    @ConfigEditorButton(buttonText="Reset")
    public Runnable resetCounter = GhostUtil.INSTANCE::reset;
    @Expose
    @ConfigLink(owner=GhostCounterConfig.class, field="enabled")
    public Position position = new Position(50, 50, false, true);

    public static enum GhostDisplayEntry implements HasLegacyId
    {
        TITLE("\u00a76Ghosts Counter", 0),
        GHOSTS_KILLED("  \u00a7bGhost Killed: 42", 1),
        SORROW("  \u00a7bSorrow: 6", 2),
        GHOST_SINCE_SORROW("  \u00a7bGhost since Sorrow: 1", 3),
        GHOST_PER_SORROW("  \u00a7bGhosts/Sorrow: 5", 4),
        VOLTA("  \u00a7bVolta: 6", 5),
        PLASMA("  \u00a7bPlasma: 8", 6),
        GHOSTLY_BOOTS("  \u00a7bGhostly Boots: 1", 7),
        BAG_OF_CASH("  \u00a7bBag Of Cash: 4", 8),
        AVG_MAGIC_FIND("  \u00a7bAvg Magic Find: 271", 9),
        SCAVENGER_COINS("  \u00a7bScavenger Coins: 15,000", 10),
        KILL_COMBO("  \u00a7bKill Combo: 14", 11),
        HIGHEST_KILL_COMBO("  \u00a7bHighest Kill Combo: 96", 12),
        SKILL_XP_GAINED("  \u00a7bSkill XP Gained: 145,648", 13),
        BESTIARY("  \u00a7bBestiary 1: 0/10", 14),
        XP_PER_HOUR("  \u00a7bXP/h: 810,410", 15),
        KILLS_PER_HOUR("  \u00a7bKills/h: 420", 16),
        ETA("  \u00a7bETA: 14d", 17),
        MONEY_PER_HOUR("  \u00a7bMoney/h: 13,420,069", 18),
        MONEY_MADE("  \u00a7bMoney made: 14B", 19);

        private final String str;
        private final int legacyId;

        private GhostDisplayEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private GhostDisplayEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

