/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.combat.damageindicator;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.features.combat.damageindicator.EnderSlayerConfig;
import at.hannibal2.skyhanni.config.features.combat.damageindicator.VampireSlayerConfig;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DamageIndicatorConfig {
    @Expose
    @ConfigOption(name="Damage Indicator Enabled", desc="Show the boss' remaining health.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = false;
    @Expose
    @ConfigOption(name="Healing Chat Message", desc="Send a chat message when a boss heals themself.")
    @ConfigEditorBoolean
    public boolean healingMessage = false;
    @Expose
    @ConfigOption(name="Boss Name", desc="Change how boss names are displayed.")
    @ConfigEditorDropdown
    public NameVisibility bossName = NameVisibility.FULL_NAME;
    @Expose
    @ConfigOption(name="Select Boss", desc="Change what bosses the damage indicator should be enabled for.")
    @ConfigEditorDraggableList
    public List<BossCategory> bossesToShow = new ArrayList<BossCategory>(Arrays.asList(BossCategory.NETHER_MINI_BOSSES, BossCategory.VANQUISHER, BossCategory.REVENANT_HORROR, BossCategory.TARANTULA_BROODFATHER, BossCategory.SVEN_PACKMASTER, BossCategory.VOIDGLOOM_SERAPH, BossCategory.INFERNO_DEMONLORD, BossCategory.DIANA_MOBS, BossCategory.SEA_CREATURES, BossCategory.ARACHNE, BossCategory.BROODMOTHER, BossCategory.THE_RIFT_BOSSES, BossCategory.RIFTSTALKER_BLOODFIEND, BossCategory.REINDRAKE, BossCategory.GARDEN_PESTS));
    @Expose
    @ConfigOption(name="Hide Damage Splash", desc="Hide damage splashes near the damage indicator.")
    @ConfigEditorBoolean
    public boolean hideDamageSplash = false;
    @Expose
    @ConfigOption(name="Damage Over Time", desc="Show damage and health over time below the damage indicator.")
    @ConfigEditorBoolean
    public boolean showDamageOverTime = false;
    @Expose
    @ConfigOption(name="Hide Nametag", desc="Hide the vanilla nametag of bosses with damage indicator enabled.")
    @ConfigEditorBoolean
    public boolean hideVanillaNametag = false;
    @Expose
    @ConfigOption(name="Time to Kill", desc="Show the time it takes to kill the slayer boss.\n\u00a7eRequires Damage Indicator to be active.")
    @ConfigEditorBoolean
    public boolean timeToKillSlayer = true;
    @Expose
    @ConfigOption(name="Ender Slayer", desc="")
    @Accordion
    public EnderSlayerConfig enderSlayer = new EnderSlayerConfig();
    @Expose
    @ConfigOption(name="Vampire Slayer", desc="")
    @Accordion
    public VampireSlayerConfig vampireSlayer = new VampireSlayerConfig();

    public static enum BossCategory implements HasLegacyId
    {
        NETHER_MINI_BOSSES("\u00a7bNether Mini Bosses", 1),
        VANQUISHER("\u00a7bVanquisher", 2),
        ENDERSTONE_PROTECTOR("\u00a7bEndstone Protector (not tested)", 3),
        ENDER_DRAGON("\u00a7bEnder Dragon (not finished)", 4),
        REVENANT_HORROR("\u00a7bRevenant Horror", 5),
        TARANTULA_BROODFATHER("\u00a7bTarantula Broodfather", 6),
        SVEN_PACKMASTER("\u00a7bSven Packmaster", 7),
        VOIDGLOOM_SERAPH("\u00a7bVoidgloom Seraph", 8),
        INFERNO_DEMONLORD("\u00a7bInferno Demonlord", 9),
        HEADLESS_HORSEMAN("\u00a7bHeadless Horseman (bugged)", 10),
        DUNGEON_FLOOR_1("\u00a7bDungeon Floor 1", 11),
        DUNGEON_FLOOR_2("\u00a7bDungeon Floor 2", 12),
        DUNGEON_FLOOR_3("\u00a7bDungeon Floor 3", 13),
        DUNGEON_FLOOR_4("\u00a7bDungeon Floor 4", 14),
        DUNGEON_FLOOR_5("\u00a7bDungeon Floor 5", 15),
        DUNGEON_FLOOR_6("\u00a7bDungeon Floor 6", 16),
        DUNGEON_FLOOR_7("\u00a7bDungeon Floor 7", 17),
        DIANA_MOBS("\u00a7bDiana Mobs", 18),
        SEA_CREATURES("\u00a7bSea Creatures", 19),
        DUMMY("Dummy", 20),
        ARACHNE("\u00a7bArachne", 21),
        THE_RIFT_BOSSES("\u00a7bThe Rift Bosses", 22),
        RIFTSTALKER_BLOODFIEND("\u00a7bRiftstalker Bloodfiend", 23),
        REINDRAKE("\u00a76Reindrake", 24),
        GARDEN_PESTS("\u00a7aGarden Pests", 25),
        BROODMOTHER("\u00a7bBroodmother");

        private final String str;
        private final int legacyId;

        private BossCategory(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private BossCategory(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum NameVisibility implements HasLegacyId
    {
        HIDDEN("Hidden", 0),
        FULL_NAME("Full Name", 1),
        SHORT_NAME("Short Name", 2);

        private final String str;
        private final int legacyId;

        private NameVisibility(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private NameVisibility(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

