/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.combat;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;

public class BestiaryConfig {
    @Expose
    @ConfigOption(name="Enable", desc="Show Bestiary Data overlay in the Bestiary menu.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = false;
    @Expose
    @ConfigOption(name="Number format", desc="Short: 1.1k\nLong: 1.100")
    @ConfigEditorDropdown
    public NumberFormatEntry numberFormat = NumberFormatEntry.SHORT;
    @Expose
    @ConfigOption(name="Display type", desc="Choose what the display should show")
    @ConfigEditorDropdown
    public DisplayTypeEntry displayType = DisplayTypeEntry.GLOBAL_MAX;
    @Expose
    @ConfigOption(name="Hide maxed", desc="Hide maxed mobs.")
    @ConfigEditorBoolean
    public boolean hideMaxed = false;
    @Expose
    @ConfigOption(name="Replace Romans", desc="Replace Roman numerals (IX) with regular numbers (9)")
    @ConfigEditorBoolean
    public boolean replaceRoman = false;
    @Expose
    @ConfigLink(owner=BestiaryConfig.class, field="enabled")
    public Position position = new Position(100, 100, false, true);

    public static enum DisplayTypeEntry implements HasLegacyId
    {
        GLOBAL_MAX("Global to max", 0),
        GLOBAL_NEXT("Global to next tier", 1),
        LOWEST_TOTAL("Lowest total kills", 2),
        HIGHEST_TOTAL("Highest total kills", 3),
        LOWEST_MAX("Lowest kills needed to max", 4),
        HIGHEST_MAX("Highest kills needed to max", 5),
        LOWEST_NEXT("Lowest kills needed to next tier", 6),
        HIGHEST_NEXT("Highest kills needed to next tier", 7);

        private final String str;
        private final int legacyId;

        private DisplayTypeEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private DisplayTypeEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum NumberFormatEntry implements HasLegacyId
    {
        SHORT("Short", 0),
        LONG("Long", 1);

        private final String str;
        private final int legacyId;

        private NumberFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private NumberFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

