/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.chroma;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorInfoText;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.features.chroma.ChromaManager;
import com.google.gson.annotations.Expose;

public class ChromaConfig {
    @Expose
    @ConfigOption(name="Chroma Preview", desc="\u00a7fPlease star SkyHanni on GitHub!")
    @ConfigEditorInfoText(infoTitle="Only in SkyBlock")
    public boolean chromaPreview = false;
    @Expose
    @ConfigOption(name="Enabled", desc="Toggle SkyHanni's chroma. \u00a7e(Disables Patcher's Optimized Font Renderer while enabled)")
    @ConfigEditorBoolean
    @FeatureToggle
    public Property<Boolean> enabled = Property.of(false);
    @Expose
    @ConfigOption(name="Chroma Size", desc="Change the size of each color in the chroma.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=100.0f, minStep=1.0f)
    public float chromaSize = 30.0f;
    @Expose
    @ConfigOption(name="Chroma Speed", desc="Change how fast the chroma animation moves.")
    @ConfigEditorSlider(minValue=0.5f, maxValue=20.0f, minStep=0.5f)
    public float chromaSpeed = 6.0f;
    @Expose
    @ConfigOption(name="Chroma Saturation", desc="Change the saturation of the chroma.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=1.0f, minStep=0.01f)
    public float chromaSaturation = 0.75f;
    @Expose
    @ConfigOption(name="Chroma Direction", desc="Change the slant and direction of the chroma.")
    @ConfigEditorDropdown
    public Direction chromaDirection = Direction.FORWARD_RIGHT;
    @ConfigOption(name="Reset to Default", desc="Reset all chroma settings to the default.")
    @ConfigEditorButton(buttonText="Reset")
    public Runnable resetSettings = ChromaManager::resetChromaSettings;
    @Expose
    @ConfigOption(name="Everything Chroma", desc="Render \u00a74\u00a7l\u00a7oALL \u00a7r\u00a77text in chroma. \u00a7e(Some enchants may appear white with SBA enchant parsing)")
    @ConfigEditorBoolean
    public boolean allChroma = false;
    @Expose
    @ConfigOption(name="Ignore Chat", desc="Prevent Everything Chroma from applying to the chat (if you unironically use that feature...)")
    @ConfigEditorBoolean
    public boolean ignoreChat = false;

    public static enum Direction implements HasLegacyId
    {
        FORWARD_RIGHT("Forward + Right", 0),
        FORWARD_LEFT("Forward + Left", 1),
        BACKWARD_RIGHT("Backward + Right", 2),
        BACKWARD_LEFT("Backward + Left", 3);

        private final String str;
        private final int legacyId;

        private Direction(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private Direction(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

