/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.core.config.PositionList;
import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.processor.BuiltinMoulConfigGuis;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigProcessorDriver;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import at.hannibal2.skyhanni.events.LorenzEvent;
import at.hannibal2.skyhanni.features.misc.update.UpdateManager;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.IdentityCharacteristics;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.json.BaseGsonBuilder;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.io.AccessDeniedException;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J-\u0010\u000f\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0015\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ1\u0010\u001d\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ1\u0010\"\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0007\u00a2\u0006\u0004\b$\u0010\u0003R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R(\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0016\u0010$\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u00104R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0017058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00069"}, d2={"Lat/hannibal2/skyhanni/config/ConfigManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/ConfigFileType;", "type", "value", "", "setConfigHolder", "(Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/Object;)V", "firstLoad", "obj", "", "Lat/hannibal2/skyhanni/utils/IdentityCharacteristics;", "slog", "findPositionLinks", "(Ljava/lang/Object;Ljava/util/Set;)V", "Ljava/io/File;", "file", "fileType", "defaultValue", "firstLoadFile", "(Ljava/io/File;Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/Object;)Ljava/lang/Object;", "", "reason", "saveConfig", "(Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/String;)V", "fileName", "data", "saveFile", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "unit", "", "loop", "move", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;I)V", "disableSaving", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "", "jsonHolder", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;", "Lat/hannibal2/skyhanni/config/Features;", "processor", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;", "getProcessor", "()Lio/github/notenoughupdates/moulconfig/processor/MoulConfigProcessor;", "setProcessor", "(Lio/github/notenoughupdates/moulconfig/processor/MoulConfigProcessor;)V", "", "Z", "", "ignoredMissingConfigLinks", "Ljava/util/List;", "Companion", "1.8.9"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LorenzLogger logger = new LorenzLogger("config_manager");
    @NotNull
    private final Map<ConfigFileType, Object> jsonHolder = new EnumMap(ConfigFileType.class);
    public MoulConfigProcessor<Features> processor;
    private boolean disableSaving;
    @NotNull
    private final List<String> ignoredMissingConfigLinks;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static File configDirectory;

    public ConfigManager() {
        String[] stringArray = new String[]{"features.garden.GardenConfig.cropSpeedMeterPos", "features.misc.MiscConfig.collectionCounterPos", "features.misc.MiscConfig.carryPosition", "features.misc.MiscConfig.lockedMouseDisplay", "features.dev.DebugConfig.trackSoundPosition", "features.dev.DebugConfig.trackParticlePosition", "features.dev.DevConfig.debugPos", "features.dev.DevConfig.debugLocationPos", "features.dev.DevConfig.debugItemPos"};
        this.ignoredMissingConfigLinks = CollectionsKt.listOf(stringArray);
    }

    @NotNull
    public final MoulConfigProcessor<Features> getProcessor() {
        MoulConfigProcessor<Features> moulConfigProcessor = this.processor;
        if (moulConfigProcessor != null) {
            return moulConfigProcessor;
        }
        Intrinsics.throwUninitializedPropertyAccessException("processor");
        return null;
    }

    public final void setProcessor(@NotNull MoulConfigProcessor<Features> moulConfigProcessor) {
        Intrinsics.checkNotNullParameter(moulConfigProcessor, "<set-?>");
        this.processor = moulConfigProcessor;
    }

    private final void setConfigHolder(ConfigFileType type2, Object value) {
        if (!Intrinsics.areEqual(value.getClass(), type2.getClazz())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KMutableProperty0<?> kMutableProperty0 = type2.getProperty();
        Intrinsics.checkNotNull(kMutableProperty0, "null cannot be cast to non-null type kotlin.reflect.KMutableProperty0<kotlin.Any>");
        kMutableProperty0.set(value);
        Map<ConfigFileType, Object> map2 = this.jsonHolder;
        Intrinsics.checkNotNull(map2, "null cannot be cast to non-null type kotlin.collections.MutableMap<at.hannibal2.skyhanni.config.ConfigFileType, kotlin.Any>");
        TypeIntrinsics.asMutableMap(map2).put(type2, value);
    }

    public final void firstLoad() {
        block4: {
            Timer timer;
            if (!this.jsonHolder.isEmpty()) {
                this.logger.log("Loading config despite config being already loaded?");
            }
            configDirectory.mkdirs();
            for (ConfigFileType fileType : ConfigFileType.getEntries()) {
                File file = fileType.getFile();
                Object obj = fileType.getClazz().newInstance();
                Intrinsics.checkNotNullExpressionValue(obj, "newInstance(...)");
                this.setConfigHolder(fileType, this.firstLoadFile(file, fileType, obj));
            }
            String string2 = "skyhanni-config-auto-save";
            long l = 60000L;
            long l2 = 60000L;
            boolean fileType = false;
            Timer timer2 = timer = TimersKt.timer(string2, fileType);
            timer2.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ ConfigManager this$0;
                {
                    this.this$0 = configManager;
                }

                public void run() {
                    TimerTask $this$firstLoad_u24lambda_u240 = this;
                    boolean bl = false;
                    this.this$0.saveConfig(ConfigFileType.FEATURES, "auto-save-60s");
                }
            }, l, l2);
            Features features = SkyHanniMod.feature;
            this.setProcessor(new MoulConfigProcessor<Config>(SkyHanniMod.feature));
            BuiltinMoulConfigGuis.addProcessors(this.getProcessor());
            UpdateManager.INSTANCE.injectConfigProcessor(this.getProcessor());
            new ConfigProcessorDriver(this.getProcessor()).processConfig(features);
            try {
                this.findPositionLinks(features, new LinkedHashSet());
            }
            catch (Exception e) {
                if (!LorenzEvent.Companion.isInGuardedEventHandler()) break block4;
                throw e;
            }
        }
    }

    private final void findPositionLinks(Object obj, Set<IdentityCharacteristics<Object>> slog) {
        if (obj == null) {
            return;
        }
        String string2 = obj.getClass().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (!StringsKt.startsWith$default(string2, "at.hannibal2.skyhanni.", false, 2, null)) {
            return;
        }
        IdentityCharacteristics<Object> ic = new IdentityCharacteristics<Object>(obj);
        if (slog.contains(ic)) {
            return;
        }
        slog.add(ic);
        boolean missingConfigLink = false;
        Iterator<Field> iterator2 = ArrayIteratorKt.iterator(obj.getClass().getFields());
        while (iterator2.hasNext()) {
            Field field = iterator2.next();
            field.setAccessible(true);
            if (!Intrinsics.areEqual(field.getType(), Position.class) && !Intrinsics.areEqual(field.getType(), PositionList.class)) {
                this.findPositionLinks(field.get(obj), slog);
                continue;
            }
            ConfigLink configLink = field.getAnnotation(ConfigLink.class);
            if (configLink == null) {
                if (!PlatformUtils.INSTANCE.isDevEnvironment()) continue;
                String name2 = field.getDeclaringClass().getName() + '.' + field.getName();
                if (this.ignoredMissingConfigLinks.contains(name2 = StringsKt.replace$default(name2, "at.hannibal2.skyhanni.config.", "", false, 4, null))) continue;
                System.out.println((Object)("WEE WOO WEE WOO HIER FEHLT EIN @CONFIGLINK: " + name2));
                missingConfigLink = true;
                continue;
            }
            if (Intrinsics.areEqual(field.getType(), Position.class)) {
                Object object = field.get(obj);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type at.hannibal2.skyhanni.config.core.config.Position");
                Position position = (Position)object;
                position.setLink(configLink);
                continue;
            }
            if (!Intrinsics.areEqual(field.getType(), PositionList.class)) continue;
            Object object = field.get(obj);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type at.hannibal2.skyhanni.config.core.config.PositionList");
            PositionList list = (PositionList)object;
            list.setLink(configLink);
        }
        if (missingConfigLink) {
            System.out.println((Object)"");
            System.out.println((Object)"This crash is here to remind you to fix the missing @ConfigLink annotation over your new config position config element.");
            System.out.println((Object)"");
            System.out.println((Object)"Steps to fix:");
            System.out.println((Object)"1. Search for `WEE WOO WEE WOO` in the console output.");
            System.out.println((Object)"2. Either add the Config Link.");
            System.out.println((Object)"3. Or add the name to ignoredMissingConfigLinks.");
            System.out.println((Object)"");
            LorenzUtils.INSTANCE.shutdownMinecraft("Missing Config Link");
        }
    }

    private final Object firstLoadFile(File file, ConfigFileType fileType, Object defaultValue) {
        String fileName = fileType.getFileName();
        this.logger.log("Trying to load " + fileName + " from " + file);
        Object output = defaultValue;
        File file2 = file;
        Intrinsics.checkNotNull(file2);
        if (file2.exists()) {
            try {
                Object object;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                Gson lenientGson = BaseGsonBuilder.INSTANCE.lenientGson().create();
                this.logger.log("load-" + fileName + "-now");
                if (fileType == ConfigFileType.FEATURES) {
                    JsonObject jsonObject2 = (JsonObject)lenientGson.fromJson(TextStreamsKt.readText(bufferedReader), JsonObject.class);
                    Intrinsics.checkNotNull(jsonObject2);
                    JsonObject newJsonObject = ConfigUpdaterMigrator.INSTANCE.fixConfig(jsonObject2);
                    Function0<Object> run = () -> ConfigManager.firstLoadFile$lambda$1(lenientGson, newJsonObject, defaultValue);
                    if (PlatformUtils.INSTANCE.isDevEnvironment()) {
                        Object object2;
                        try {
                            object2 = run.invoke();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            LorenzUtils.INSTANCE.shutdownMinecraft("Config is corrupt inside development environment.");
                            object2 = Unit.INSTANCE;
                        }
                        object = object2;
                    } else {
                        object = run.invoke();
                    }
                } else {
                    object = lenientGson.fromJson(TextStreamsKt.readText(bufferedReader), defaultValue.getClass());
                }
                output = object;
                this.logger.log("Loaded " + fileName + " from file");
            }
            catch (Exception e) {
                e.printStackTrace();
                File backupFile = FilesKt.resolveSibling(file, fileName + '-' + SimpleTimeMark.toMillis-impl(SimpleTimeMark.Companion.now-uFjCsEo()) + "-backup.json");
                this.logger.log("Exception while reading " + file + ". Will load blank " + fileName + " and save backup to " + backupFile);
                this.logger.log("Exception was " + e);
                try {
                    File file3 = FilesKt.copyTo$default(file, backupFile, false, 0, 6, null);
                }
                catch (Exception e2) {
                    this.logger.log("Could not create backup for " + fileName + " file");
                    e2.printStackTrace();
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        if (Intrinsics.areEqual(output, defaultValue)) {
            this.logger.log("Setting " + fileName + " to be blank as it did not exist. It will be saved once something is written to it");
        }
        if (output == null) {
            this.logger.log("Setting " + fileName + " to be blank as it was null. It will be saved once something is written to it");
            output = defaultValue;
        }
        return output;
    }

    public final void saveConfig(@NotNull ConfigFileType fileType, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)fileType, "fileType");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Object object = this.jsonHolder.get((Object)fileType);
        if (object == null) {
            throw new IllegalStateException(("Could not find json object for " + (Object)((Object)fileType)).toString());
        }
        Object json = object;
        this.saveFile(fileType.getFile(), fileType.getFileName(), json, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveFile(File file, String fileName, Object data2, String reason) {
        if (this.disableSaving) {
            return;
        }
        this.logger.log("saveConfig: " + reason);
        if (file == null) {
            throw new Error("Can not save " + fileName + ", " + fileName + "File is null!");
        }
        try {
            this.logger.log("Saving " + fileName + " file");
            file.getParentFile().mkdirs();
            File file2 = file.getParentFile();
            Intrinsics.checkNotNullExpressionValue(file2, "getParentFile(...)");
            File unit = FilesKt.resolve(file2, fileName + ".json.write");
            unit.createNewFile();
            Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(unit), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                writer.write(gson.toJson(data2));
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            ConfigManager.move$default(this, unit, file, reason, 0, 8, null);
        }
        catch (IOException e) {
            this.logger.log("Could not save " + fileName + " file to " + file);
            e.printStackTrace();
        }
    }

    private final void move(File unit, File file, String reason, int loop) {
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(unit.toPath(), file.toPath(), copyOptionArray);
        }
        catch (AccessDeniedException e) {
            if (loop == 5) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("config save reason", reason)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "could not save config.", pairArray, false, false, false, 56, null);
                return;
            }
            ChatUtils.INSTANCE.debug("config save AccessDeniedException! (loop " + loop + ')');
            DelayedRun.INSTANCE.runNextTick(() -> ConfigManager.move$lambda$3(this, unit, file, reason, loop));
        }
    }

    static /* synthetic */ void move$default(ConfigManager configManager, File file, File file2, String string2, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        configManager.move(file, file2, string2, n);
    }

    public final void disableSaving() {
        this.disableSaving = true;
    }

    private static final Object firstLoadFile$lambda$1(Gson $lenientGson, JsonObject $newJsonObject, Object $defaultValue) {
        Intrinsics.checkNotNullParameter($newJsonObject, "$newJsonObject");
        Intrinsics.checkNotNullParameter($defaultValue, "$defaultValue");
        return $lenientGson.fromJson((JsonElement)$newJsonObject, $defaultValue.getClass());
    }

    private static final Unit move$lambda$3(ConfigManager this$0, File $unit, File $file, String $reason, int $loop) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($unit, "$unit");
        Intrinsics.checkNotNullParameter($file, "$file");
        Intrinsics.checkNotNullParameter($reason, "$reason");
        this$0.move($unit, $file, $reason, $loop + 1);
        return Unit.INSTANCE;
    }

    static {
        Gson gson2 = BaseGsonBuilder.INSTANCE.gson().create();
        Intrinsics.checkNotNullExpressionValue(gson2, "create(...)");
        gson = gson2;
        configDirectory = new File("config/skyhanni");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/config/ConfigManager$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Ljava/io/File;", "configDirectory", "Ljava/io/File;", "getConfigDirectory", "()Ljava/io/File;", "setConfigDirectory", "(Ljava/io/File;)V", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        @NotNull
        public final File getConfigDirectory() {
            return configDirectory;
        }

        public final void setConfigDirectory(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "<set-?>");
            configDirectory = file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

