/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.event;

import at.hannibal2.skyhanni.api.event.EventHandler;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.event.SkyHanniEvent;
import at.hannibal2.skyhanni.data.MinecraftData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DisabledEventsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import com.google.gson.Gson;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\n*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u001f\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!R(\u0010#\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010'\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/api/event/SkyHanniEvents;", "", "<init>", "()V", "", "instances", "", "init", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/api/event/SkyHanniEvent;", "T", "Ljava/lang/Class;", "event", "Lat/hannibal2/skyhanni/api/event/EventHandler;", "getEventHandler", "(Ljava/lang/Class;)Lat/hannibal2/skyhanni/api/event/EventHandler;", "", "handler", "", "isDisabledHandler", "(Ljava/lang/String;)Z", "invoker", "isDisabledInvoker", "Ljava/lang/reflect/Method;", "method", "instance", "registerMethod", "(Ljava/lang/reflect/Method;Ljava/lang/Object;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoLoad", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "handlers", "Ljava/util/Map;", "", "disabledHandlers", "Ljava/util/Set;", "disabledHandlerInvokers", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSkyHanniEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkyHanniEvents.kt\nat/hannibal2/skyhanni/api/event/SkyHanniEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,65:1\n1863#2:66\n1864#2:69\n1863#2,2:70\n774#2:86\n865#2,2:87\n1863#2,2:89\n13346#3,2:67\n381#4,7:72\n12#5,7:79\n*S KotlinDebug\n*F\n+ 1 SkyHanniEvents.kt\nat/hannibal2/skyhanni/api/event/SkyHanniEvents\n*L\n19#1:66\n19#1:69\n24#1:70,2\n57#1:86\n57#1:87,2\n59#1:89,2\n20#1:67,2\n28#1:72,7\n47#1:79,7\n*E\n"})
public final class SkyHanniEvents {
    @NotNull
    public static final SkyHanniEvents INSTANCE = new SkyHanniEvents();
    @NotNull
    private static final Map<Class<?>, EventHandler<?>> handlers = new LinkedHashMap();
    @NotNull
    private static Set<String> disabledHandlers = SetsKt.emptySet();
    @NotNull
    private static Set<String> disabledHandlerInvokers = SetsKt.emptySet();

    private SkyHanniEvents() {
    }

    public final void init(@NotNull List<? extends Object> instances) {
        Intrinsics.checkNotNullParameter(instances, "instances");
        Iterable $this$forEach$iv = instances;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object instance = element$iv = iterator2.next();
            boolean bl = false;
            Method[] methodArray = instance.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue(methodArray, "getDeclaredMethods(...)");
            Object[] $this$forEach$iv2 = methodArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Method it = (Method)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.registerMethod(it, instance);
            }
        }
        $this$forEach$iv = handlers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler it = (EventHandler)element$iv;
            boolean bl = false;
            it.freeze();
        }
    }

    @NotNull
    public final <T extends SkyHanniEvent> EventHandler<T> getEventHandler(@NotNull Class<T> event) {
        EventHandler<Object> eventHandler;
        Intrinsics.checkNotNullParameter(event, "event");
        Map<Class<?>, EventHandler<?>> $this$getOrPut$iv = handlers;
        boolean $i$f$getOrPut = false;
        EventHandler<?> value$iv = $this$getOrPut$iv.get(event);
        if (value$iv == null) {
            boolean bl = false;
            EventHandler<T> answer$iv = new EventHandler<T>(event);
            $this$getOrPut$iv.put(event, answer$iv);
            eventHandler = answer$iv;
        } else {
            eventHandler = value$iv;
        }
        return eventHandler;
    }

    public final boolean isDisabledHandler(@NotNull String handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return disabledHandlers.contains(handler);
    }

    public final boolean isDisabledInvoker(@NotNull String invoker) {
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        return disabledHandlerInvokers.contains(invoker);
    }

    private final void registerMethod(Method method, Object instance) {
        if (method.getParameterCount() != 1) {
            return;
        }
        HandleEvent handleEvent = method.getAnnotation(HandleEvent.class);
        if (handleEvent == null) {
            return;
        }
        HandleEvent options = handleEvent;
        Class<?> event = method.getParameterTypes()[0];
        if (!SkyHanniEvent.class.isAssignableFrom(event)) {
            return;
        }
        Intrinsics.checkNotNull(event, "null cannot be cast to non-null type java.lang.Class<at.hannibal2.skyhanni.api.event.SkyHanniEvent>");
        EventHandler<?> handler = this.getEventHandler(event);
        handler.addListener(method, instance, options);
    }

    @SubscribeEvent
    public final void onRepoLoad(@NotNull RepositoryReloadEvent event) {
        DisabledEventsJson disabledEventsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "DisabledEvents";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            disabledEventsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, DisabledEventsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        DisabledEventsJson data2 = disabledEventsJson;
        disabledHandlers = data2.getDisabledHandlers();
        disabledHandlerInvokers = data2.getDisabledInvokers();
    }

    @SubscribeEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Events");
        event.addIrrelevant(SkyHanniEvents::onDebug$lambda$8);
    }

    private static final Comparable onDebug$lambda$8$lambda$5(EventHandler it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Long.valueOf(-it.getInvokeCount());
    }

    private static final Comparable onDebug$lambda$8$lambda$6(EventHandler it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)((Object)it.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onDebug$lambda$8(List $this$addIrrelevant) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        Function1[] $this$filter$iv = (Function1[])CollectionsKt.toMutableList(handlers.values());
        boolean $i$f$filter = false;
        Function1[] function1Array = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EventHandler it = (EventHandler)element$iv$iv;
            boolean bl = false;
            if (!(it.getInvokeCount() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new Function1[]{SkyHanniEvents::onDebug$lambda$8$lambda$5, SkyHanniEvents::onDebug$lambda$8$lambda$6};
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler it = (EventHandler)element$iv;
            boolean bl = false;
            $this$addIrrelevant.add("- " + it.getName() + " (" + it.getInvokeCount() + ' ' + it.getInvokeCount() / (long)(MinecraftData.INSTANCE.getTotalTicks() / 20) + "/s)");
        }
        return Unit.INSTANCE;
    }
}

