/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import io.github.moulberry.notenoughupdates.events.TabListChangeEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiPlayerTabOverlay;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TabListUtils {
    private static final Ordering<NetworkPlayerInfo> playerOrdering = Ordering.from((Comparator)new PlayerComparator());
    public static List<String> tabList = new ArrayList<String>();
    public static List<String> tabListLastTick = new ArrayList<String>();

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        tabListLastTick = tabList;
        tabList = this.getTabList0();
        new TabListChangeEvent(tabList, tabListLastTick).post();
    }

    @Deprecated
    public static List<String> getTabList() {
        return tabList;
    }

    private List<String> getTabList0() {
        List players = playerOrdering.sortedCopy((Iterable)Minecraft.func_71410_x().field_71439_g.field_71174_a.func_175106_d());
        ArrayList<String> result2 = new ArrayList<String>();
        for (NetworkPlayerInfo info : players) {
            String name = Minecraft.func_71410_x().field_71456_v.func_175181_h().func_175243_a(info);
            result2.add(name);
        }
        ArrayList<String> lines = null;
        try {
            String[] footer = ((AccessorGuiPlayerTabOverlay)Minecraft.func_71410_x().field_71456_v.func_175181_h()).getFooter().func_150254_d().split("\n");
            lines = new ArrayList<String>();
            boolean seenBlank = false;
            for (String line : footer) {
                if (line.equals("\u00a7r\u00a7r\u00a7r\u00a7r\u00a7s\u00a7r") || line.equals("\u00a7r")) {
                    seenBlank = true;
                    continue;
                }
                if (seenBlank) {
                    lines.add(line);
                    seenBlank = false;
                    continue;
                }
                lines.add(" " + line);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (lines != null) {
            result2.addAll(lines);
        }
        return result2;
    }

    @SideOnly(value=Side.CLIENT)
    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo o1, NetworkPlayerInfo o2) {
            ScorePlayerTeam team1 = o1.func_178850_i();
            ScorePlayerTeam team2 = o2.func_178850_i();
            return ComparisonChain.start().compareTrueFirst(o1.func_178848_b() != WorldSettings.GameType.SPECTATOR, o2.func_178848_b() != WorldSettings.GameType.SPECTATOR).compare((Comparable)((Object)(team1 != null ? team1.func_96661_b() : "")), (Comparable)((Object)(team2 != null ? team2.func_96661_b() : ""))).compare((Comparable)((Object)o1.func_178845_a().getName()), (Comparable)((Object)o2.func_178845_a().getName())).result();
        }
    }
}

