/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntSupplier;

public interface LRUCache<K, V>
extends Function<K, V> {
    public static <K, V> LRUCache<K, V> memoize(Function<K, V> mapper, int maxCacheSize) {
        return LRUCache.memoize(mapper, () -> maxCacheSize);
    }

    public static <K, V> LRUCache<K, V> memoize(Function<K, V> mapper, final IntSupplier maxCacheSize) {
        LinkedHashMap cache = new LinkedHashMap<K, Object>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Object> eldest) {
                return this.size() > maxCacheSize.getAsInt();
            }
        };
        final Object SENTINEL_CACHE_RESULT_NULL = new Object();
        final Function<K, Object> sentinelAwareMapper = mapper.andThen(it -> it == null ? SENTINEL_CACHE_RESULT_NULL : it);
        final Map synchronizedCache = Collections.synchronizedMap(cache);
        return new LRUCache<K, V>(){

            @Override
            public void clearCache() {
                synchronizedCache.clear();
            }

            @Override
            public int size() {
                return synchronizedCache.size();
            }

            @Override
            public V apply(K k) {
                Object value = synchronizedCache.computeIfAbsent(k, sentinelAwareMapper);
                return value == SENTINEL_CACHE_RESULT_NULL ? null : (Object)value;
            }
        };
    }

    public int size();

    public void clearCache();
}

