/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

public class Debouncer {
    private long lastPinged = 0L;
    private final long delay;

    public Debouncer(long minimumDelayInNanoSeconds) {
        this.delay = minimumDelayInNanoSeconds;
    }

    public long getDelayInNanoSeconds() {
        return this.delay;
    }

    public synchronized long timePassed() {
        return System.nanoTime() - this.lastPinged;
    }

    public synchronized boolean trigger() {
        long newPingTime = System.nanoTime();
        long newDelay = newPingTime - this.lastPinged;
        this.lastPinged = newPingTime;
        return newDelay >= this.delay;
    }
}

