/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.ApiCache;
import io.github.moulberry.notenoughupdates.util.HttpStatusCodeException;
import io.github.moulberry.notenoughupdates.util.kotlin.KotlinTypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class ApiUtil {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory(KotlinTypeAdapterFactory.INSTANCE).create();
    private static final Comparator<NameValuePair> nameValuePairComparator = Comparator.comparing(NameValuePair::getName).thenComparing(NameValuePair::getValue);
    private static final ExecutorService executorService = Executors.newFixedThreadPool(3);
    private static SSLContext ctx;
    private final Map<String, CompletableFuture<Void>> updateTasks = new HashMap<String, CompletableFuture<Void>>();
    private static boolean notifiedOfInvalidApiKey;

    private static String getUserAgent() {
        if (NotEnoughUpdates.INSTANCE.config.hidden.customUserAgent != null) {
            return NotEnoughUpdates.INSTANCE.config.hidden.customUserAgent;
        }
        return "NotEnoughUpdates/2.4.0";
    }

    public static void patchHttpsRequest(HttpsURLConnection connection) {
        if (ctx != null && connection != null) {
            connection.setSSLSocketFactory(ctx.getSocketFactory());
        }
    }

    public Request request() {
        return new Request();
    }

    public Request newAnonymousHypixelApiRequest(String apiPath) {
        return new Request().url("https://api.hypixel.net/v2/" + apiPath);
    }

    public Request newMoulberryRequest(String path) {
        return new Request().url(this.getMyApiURL() + path);
    }

    private String getMyApiURL() {
        return String.format("https://%s/", NotEnoughUpdates.INSTANCE.config.apiData.moulberryCodesApi);
    }

    static {
        try {
            KeyStore letsEncryptStore = KeyStore.getInstance("JKS");
            letsEncryptStore.load(ApiUtil.class.getResourceAsStream("/neukeystore.jks"), "neuneu".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf.init(letsEncryptStore, null);
            tmf.init(letsEncryptStore);
            ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e2) {
            System.out.println("Failed to load NEU keystore. A lot of API requests won't work");
            e2.printStackTrace();
            ctx = null;
        }
    }

    public static class Request {
        private final List<NameValuePair> queryArguments = new ArrayList<NameValuePair>();
        private String baseUrl = null;
        private boolean shouldGunzip = false;
        private Duration maxCacheAge = Duration.ofSeconds(500L);
        private String method = "GET";
        private String postData = null;
        private final Map<String, String> headers = new HashMap<String, String>();
        private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        private String postContentType = null;

        public Request method(String method) {
            this.method = method;
            return this;
        }

        public Request header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Request maxCacheAge(Duration maxCacheAge) {
            this.maxCacheAge = maxCacheAge;
            return this;
        }

        public Request url(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Request queryArgument(String key, String value) {
            this.queryArguments.add((NameValuePair)new BasicNameValuePair(key, value));
            return this;
        }

        public Request queryArguments(Collection<NameValuePair> queryArguments) {
            this.queryArguments.addAll(queryArguments);
            return this;
        }

        public Request gunzip() {
            this.shouldGunzip = true;
            return this;
        }

        public Request postData(String contentType, String data) {
            this.postContentType = contentType;
            this.postData = data;
            return this;
        }

        private CompletableFuture<URL> buildUrl() {
            CompletableFuture<URL> fut = new CompletableFuture<URL>();
            try {
                fut.complete(new URIBuilder(this.baseUrl).addParameters(this.queryArguments).build().toURL());
            }
            catch (NullPointerException | MalformedURLException | URISyntaxException e2) {
                fut.completeExceptionally(e2);
            }
            return fut;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        private ApiCache.CacheKey getCacheKey() {
            if (!"GET".equals(this.method)) {
                return null;
            }
            this.queryArguments.sort(nameValuePairComparator);
            return new ApiCache.CacheKey(this.baseUrl, this.queryArguments, this.shouldGunzip);
        }

        public Map<String, List<String>> getResponseHeaders() {
            return this.responseHeaders;
        }

        private CompletableFuture<String> requestString0() {
            return ((CompletableFuture)this.buildUrl().thenApplyAsync(url -> {
                String string;
                InputStream inputStream = null;
                int httpStatusCode = 200;
                URLConnection conn = null;
                try {
                    HttpURLConnection httpConn;
                    conn = url.openConnection();
                    if (conn instanceof HttpsURLConnection && ctx != null) {
                        ApiUtil.patchHttpsRequest((HttpsURLConnection)conn);
                    }
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).setRequestMethod(this.method);
                    }
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(10000);
                    conn.setRequestProperty("User-Agent", ApiUtil.getUserAgent());
                    for (Map.Entry<String, String> header : this.headers.entrySet()) {
                        conn.setRequestProperty(header.getKey(), header.getValue());
                    }
                    if (this.postContentType != null) {
                        conn.setRequestProperty("Content-Type", this.postContentType);
                    }
                    if (!this.shouldGunzip) {
                        conn.setRequestProperty("Accept-Encoding", "gzip");
                    }
                    if (this.postData != null) {
                        conn.setDoOutput(true);
                        try (OutputStream os = conn.getOutputStream();){
                            os.write(this.postData.getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    if (conn instanceof HttpURLConnection && (httpStatusCode = (httpConn = (HttpURLConnection)conn).getResponseCode()) >= 400) {
                        inputStream = httpConn.getErrorStream();
                    }
                    if (inputStream == null) {
                        inputStream = conn.getInputStream();
                    }
                    if (this.shouldGunzip || "gzip".equals(conn.getContentEncoding())) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    this.responseHeaders = conn.getHeaderFields().entrySet().stream().collect(Collectors.toMap(it -> it.getKey() == null ? null : ((String)it.getKey()).toLowerCase(Locale.ROOT), it -> new ArrayList((Collection)it.getValue())));
                    String response = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (httpStatusCode >= 400) {
                        throw new HttpStatusCodeException((URL)url, httpStatusCode, response);
                    }
                    string = response;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        finally {
                            if (conn instanceof HttpURLConnection) {
                                ((HttpURLConnection)conn).disconnect();
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                finally {
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).disconnect();
                    }
                }
                return string;
            }, (Executor)executorService)).handle((obj, t) -> {
                if (t != null) {
                    t.printStackTrace();
                }
                return obj;
            });
        }

        public CompletableFuture<String> requestString() {
            return ApiCache.INSTANCE.cacheRequest(this, this.getCacheKey(), this::requestString0, this.maxCacheAge);
        }

        public CompletableFuture<JsonObject> requestJson() {
            return this.requestJson(JsonObject.class);
        }

        public <T> CompletableFuture<T> requestJson(Class<? extends T> clazz) {
            return this.requestString().thenApplyAsync(str -> gson.fromJson((String)str, clazz));
        }
    }
}

