/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class Ingredient {
    public static final String SKYBLOCK_COIN = "SKYBLOCK_COIN";
    private final double count;
    private final String internalItemId;
    private final NEUManager manager;
    private ItemStack itemStack;

    public Ingredient(NEUManager manager, String ingredientIdentifier) {
        this.manager = manager;
        String[] parts = ingredientIdentifier.split(":");
        this.internalItemId = parts[0];
        if (parts.length == 2) {
            this.count = Double.parseDouble(parts[1]);
        } else if (parts.length == 1) {
            this.count = 1.0;
        } else {
            throw new IllegalArgumentException("Could not parse ingredient " + ingredientIdentifier);
        }
    }

    public Ingredient(NEUManager manager, String internalItemId, double count) {
        this.manager = manager;
        this.count = count;
        this.internalItemId = internalItemId;
    }

    private Ingredient(NEUManager manager, double coinValue) {
        this.manager = manager;
        this.internalItemId = SKYBLOCK_COIN;
        this.count = coinValue;
    }

    public static Set<Ingredient> mergeIngredients(Iterable<Ingredient> ingredients) {
        HashMap<String, Ingredient> newIngredients = new HashMap<String, Ingredient>();
        for (Ingredient i : ingredients) {
            newIngredients.merge(i.getInternalItemId(), i, (a, b) -> new Ingredient(i.manager, i.internalItemId, a.count + b.count));
        }
        return new HashSet<Ingredient>(newIngredients.values());
    }

    public static Ingredient coinIngredient(NEUManager manager, int coins) {
        return new Ingredient(manager, coins);
    }

    public boolean isCoins() {
        return SKYBLOCK_COIN.equals(this.internalItemId);
    }

    public double getCount() {
        return this.count;
    }

    public String getInternalItemId() {
        return this.internalItemId;
    }

    public ItemStack getItemStack() {
        if (this.itemStack != null) {
            return this.itemStack;
        }
        if (this.isCoins()) {
            return ItemUtils.getCoinItemStack(this.count);
        }
        JsonObject itemInfo = this.manager.getItemInformation().get(this.internalItemId);
        this.itemStack = this.manager.jsonToStack(itemInfo, false, true);
        this.itemStack.field_77994_a = (int)this.count;
        return this.itemStack;
    }

    public String serialize() {
        return this.internalItemId + ":" + this.count;
    }
}

