/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.ProfileDataLoadedEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.BestiaryData;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.PlayerStats;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.weight.senither.SenitherWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.UrsaClient;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.hypixelapi.ProfileCollectionInfo;
import io.github.moulberry.notenoughupdates.util.kotlin.KotlinTypeAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SkyblockProfiles {
    private static final String defaultNbtData = "Hz8IAAAAAAAAAD9iYD9kYD9kAAMAPwI/Gw0AAAA=";
    private static final String moulberryUuid = "d0e05de76067454dbeaec6d19d886191";
    private static final List<String> inventoryNames = Arrays.asList("inv_armor", "fishing_bag", "quiver", "ender_chest_contents", "backpack_contents", "personal_vault_contents", "wardrobe_contents", "potion_bag", "inv_contents", "talisman_bag", "candy_inventory_contents", "equipment_contents");
    private static final List<String> skills = Arrays.asList("taming", "mining", "foraging", "enchanting", "carpentry", "farming", "combat", "fishing", "alchemy", "runecrafting", "social");
    private static final List<String> tuningStats = Arrays.asList("health", "defense", "walk_speed", "strength", "critical_damage", "critical_chance", "attack_speed", "intelligence");
    private final ProfileViewer profileViewer;
    private final String uuid;
    private final AtomicBoolean updatingSkyblockProfilesState = new AtomicBoolean(false);
    private final AtomicBoolean updatingGuildInfoState = new AtomicBoolean(false);
    private final AtomicBoolean updatingPlayerStatusState = new AtomicBoolean(false);
    private final AtomicBoolean updatingSoopyData = new AtomicBoolean(false);
    private final AtomicBoolean updatingBingoInfo = new AtomicBoolean(false);
    private Map<String, SkyblockProfile> nameToProfile = null;
    private JsonArray profilesArray;
    private List<String> profileNames = new ArrayList<String>();
    private String latestProfileName;
    private long soopyNetworthLeaderboardPosition = -1L;
    private long soopyWeightLeaderboardPosition = -1L;
    private JsonObject guildInformation = null;
    private boolean isInGuild = true;
    private JsonObject playerStatus = null;
    private JsonObject bingoInformation = null;
    private long lastPlayerInfoState = 0L;
    private long lastStatusInfoState = 0L;
    private long lastGuildInfoState = 0L;
    private long lastBingoInfoState = 0L;
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory(KotlinTypeAdapterFactory.INSTANCE).create();

    public SkyblockProfiles(ProfileViewer profileViewer, String uuid) {
        this.profileViewer = profileViewer;
        this.uuid = uuid;
    }

    public JsonObject getPlayerStatus() {
        if (this.playerStatus != null) {
            return this.playerStatus;
        }
        if (this.updatingPlayerStatusState.get()) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastStatusInfoState < 15000L) {
            return null;
        }
        this.lastStatusInfoState = currentTime;
        this.updatingPlayerStatusState.set(true);
        this.profileViewer.getManager().ursaClient.get(UrsaClient.status(Utils.parseDashlessUUID(this.uuid))).handle((jsonObject, ex) -> {
            this.updatingPlayerStatusState.set(false);
            if (jsonObject != null && jsonObject.has("success") && jsonObject.get("success").getAsBoolean()) {
                this.playerStatus = jsonObject.get("session").getAsJsonObject();
            }
            return null;
        });
        return null;
    }

    public JsonObject getBingoInformation() {
        long currentTime = System.currentTimeMillis();
        if (this.bingoInformation != null && currentTime - this.lastBingoInfoState < 15000L) {
            return this.bingoInformation;
        }
        if (this.updatingBingoInfo.get() && this.bingoInformation != null) {
            return this.bingoInformation;
        }
        if (this.updatingBingoInfo.get() && this.bingoInformation == null) {
            return null;
        }
        this.lastBingoInfoState = currentTime;
        this.updatingBingoInfo.set(true);
        NotEnoughUpdates.INSTANCE.manager.ursaClient.get(UrsaClient.bingo(Utils.parseDashlessUUID(this.uuid))).handle((jsonObject, throwable) -> {
            this.updatingBingoInfo.set(false);
            this.bingoInformation = jsonObject != null && jsonObject.has("success") && jsonObject.get("success").getAsBoolean() ? jsonObject : null;
            return null;
        });
        return this.bingoInformation != null ? this.bingoInformation : null;
    }

    public long getSoopyNetworthLeaderboardPosition() {
        if (this.soopyNetworthLeaderboardPosition == -1L) {
            this.loadSoopyData(() -> {});
        }
        return moulberryUuid.equals(this.uuid) ? 1L : this.soopyNetworthLeaderboardPosition;
    }

    public long getSoopyWeightLeaderboardPosition() {
        if (this.soopyWeightLeaderboardPosition == -1L) {
            this.loadSoopyData(() -> {});
        }
        return moulberryUuid.equals(this.uuid) ? 1L : this.soopyWeightLeaderboardPosition;
    }

    public boolean isProfileMaxSoopyWeight(String profileName) {
        String highestProfileName = "";
        double largestProfileWeight = 0.0;
        for (Map.Entry<String, SkyblockProfile> profileEntry : this.nameToProfile.entrySet()) {
            double weightValue;
            Map<String, ProfileViewer.Level> levelingInfo;
            if (!profileEntry.getValue().skillsApiEnabled() || (levelingInfo = profileEntry.getValue().getLevelingInfo()) == null || !((weightValue = new SenitherWeight(levelingInfo).getTotalWeight().getRaw()) > largestProfileWeight)) continue;
            largestProfileWeight = weightValue;
            highestProfileName = profileEntry.getKey();
        }
        return highestProfileName.equals(profileName);
    }

    private long handleSoopyApiResponse(JsonObject response) {
        if (!(response != null && response.has("success") && response.get("success").getAsBoolean() && response.has("data"))) {
            return -3L;
        }
        return response.get("data").getAsLong();
    }

    private void loadSoopyData(Runnable callback) {
        if (this.updatingSoopyData.get()) {
            return;
        }
        this.updatingSoopyData.set(true);
        this.soopyNetworthLeaderboardPosition = -2L;
        this.profileViewer.getManager().apiUtils.request().url("https://api.soopy.dev/lb/lbpos/networth/" + this.uuid).requestJson().handle((jsonObject, throwable) -> {
            this.soopyNetworthLeaderboardPosition = this.handleSoopyApiResponse((JsonObject)jsonObject);
            return null;
        });
        this.soopyWeightLeaderboardPosition = -2L;
        this.profileViewer.getManager().apiUtils.request().url("https://api.soopy.dev/lb/lbpos/weight/" + this.uuid).requestJson().handle((jsonObject, throwable) -> {
            this.soopyWeightLeaderboardPosition = this.handleSoopyApiResponse((JsonObject)jsonObject);
            return null;
        });
        long currentTime = System.currentTimeMillis();
        if (ProfileViewerUtils.lastSoopyRequestTime.containsKey(this.uuid)) {
            if (currentTime - ProfileViewerUtils.lastSoopyRequestTime.get(this.uuid) < 300000L && ProfileViewerUtils.soopyDataCache.containsKey(this.uuid)) {
                this.updateSoopyNetworth(ProfileViewerUtils.soopyDataCache.get(this.uuid));
                callback.run();
            }
        } else {
            ProfileViewerUtils.lastSoopyRequestTime.put(this.uuid, currentTime);
            this.profileViewer.getManager().apiUtils.request().url("https://soopy.dev/api/v2/player_networth2/" + this.uuid).method("POST").postData("application/json", this.profilesArray.toString()).requestJson().handle((jsonObject, throwable) -> {
                this.updateSoopyNetworth((JsonObject)jsonObject);
                ProfileViewerUtils.soopyDataCache.put(this.uuid, (JsonObject)jsonObject);
                callback.run();
                return null;
            });
        }
    }

    private void updateSoopyNetworth(JsonObject jsonObject) {
        if (jsonObject == null || !jsonObject.has("success") || !jsonObject.get("success").getAsBoolean()) {
            for (Map.Entry<String, SkyblockProfile> entry : this.nameToProfile.entrySet()) {
                entry.getValue().soopyNetworth = new SoopyNetworth(null);
            }
        } else {
            for (Map.Entry<String, SkyblockProfile> entry : this.nameToProfile.entrySet()) {
                String profileId = entry.getValue().getOuterProfileJson().get("profile_id").getAsString().replace("-", "");
                JsonElement curProfileData = jsonObject.getAsJsonObject("data").get(profileId);
                if (curProfileData == null) {
                    entry.getValue().soopyNetworth = new SoopyNetworth(null);
                    continue;
                }
                entry.getValue().soopyNetworth = new SoopyNetworth(curProfileData.getAsJsonObject());
            }
        }
        this.updatingSoopyData.set(false);
    }

    public AtomicBoolean getUpdatingSkyblockProfilesState() {
        return this.updatingSkyblockProfilesState;
    }

    @Nullable
    public SkyblockProfile getProfile(String profileName) {
        return this.nameToProfile == null ? null : this.nameToProfile.get(profileName);
    }

    public SkyblockProfile getLatestProfile() {
        return this.nameToProfile.get(this.latestProfileName);
    }

    public String getLatestProfileName() {
        return this.latestProfileName;
    }

    public Map<String, SkyblockProfile> getOrLoadSkyblockProfiles(Runnable runnable) {
        if (this.nameToProfile != null) {
            return this.nameToProfile;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPlayerInfoState < 15000L && this.updatingSkyblockProfilesState.get()) {
            return null;
        }
        this.lastPlayerInfoState = currentTime;
        this.updatingSkyblockProfilesState.set(true);
        this.profileViewer.getManager().ursaClient.get(UrsaClient.profiles(Utils.parseDashlessUUID(this.uuid))).handle((profilesJson, throwable) -> {
            try {
                if (Utils.parseDashlessUUID(this.uuid).toString().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString())) {
                    new ProfileDataLoadedEvent(this.uuid, (JsonObject)profilesJson).post();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (profilesJson != null && profilesJson.has("success") && profilesJson.get("success").getAsBoolean() && profilesJson.has("profiles")) {
                HashMap<String, SkyblockProfile> nameToProfile = new HashMap<String, SkyblockProfile>();
                String latestProfileName = null;
                ArrayList<String> profileNames = new ArrayList<String>();
                if (profilesJson.get("profiles").isJsonNull()) {
                    this.updatingSkyblockProfilesState.set(false);
                    this.nameToProfile = new HashMap<String, SkyblockProfile>();
                    return null;
                }
                for (JsonElement profileEle : profilesJson.getAsJsonArray("profiles")) {
                    JsonObject member;
                    JsonObject members;
                    JsonObject profile = profileEle.getAsJsonObject();
                    if (!profile.has("members") || !(members = profile.getAsJsonObject("members")).has(this.uuid) || (member = members.getAsJsonObject(this.uuid)).has("coop_invitation") && !member.getAsJsonObject("coop_invitation").get("confirmed").getAsBoolean()) continue;
                    String profileName = profile.get("cute_name").getAsString();
                    if (profile.has("selected") && profile.get("selected").getAsBoolean()) {
                        latestProfileName = profileName;
                    }
                    nameToProfile.put(profileName, new SkyblockProfile(profile));
                    profileNames.add(profileName);
                }
                this.nameToProfile = nameToProfile;
                this.profilesArray = profilesJson.getAsJsonArray("profiles");
                this.latestProfileName = latestProfileName;
                this.profileNames.addAll(profileNames);
                this.updatingSkyblockProfilesState.set(false);
                if (runnable != null) {
                    runnable.run();
                }
            }
            return null;
        });
        return null;
    }

    public JsonObject getOrLoadGuildInformation(Runnable runnable) {
        if (this.guildInformation != null) {
            return this.guildInformation;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastGuildInfoState < 15000L && this.updatingGuildInfoState.get()) {
            return null;
        }
        this.lastGuildInfoState = currentTime;
        this.updatingGuildInfoState.set(true);
        this.profileViewer.getManager().ursaClient.get(UrsaClient.guild(Utils.parseDashlessUUID(this.uuid))).handle((jsonObject, ex) -> {
            this.updatingGuildInfoState.set(false);
            if (jsonObject != null && jsonObject.has("success") && jsonObject.get("success").getAsBoolean()) {
                if (jsonObject.get("guild").isJsonNull()) {
                    this.isInGuild = false;
                    return null;
                }
                this.guildInformation = jsonObject.getAsJsonObject("guild");
                if (runnable != null) {
                    runnable.run();
                }
            }
            return null;
        });
        return null;
    }

    public boolean isPlayerInGuild() {
        return this.isInGuild;
    }

    public List<String> getProfileNames() {
        return this.profileNames;
    }

    public void resetCache() {
        this.profilesArray = null;
        this.profileNames = new ArrayList<String>();
        this.guildInformation = null;
        this.playerStatus = null;
        this.nameToProfile = null;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public JsonObject getHypixelProfile() {
        return this.profileViewer.getUuidToHypixelProfile().getOrDefault(this.uuid, null);
    }

    public Map<String, SkyblockProfile> getNameToProfile() {
        return this.nameToProfile;
    }

    public class SkyblockProfile {
        private final JsonObject outerProfileJson;
        private final String gamemode;
        private Integer magicPower = null;
        private LinkedHashMap<String, Integer> tuningInfo = null;
        private Double skyblockLevel = null;
        private EnumChatFormatting skyBlockExperienceColour = null;
        private Map<String, JsonArray> inventoryNameToInfo = null;
        private Map<String, ProfileViewer.Level> levelingInfo = null;
        private JsonObject petsInfo = null;
        private ProfileCollectionInfo collectionsInfo = null;
        private PlayerStats.Stats stats;
        private Long networth = null;
        private SoopyNetworth soopyNetworth = null;
        private MuseumData museumData = null;
        @Nullable
        public APIDataJson APIDataJson;
        private final AtomicBoolean updatingMuseumData = new AtomicBoolean(false);

        private void loadMuseumData() {
            if (this.updatingMuseumData.get()) {
                return;
            }
            this.updatingMuseumData.set(true);
            String profileId = this.getOuterProfileJson().get("profile_id").getAsString();
            ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().ursaClient.get(UrsaClient.museumForProfile(profileId)).handle((museumJson, throwable) -> {
                if (museumJson != null && museumJson.has("success") && museumJson.get("success").getAsBoolean() && museumJson.has("members")) {
                    this.museumData = new MuseumData((JsonObject)museumJson);
                    return null;
                }
                return null;
            });
        }

        public SkyblockProfile(JsonObject outerProfileJson) {
            this.outerProfileJson = outerProfileJson;
            this.gamemode = Utils.getElementAsString(outerProfileJson.get("game_mode"), null);
            try {
                this.APIDataJson = gson.fromJson((JsonElement)this.getProfileJson(), APIDataJson.class);
            }
            catch (Exception exception) {
                NotEnoughUpdates.LOGGER.error("Could not read data", (Throwable)exception);
            }
        }

        @NotNull
        public JsonObject getOuterProfileJson() {
            return this.outerProfileJson;
        }

        @NotNull
        public JsonObject getProfileJson() {
            return Utils.getElement(this.outerProfileJson, "members." + SkyblockProfiles.this.uuid).getAsJsonObject();
        }

        @Nullable
        public String getGamemode() {
            return this.gamemode;
        }

        public int getMagicalPower() {
            if (this.magicPower != null) {
                return this.magicPower;
            }
            Map<String, JsonArray> inventoryInfo = this.getInventoryInfo();
            if (!inventoryInfo.containsKey("talisman_bag")) {
                return -1;
            }
            this.magicPower = ProfileViewerUtils.getMagicalPower(inventoryInfo.get("talisman_bag"), this.getProfileJson());
            return this.magicPower;
        }

        public LinkedHashMap<String, Integer> getTuningInfo() {
            if (this.tuningInfo != null) {
                return this.tuningInfo;
            }
            JsonObject profileJson = this.getProfileJson();
            if (Utils.getElement(profileJson, "accessory_bag_storage.tuning") == null) {
                return null;
            }
            JsonObject tuningData = Utils.getElementOrDefault(profileJson, "accessory_bag_storage.tuning.slot_0", new JsonObject()).getAsJsonObject();
            if (tuningData.entrySet().isEmpty()) {
                return null;
            }
            this.tuningInfo = new LinkedHashMap();
            for (String stat : tuningStats) {
                int statData = tuningData.get(stat).getAsInt();
                this.tuningInfo.put(stat, statData);
            }
            return this.tuningInfo;
        }

        public Map<String, JsonArray> getInventoryInfo() {
            if (this.inventoryNameToInfo != null) {
                return this.inventoryNameToInfo;
            }
            JsonObject profileJson = this.getProfileJson();
            this.inventoryNameToInfo = new HashMap<String, JsonArray>();
            for (String invName : inventoryNames) {
                JsonArray contents = new JsonArray();
                if (invName.equals("backpack_contents")) {
                    JsonObject backpackData = this.getBackpackData(Utils.getElement(profileJson, "inventory.backpack_contents"));
                    this.inventoryNameToInfo.put("backpack_sizes", backpackData.getAsJsonArray("backpack_sizes"));
                    contents = backpackData.getAsJsonArray("contents");
                } else {
                    String path = "inventory." + invName + ".data";
                    if (invName.endsWith("bag") || invName.equals("quiver")) {
                        path = "inventory.bag_contents." + invName + ".data";
                    } else if (invName.equals("candy_inventory_contents")) {
                        path = "shared_inventory.candy_inventory_contents";
                    }
                    String contentBytes = Utils.getElementAsString(Utils.getElement(profileJson, path), SkyblockProfiles.defaultNbtData);
                    try {
                        NBTTagList items2 = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(contentBytes))).func_150295_c("i", 10);
                        for (int j = 0; j < items2.func_74745_c(); ++j) {
                            JsonObject item = SkyblockProfiles.this.profileViewer.getManager().getJsonFromNBTEntry(items2.func_150305_b(j));
                            contents.add(item);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.inventoryNameToInfo.put(invName, contents);
            }
            return this.inventoryNameToInfo;
        }

        private JsonObject getBackpackData(JsonElement backpackContentsJson) {
            JsonArray contents = new JsonArray();
            JsonArray backpackSizes = new JsonArray();
            JsonObject bundledReturn = new JsonObject();
            bundledReturn.add("contents", contents);
            bundledReturn.add("backpack_sizes", backpackSizes);
            if (backpackContentsJson == null || !backpackContentsJson.isJsonObject()) {
                return bundledReturn;
            }
            for (Map.Entry<String, JsonElement> backpack : backpackContentsJson.getAsJsonObject().entrySet()) {
                if (!backpack.getValue().isJsonObject()) continue;
                try {
                    String bytes = Utils.getElementAsString(backpack.getValue().getAsJsonObject().get("data"), SkyblockProfiles.defaultNbtData);
                    NBTTagList items2 = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(bytes))).func_150295_c("i", 10);
                    backpackSizes.add(new JsonPrimitive(items2.func_74745_c()));
                    for (int j = 0; j < items2.func_74745_c(); ++j) {
                        contents.add(SkyblockProfiles.this.profileViewer.getManager().getJsonFromNBTEntry(items2.func_150305_b(j)));
                    }
                }
                catch (IOException iOException) {
                }
            }
            return bundledReturn;
        }

        public EnumChatFormatting getSkyblockLevelColour() {
            if (Constants.SBLEVELS == null || !Constants.SBLEVELS.has("sblevel_colours")) {
                Utils.showOutdatedRepoNotification("sblevels.json or missing sblevel_colours");
                return EnumChatFormatting.WHITE;
            }
            if (this.skyBlockExperienceColour != null) {
                return this.skyBlockExperienceColour;
            }
            double skyblockLevel = this.getSkyblockLevel();
            EnumChatFormatting levelColour = EnumChatFormatting.WHITE;
            JsonObject sblevelColours = Constants.SBLEVELS.getAsJsonObject("sblevel_colours");
            try {
                for (Map.Entry<String, JsonElement> stringJsonElementEntry : sblevelColours.entrySet()) {
                    int nextLevelBracket = Integer.parseInt(stringJsonElementEntry.getKey());
                    EnumChatFormatting valueByName = EnumChatFormatting.func_96300_b((String)stringJsonElementEntry.getValue().getAsString());
                    if (!(skyblockLevel >= (double)nextLevelBracket)) continue;
                    levelColour = valueByName;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.skyBlockExperienceColour = levelColour;
            return this.skyBlockExperienceColour;
        }

        public double getSkyblockLevel() {
            if (this.skyblockLevel != null) {
                return this.skyblockLevel;
            }
            int element = Utils.getElementAsInt(Utils.getElement(this.getProfileJson(), "leveling.experience"), 0);
            this.skyblockLevel = (double)element / 100.0;
            return this.skyblockLevel;
        }

        public boolean skillsApiEnabled() {
            return Utils.getElementAsLong(Utils.getElement(this.getProfileJson(), "player_data.experience.SKILL_COMBAT"), -1L) != -1L;
        }

        public Map<String, ProfileViewer.Level> getLevelingInfo() {
            if (this.levelingInfo != null) {
                return this.levelingInfo;
            }
            JsonObject leveling = Constants.LEVELING;
            if (leveling == null || !leveling.has("social")) {
                Utils.showOutdatedRepoNotification("leveling.json or missing social");
                return null;
            }
            JsonObject profileJson = this.getProfileJson();
            HashMap<String, ProfileViewer.Level> out = new HashMap<String, ProfileViewer.Level>();
            for (String skillName : skills) {
                float skillExperience = 0.0f;
                if (skillName.equals("social")) {
                    for (Map.Entry<String, JsonElement> memberProfileJson : Utils.getElement(this.outerProfileJson, "members").getAsJsonObject().entrySet()) {
                        skillExperience += Utils.getElementAsFloat(Utils.getElement(memberProfileJson.getValue(), "player_data.experience.SKILL_SOCIAL"), 0.0f);
                    }
                } else {
                    skillExperience += Utils.getElementAsFloat(Utils.getElement(profileJson, "player_data.experience.SKILL_" + skillName.toUpperCase(Locale.ROOT)), 0.0f);
                }
                JsonArray levelingArray = Utils.getElement(leveling, "leveling_xp").getAsJsonArray();
                if (skillName.equals("runecrafting")) {
                    levelingArray = Utils.getElement(leveling, "runecrafting_xp").getAsJsonArray();
                } else if (skillName.equals("social")) {
                    levelingArray = Utils.getElement(leveling, "social").getAsJsonArray();
                }
                int maxLevel = ProfileViewerUtils.getLevelingCap(leveling, skillName);
                if (skillName.equals("farming")) {
                    maxLevel += Utils.getElementAsInt(Utils.getElement(profileJson, "jacobs_contest.perks.farming_level_cap"), 0);
                }
                if (skillName.equals("taming")) {
                    maxLevel += Utils.getElementOrDefault(profileJson, "pets_data.pet_care.pet_types_sacrificed", new JsonArray()).getAsJsonArray().size();
                }
                out.put(skillName, ProfileViewerUtils.getLevel(levelingArray, skillExperience, maxLevel, false));
            }
            out.put("hotm", ProfileViewerUtils.getLevel(Utils.getElement(leveling, "HOTM").getAsJsonArray(), Utils.getElementAsFloat(Utils.getElement(profileJson, "mining_core.experience"), 0.0f), ProfileViewerUtils.getLevelingCap(leveling, "HOTM"), false));
            out.put("catacombs", ProfileViewerUtils.getLevel(Utils.getElement(leveling, "catacombs").getAsJsonArray(), Utils.getElementAsFloat(Utils.getElement(profileJson, "dungeons.dungeon_types.catacombs.experience"), 0.0f), ProfileViewerUtils.getLevelingCap(leveling, "catacombs"), false));
            out.put("cosmetic_catacombs", ProfileViewerUtils.getLevel(Utils.getElement(leveling, "catacombs").getAsJsonArray(), Utils.getElementAsFloat(Utils.getElement(profileJson, "dungeons.dungeon_types.catacombs.experience"), 0.0f), 99, false));
            for (String className : Weight.DUNGEON_CLASS_NAMES) {
                float classExperience = Utils.getElementAsFloat(Utils.getElement(profileJson, "dungeons.player_classes." + className + ".experience"), 0.0f);
                out.put(className, ProfileViewerUtils.getLevel(Utils.getElement(leveling, "catacombs").getAsJsonArray(), classExperience, ProfileViewerUtils.getLevelingCap(leveling, "catacombs"), false));
                out.put("cosmetic_" + className, ProfileViewerUtils.getLevel(Utils.getElement(leveling, "catacombs").getAsJsonArray(), classExperience, 99, false));
            }
            for (String slayerName : Weight.SLAYER_NAMES) {
                float slayerExperience = Utils.getElementAsFloat(Utils.getElement(profileJson, "slayer.slayer_bosses." + slayerName + ".xp"), 0.0f);
                out.put(slayerName, ProfileViewerUtils.getLevel(Utils.getElement(leveling, "slayer_xp." + slayerName).getAsJsonArray(), slayerExperience, slayerName.equals("vampire") ? 5 : 9, true));
            }
            this.levelingInfo = out;
            return this.levelingInfo;
        }

        public int getBestiaryXp() {
            return BestiaryData.calculateBestiarySkyblockXp(this.getProfileJson());
        }

        public JsonObject getPetsInfo() {
            if (this.petsInfo != null) {
                return this.petsInfo;
            }
            JsonArray petsArray = Utils.getElementOrDefault(this.getProfileJson(), "pets_data.pets", new JsonArray()).getAsJsonArray();
            if (petsArray.size() > 0) {
                JsonObject activePet = null;
                for (JsonElement petEle : petsArray.getAsJsonArray()) {
                    JsonObject petObj = petEle.getAsJsonObject();
                    if (!petObj.has("active") || !petObj.get("active").getAsBoolean()) continue;
                    activePet = petObj;
                    break;
                }
                this.petsInfo = new JsonObject();
                this.petsInfo.add("active_pet", activePet);
                this.petsInfo.add("pets", petsArray);
                return this.petsInfo;
            }
            return null;
        }

        public ProfileCollectionInfo getCollectionInfo() {
            if (this.collectionsInfo != null) {
                return this.collectionsInfo;
            }
            this.collectionsInfo = ProfileCollectionInfo.getCollectionData(this.outerProfileJson, SkyblockProfiles.this.uuid).getNow(null);
            return this.collectionsInfo;
        }

        public PlayerStats.Stats getStats() {
            if (this.stats != null) {
                return this.stats;
            }
            if (this.skillsApiEnabled()) {
                return null;
            }
            this.stats = PlayerStats.getStats(this.getLevelingInfo(), this.getInventoryInfo(), this.getPetsInfo(), this.getProfileJson());
            return this.stats;
        }

        public long getNetworth() {
            if (this.networth != null) {
                return this.networth;
            }
            Map<String, JsonArray> inventoryInfo = this.getInventoryInfo();
            JsonObject profileInfo2 = this.getProfileJson();
            HashMap<String, Long> mostExpensiveInternal = new HashMap<String, Long>();
            long networth = 0L;
            for (Map.Entry<String, JsonArray> entry : inventoryInfo.entrySet()) {
                for (JsonElement element : entry.getValue()) {
                    long auctionPrice;
                    JsonObject item;
                    String internalName;
                    if (element == null || !element.isJsonObject() || ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.isVanillaItem(internalName = (item = element.getAsJsonObject()).get("internalname").getAsString())) continue;
                    JsonObject bzInfo = ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getBazaarInfo(internalName);
                    if (bzInfo != null && bzInfo.has("curr_sell")) {
                        auctionPrice = (int)bzInfo.get("curr_sell").getAsFloat();
                    } else {
                        auctionPrice = (long)((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getItemAvgBin(internalName);
                        if (auctionPrice <= 0L) {
                            auctionPrice = ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getLowestBin(internalName);
                        }
                    }
                    try {
                        if (item.has("item_contents")) {
                            JsonArray bytesArr = item.get("item_contents").getAsJsonArray();
                            byte[] bytes = new byte[bytesArr.size()];
                            for (int bytesArrI = 0; bytesArrI < bytesArr.size(); ++bytesArrI) {
                                bytes[bytesArrI] = bytesArr.get(bytesArrI).getAsByte();
                            }
                            NBTTagCompound contents_nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
                            NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
                            for (int j = 0; j < items2.func_74745_c(); ++j) {
                                long auctionPrice2;
                                if (items2.func_150305_b(j).func_150296_c().size() <= 0) continue;
                                NBTTagCompound nbt = items2.func_150305_b(j).func_74775_l("tag");
                                String internalname2 = SkyblockProfiles.this.profileViewer.getManager().createItemResolutionQuery().withItemNBT(nbt).resolveInternalName();
                                if (internalname2 == null || ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.isVanillaItem(internalname2)) continue;
                                JsonObject bzInfo2 = ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getBazaarInfo(internalname2);
                                if (bzInfo2 != null && bzInfo2.has("curr_sell")) {
                                    auctionPrice2 = (int)bzInfo2.get("curr_sell").getAsFloat();
                                } else {
                                    auctionPrice2 = (long)((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getItemAvgBin(internalname2);
                                    if (auctionPrice2 <= 0L) {
                                        auctionPrice2 = ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getLowestBin(internalname2);
                                    }
                                }
                                byte count2 = items2.func_150305_b(j).func_74771_c("Count");
                                mostExpensiveInternal.put(internalname2, auctionPrice2 * (long)count2 + mostExpensiveInternal.getOrDefault(internalname2, 0L));
                                networth += auctionPrice2 * (long)count2;
                            }
                        }
                    }
                    catch (IOException bytesArr) {
                        // empty catch block
                    }
                    int count = 1;
                    if (element.getAsJsonObject().has("count")) {
                        count = element.getAsJsonObject().get("count").getAsInt();
                    }
                    mostExpensiveInternal.put(internalName, auctionPrice * (long)count + mostExpensiveInternal.getOrDefault(internalName, 0L));
                    networth += auctionPrice * (long)count;
                }
            }
            if (networth == 0L) {
                return -1L;
            }
            networth = (int)((float)networth * 1.3f);
            JsonObject petsInfo = this.getPetsInfo();
            if (petsInfo != null && petsInfo.has("pets") && petsInfo.get("pets").isJsonArray()) {
                JsonArray pets = petsInfo.get("pets").getAsJsonArray();
                for (JsonElement element : pets) {
                    String internalname2;
                    JsonObject info2;
                    if (!element.isJsonObject()) continue;
                    JsonObject pet = element.getAsJsonObject();
                    String petname = pet.get("type").getAsString();
                    String tier = pet.get("tier").getAsString();
                    String tierNum = GuiProfileViewer.RARITY_TO_NUM.get(tier);
                    if (tierNum == null || (info2 = ((SkyblockProfiles)SkyblockProfiles.this).profileViewer.getManager().auctionManager.getItemAuctionInfo(internalname2 = petname + ";" + tierNum)) == null || !info2.has("price") || !info2.has("count")) continue;
                    int auctionPrice2 = (int)(info2.get("price").getAsFloat() / info2.get("count").getAsFloat());
                    networth += (long)auctionPrice2;
                }
            }
            float bankBalance = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "banking.balance"), 0.0f);
            float purseBalance = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "currencies.coin_purse"), 0.0f);
            networth = (long)((float)networth + (bankBalance + purseBalance));
            this.networth = networth;
            return this.networth;
        }

        public SoopyNetworth getSoopyNetworth(Runnable callback) {
            if (this.soopyNetworth != null) {
                return this.soopyNetworth;
            }
            SkyblockProfiles.this.loadSoopyData(callback);
            return new SoopyNetworth(null).asLoading();
        }

        public MuseumData getMuseumData() {
            if (this.museumData != null) {
                return this.museumData;
            }
            this.loadMuseumData();
            return new MuseumData(null).asLoading();
        }

        public void updateBeastMasterMultiplier() {
            if (!SkyblockProfiles.this.getUuid().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""))) {
                return;
            }
            boolean hasBeastmasterCrest = false;
            PetInfoOverlay.Rarity currentBeastRarity = PetInfoOverlay.Rarity.COMMON;
            for (JsonElement talisman : this.getInventoryInfo().get("talisman_bag")) {
                String internalName;
                if (talisman.isJsonNull() || !(internalName = talisman.getAsJsonObject().get("internalname").getAsString()).startsWith("BEASTMASTER_CREST")) continue;
                hasBeastmasterCrest = true;
                try {
                    PetInfoOverlay.Rarity talismanRarity = PetInfoOverlay.Rarity.valueOf(internalName.replace("BEASTMASTER_CREST_", ""));
                    if (talismanRarity.beastcreatMultiplyer <= currentBeastRarity.beastcreatMultiplyer) continue;
                    currentBeastRarity = talismanRarity;
                }
                catch (Exception exception) {}
            }
            if (hasBeastmasterCrest) {
                JsonObject stats = this.getProfileJson().get("player_stats").getAsJsonObject();
                int mk = Utils.getElementAsInt(Utils.getElement(stats, "mythos.kills"), 0);
                float petXpBoost = mk > 10000 ? 1.0f : (mk > 7500 ? 0.9f : (mk > 5000 ? 0.8f : (mk > 2500 ? 0.7f : (mk > 1000 ? 0.6f : (mk > 500 ? 0.5f : (mk > 250 ? 0.4f : (mk > 100 ? 0.3f : (mk > 25 ? 0.2f : 0.1f))))))));
                PetInfoOverlay.getConfig().beastMultiplier = (petXpBoost == 0.0f ? 0.1f : petXpBoost) * (float)currentBeastRarity.beastcreatMultiplyer;
            }
        }

        public void updateTamingLevel() {
            if (!SkyblockProfiles.this.getUuid().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""))) {
                return;
            }
            if (!SkyblockProfiles.this.getLatestProfile().skillsApiEnabled()) {
                return;
            }
            if (this.getLevelingInfo() != null && this.getLevelingInfo().get("taming") != null) {
                PetInfoOverlay.getConfig().tamingLevel = (int)this.getLevelingInfo().get((Object)"taming").level;
            }
        }

        @Nullable
        public APIDataJson getAPIDataJson() {
            return this.APIDataJson;
        }

        public class MuseumData {
            private long museumValue;
            private final Map<String, JsonArray> weaponItems = new HashMap<String, JsonArray>();
            private final Map<String, JsonArray> armorItems = new HashMap<String, JsonArray>();
            private final Map<String, JsonArray> raritiesItems = new HashMap<String, JsonArray>();
            private final List<JsonArray> specialItems = new ArrayList<JsonArray>();
            private final Map<String, Pair<Long, Boolean>> savedItems = new HashMap<String, Pair<Long, Boolean>>();

            private MuseumData(JsonObject museumJson) {
                JsonArray specialItemsData;
                JsonArray contents;
                JsonObject museumItemsData;
                JsonObject museum = Constants.MUSEUM;
                if (museum == null) {
                    Utils.showOutdatedRepoNotification("museum.json");
                    this.museumValue = -3L;
                    return;
                }
                if (museumJson == null || museumJson.isJsonNull() || museumJson.get("members").isJsonNull()) {
                    this.museumValue = -2L;
                    return;
                }
                JsonObject members = museumJson.get("members").getAsJsonObject();
                if (members == null || members.isJsonNull() || !members.has(SkyblockProfiles.this.uuid)) {
                    this.museumValue = -2L;
                    return;
                }
                JsonObject member = members.get(SkyblockProfiles.this.uuid).getAsJsonObject();
                if (member == null || member.isJsonNull() || !member.has("value")) {
                    this.museumValue = -2L;
                    return;
                }
                this.museumValue = member.get("value").getAsLong();
                if (member.has("items") && (museumItemsData = member.get("items").getAsJsonObject()) != null) {
                    for (Map.Entry entry : museumItemsData.entrySet()) {
                        JsonObject itemJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                        contents = this.parseNbt(itemJson);
                        String itemName = (String)entry.getKey();
                        Long donationTime = itemJson.get("donated_time").getAsLong();
                        boolean borrowing = false;
                        if (itemJson.has("borrowing")) {
                            borrowing = itemJson.get("borrowing").getAsBoolean();
                        }
                        this.getDataAndChildren(itemName, (Pair<Long, Boolean>)Pair.of((Object)donationTime, (Object)borrowing));
                        this.processItems(itemName, contents);
                    }
                }
                if (member.has("special") && (specialItemsData = member.get("special").getAsJsonArray()) != null) {
                    for (JsonElement jsonElement : specialItemsData) {
                        JsonObject itemData = jsonElement.getAsJsonObject();
                        contents = this.parseNbt(itemData);
                        long donationTime = itemData.get("donated_time").getAsLong();
                        JsonObject firstItem = contents.get(0).getAsJsonObject();
                        String itemID = firstItem.get("internalname").getAsString();
                        this.getDataAndChildren(itemID, (Pair<Long, Boolean>)Pair.of((Object)donationTime, (Object)false));
                        this.specialItems.add(contents);
                    }
                }
            }

            private JsonArray parseNbt(JsonObject nbt) {
                JsonArray contents = new JsonArray();
                JsonObject contentItems = nbt.get("items").getAsJsonObject();
                String contentBytes = contentItems.get("data").getAsString();
                try {
                    NBTTagList items2 = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(contentBytes))).func_150295_c("i", 10);
                    for (int j = 0; j < items2.func_74745_c(); ++j) {
                        JsonObject item = SkyblockProfiles.this.profileViewer.getManager().getJsonFromNBTEntry(items2.func_150305_b(j));
                        if (item == null) continue;
                        contents.add(item);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return contents;
            }

            private void processItems(String itemName, JsonArray contents) {
                JsonObject museum = Constants.MUSEUM;
                this.storeItem(itemName, contents, museum.get("weapons").getAsJsonArray(), this.weaponItems);
                this.storeItem(itemName, contents, museum.get("armor").getAsJsonArray(), this.armorItems);
                this.storeItem(itemName, contents, museum.get("rarities").getAsJsonArray(), this.raritiesItems);
            }

            private void storeItem(String itemName, JsonArray contents, JsonArray items2, Map<String, JsonArray> itemMap) {
                for (JsonElement item : items2) {
                    if (!Objects.equals(item.getAsString(), itemName)) continue;
                    itemMap.put(itemName, contents);
                    return;
                }
            }

            private void getDataAndChildren(String name, Pair<Long, Boolean> itemData) {
                JsonObject children = Constants.MUSEUM.get("children").getAsJsonObject();
                if (this.savedItems.containsKey(name)) {
                    return;
                }
                this.savedItems.put(name, itemData);
                if (children.has(name)) {
                    String childId;
                    String childName = childId = children.get(name).getAsString();
                    JsonObject nameMappings = Constants.MUSEUM.get("armor_to_id").getAsJsonObject();
                    if (nameMappings.has(childId)) {
                        childName = nameMappings.get(childId).getAsString();
                    }
                    String displayName = NotEnoughUpdates.INSTANCE.manager.getDisplayName(childName);
                    ItemStack stack = Utils.createItemStack(Items.field_151100_aR, displayName, 10, "Donated as higher tier");
                    JsonObject item = SkyblockProfiles.this.profileViewer.getManager().getJsonForItem(stack);
                    item.add("internalname", new JsonPrimitive("_"));
                    JsonArray itemArray = new JsonArray();
                    itemArray.add(item);
                    this.processItems(childId, itemArray);
                    this.getDataAndChildren(childId, itemData);
                }
            }

            private MuseumData asLoading() {
                this.museumValue = -1L;
                return this;
            }

            public long getValue() {
                return this.museumValue;
            }

            public Map<String, JsonArray> getWeaponItems() {
                return this.weaponItems;
            }

            public Map<String, JsonArray> getArmorItems() {
                return this.armorItems;
            }

            public Map<String, JsonArray> getRaritiesItems() {
                return this.raritiesItems;
            }

            public List<JsonArray> getSpecialItems() {
                return this.specialItems;
            }

            public Map<String, Pair<Long, Boolean>> getSavedItems() {
                return this.savedItems;
            }
        }
    }

    public static class SoopyNetworth {
        private final Map<String, Long> categoryToTotal = new LinkedHashMap<String, Long>();
        private long networth;

        private SoopyNetworth(JsonObject nwData) {
            if (nwData == null || nwData.isJsonNull() || nwData.get("total").isJsonNull()) {
                this.networth = -2L;
                return;
            }
            this.networth = nwData.get("total").getAsLong();
            HashMap<String, Long> categoryToTotal = new HashMap<String, Long>();
            for (Map.Entry<String, JsonElement> entry : nwData.get("categories").getAsJsonObject().entrySet()) {
                if (entry.getValue().isJsonNull()) continue;
                categoryToTotal.put(entry.getKey(), entry.getValue().getAsLong());
            }
            categoryToTotal.entrySet().stream().sorted(Comparator.comparingLong(e2 -> -((Long)e2.getValue()).longValue())).forEachOrdered(e2 -> this.categoryToTotal.put((String)e2.getKey(), (Long)e2.getValue()));
        }

        private SoopyNetworth asLoading() {
            this.networth = -1L;
            return this;
        }

        public long getNetworth() {
            return this.networth;
        }

        public Map<String, Long> getCategoryToTotal() {
            return this.categoryToTotal;
        }
    }
}

