/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;

public class ProfileViewerUtils {
    static Map<String, ItemStack> playerSkullCache = new HashMap<String, ItemStack>();
    static Map<String, Long> lastSoopyRequestTime = new HashMap<String, Long>();
    static Map<String, JsonObject> soopyDataCache = new HashMap<String, JsonObject>();

    public static JsonArray readInventoryInfo(JsonObject profileInfo2, String bagName) {
        NBTTagCompound nbt;
        String bytes = Utils.getElementAsString(Utils.getElement(profileInfo2, "inventory.bag_contents." + bagName + ".data"), "H4sIAAAAAAAAAONiYOBkYMzkYmBg0GUgCQAA4gDYkzoAAAA=");
        try {
            nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(bytes)));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        NBTTagList items2 = nbt.func_150295_c("i", 10);
        JsonArray contents = new JsonArray();
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        for (int j = 0; j < items2.func_74745_c(); ++j) {
            contents.add(manager.getJsonFromNBTEntry(items2.func_150305_b(j)));
        }
        return contents;
    }

    public static int getMagicalPower(JsonArray talismanBag, JsonObject profileInfo2) {
        Map accessories = JsonUtils.getJsonArrayAsStream(talismanBag).map(o -> {
            try {
                return JsonToNBT.func_180713_a((String)o.getAsJsonObject().get("nbttag").getAsString());
            }
            catch (Exception ignored) {
                return null;
            }
        }).filter(Objects::nonNull).map(tag -> {
            NBTTagList loreTagList = tag.func_74775_l("display").func_150295_c("Lore", 8);
            String lastElement = loreTagList.func_150307_f(loreTagList.func_74745_c() - 1);
            if (lastElement.contains(EnumChatFormatting.OBFUSCATED.toString())) {
                lastElement = lastElement.substring(lastElement.indexOf(32)).trim().substring(4);
            }
            JsonArray lastElementJsonArray = new JsonArray();
            lastElementJsonArray.add(new JsonPrimitive(lastElement));
            return new AbstractMap.SimpleEntry<String, Integer>(tag.func_74775_l("ExtraAttributes").func_74779_i("id"), Utils.getRarityFromLore(lastElementJsonArray));
        }).sorted(Comparator.comparingInt(e2 -> -((Integer)e2.getValue()).intValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        HashSet<String> ignoredTalismans = new HashSet<String>();
        boolean countedCrabHat = false;
        int powerAmount = 0;
        if (profileInfo2.has("rift") && profileInfo2.getAsJsonObject("rift").has("access") && profileInfo2.getAsJsonObject("rift").getAsJsonObject("access").has("consumed_prism")) {
            powerAmount += 11;
        }
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry entry : accessories.entrySet()) {
            if (duplicates.contains(entry.getKey())) continue;
            JsonObject misc = Constants.MISC;
            JsonElement talisman_upgrades_element = misc.get("talisman_upgrades");
            if (talisman_upgrades_element == null) break;
            String internalName = (String)entry.getKey();
            JsonObject talisman_upgrades = talisman_upgrades_element.getAsJsonObject();
            if (!talisman_upgrades.has(internalName)) continue;
            JsonArray upgrades = talisman_upgrades.get(internalName).getAsJsonArray();
            for (Map.Entry entry2 : accessories.entrySet()) {
                if (entry2 == entry) continue;
                String internalname2 = (String)entry2.getKey();
                ArrayList<String> upgradeIDs = new ArrayList<String>();
                for (int j = 0; j < upgrades.size(); ++j) {
                    String upgrade = upgrades.get(j).getAsString();
                    upgradeIDs.add(upgrade);
                    if (!internalname2.equals(upgrade)) continue;
                    duplicates.add(internalname2);
                }
            }
        }
        for (Map.Entry entry : accessories.entrySet()) {
            JsonObject data;
            if (ignoredTalismans.contains(entry.getKey()) || duplicates.contains(entry.getKey())) continue;
            JsonArray children = Utils.getElementOrDefault(Constants.PARENTS, (String)entry.getKey(), new JsonArray()).getAsJsonArray();
            for (JsonElement child : children) {
                ignoredTalismans.add(child.getAsString());
            }
            if (((String)entry.getKey()).equals("HEGEMONY_ARTIFACT")) {
                switch ((Integer)entry.getValue()) {
                    case 4: {
                        powerAmount += 16;
                        break;
                    }
                    case 5: {
                        powerAmount += 22;
                    }
                }
            }
            if (((String)entry.getKey()).equals("ABICASE") && profileInfo2 != null && profileInfo2.has("nether_island_player_data") && (data = profileInfo2.get("nether_island_player_data").getAsJsonObject()).has("abiphone") && data.get("abiphone").getAsJsonObject().has("active_contacts")) {
                int contact = data.get("abiphone").getAsJsonObject().get("active_contacts").getAsJsonArray().size();
                powerAmount = (int)((double)powerAmount + Math.floor(contact / 2));
            }
            if (((String)entry.getKey()).startsWith("PARTY_HAT") || ((String)entry.getKey()).startsWith("BALLOON_HAT")) {
                if (countedCrabHat) continue;
                countedCrabHat = true;
            }
            switch ((Integer)entry.getValue()) {
                case 0: 
                case 6: {
                    powerAmount += 3;
                    break;
                }
                case 1: 
                case 7: {
                    powerAmount += 5;
                    break;
                }
                case 2: {
                    powerAmount += 8;
                    break;
                }
                case 3: {
                    powerAmount += 12;
                    break;
                }
                case 4: {
                    powerAmount += 16;
                    break;
                }
                case 5: {
                    powerAmount += 22;
                }
            }
        }
        return powerAmount;
    }

    public static int getLevelingCap(JsonObject leveling, String skillName) {
        JsonElement capsElement = Utils.getElement(leveling, "leveling_caps");
        return capsElement != null && capsElement.isJsonObject() && capsElement.getAsJsonObject().has(skillName) ? capsElement.getAsJsonObject().get(skillName).getAsInt() : 50;
    }

    public static ProfileViewer.Level getLevel(JsonArray levelingArray, float xp, int levelCap, boolean cumulative) {
        ProfileViewer.Level levelObj = new ProfileViewer.Level();
        levelObj.totalXp = xp;
        levelObj.maxLevel = levelCap;
        for (int level = 0; level < levelingArray.size(); ++level) {
            float levelXp = levelingArray.get(level).getAsFloat();
            if (levelXp > xp) {
                if (cumulative) {
                    float previous = level > 0 ? levelingArray.get(level - 1).getAsFloat() : 0.0f;
                    levelObj.maxXpForLevel = levelXp - previous;
                    levelObj.level = (float)(1 + level) + (xp - levelXp) / levelObj.maxXpForLevel;
                } else {
                    levelObj.maxXpForLevel = levelXp;
                    levelObj.level = (float)level + xp / levelXp;
                }
                if (levelObj.level > (float)levelCap) {
                    levelObj.level = levelCap;
                    levelObj.maxed = true;
                }
                return levelObj;
            }
            if (cumulative) continue;
            xp -= levelXp;
        }
        levelObj.level = Math.min(levelingArray.size(), levelCap);
        levelObj.maxed = true;
        return levelObj;
    }

    public static void saveSearch(String username) {
        if (username == null) {
            return;
        }
        String nameLower = username.toLowerCase(Locale.ROOT);
        if (nameLower.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_().toLowerCase(Locale.ROOT))) {
            return;
        }
        ArrayList<String> previousProfileSearches = NotEnoughUpdates.INSTANCE.config.hidden.previousProfileSearches;
        previousProfileSearches.remove(nameLower);
        previousProfileSearches.add(0, nameLower);
        while (previousProfileSearches.size() > 6) {
            previousProfileSearches.remove(previousProfileSearches.size() - 1);
        }
    }

    private static ItemStack fallBackSkull() {
        return Utils.createSkull("Simon", "f3c4dfb91c7b40ac81fd462538538523", "ewogICJ0aW1lc3RhbXAiIDogMTY4NzQwMTM4MjY4MywKICAicHJvZmlsZUlkIiA6ICJmM2M0ZGZiOTFjN2I0MGFjODFmZDQ2MjUzODUzODUyMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJTaW1vbiIsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9kN2ViYThhZWU0ZmQxMTUxMmI3ZTFhMjc5YTE0YWM2NDhlNDQzNDgxYjlmMzcxMzZhNzEwMThkMzg3Mjk0Y2YzIgogICAgfQogIH0KfQ");
    }

    public static ItemStack getPlayerData(String username) {
        if (username == null) {
            return new ItemStack(Blocks.field_150348_b);
        }
        String nameLower = username.toLowerCase(Locale.ROOT);
        if (!playerSkullCache.containsKey(nameLower)) {
            playerSkullCache.put(nameLower, ProfileViewerUtils.fallBackSkull());
            ProfileViewerUtils.getPlayerSkull(nameLower, skull -> {
                if (skull == null) {
                    skull = ProfileViewerUtils.fallBackSkull();
                }
                playerSkullCache.put(nameLower, (ItemStack)skull);
            });
        }
        return playerSkullCache.get(nameLower);
    }

    private static void getPlayerSkull(String username, Consumer<ItemStack> callback) {
        if (NotEnoughUpdates.profileViewer.nameToUuid.containsKey(username) && NotEnoughUpdates.profileViewer.nameToUuid.get(username) == null) {
            callback.accept(null);
            return;
        }
        NotEnoughUpdates.profileViewer.getPlayerUUID(username, uuid -> {
            if (uuid == null) {
                callback.accept(null);
            } else {
                NotEnoughUpdates.INSTANCE.manager.apiUtils.request().url("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").requestJson().thenAcceptAsync(jsonObject -> {
                    JsonObject textureObject;
                    JsonArray propertiesArray;
                    if (jsonObject.has("properties") && jsonObject.get("properties").isJsonArray() && (propertiesArray = jsonObject.getAsJsonArray("properties")).size() > 0 && (textureObject = propertiesArray.get(0).getAsJsonObject()).has("value") && textureObject.get("value").isJsonPrimitive() && textureObject.get("value").getAsJsonPrimitive().isString()) {
                        ItemStack skull = Utils.createSkull(username, uuid, textureObject.get("value").getAsString());
                        callback.accept(skull);
                    }
                });
            }
        });
    }

    public static int onSlotToChangePage(int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (mouseX >= guiLeft - 29 && mouseX <= guiLeft) {
            if (mouseY >= guiTop && mouseY <= guiTop + 28) {
                return 1;
            }
            if (mouseY + 28 >= guiTop && mouseY <= guiTop + 56) {
                return 2;
            }
        }
        return 0;
    }
}

