/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class BingoPage
extends GuiProfileViewerPage {
    private static final ResourceLocation BINGO_GUI_TEXTURE = new ResourceLocation("notenoughupdates:pv_bingo_tab.png");
    private long lastResourceRequest;
    private List<JsonObject> bingoGoals = null;
    private int currentEventId;

    public BingoPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        this.loadBingoResources();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        JsonObject bingoInfo = GuiProfileViewer.getProfile().getBingoInformation();
        if (bingoInfo == null) {
            this.showMissingDataMessage(guiLeft, guiTop);
            return;
        }
        if (this.bingoGoals == null) {
            return;
        }
        JsonArray events = bingoInfo.get("events").getAsJsonArray();
        JsonObject lastEvent = events.get(events.size() - 1).getAsJsonObject();
        int lastParticipatedId = lastEvent.get("key").getAsInt();
        if (this.currentEventId != lastParticipatedId) {
            this.showMissingDataMessage(guiLeft, guiTop);
            return;
        }
        List<String> completedGoals = this.jsonArrayToStringList(lastEvent.get("completed_goals").getAsJsonArray());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BINGO_GUI_TEXTURE);
        Utils.drawTexturedRect(guiLeft, guiTop, 431.0f, 202.0f, 9728);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        int row = 0;
        int col = 0;
        int initialY = guiTop + 46;
        int initialX = guiLeft + 231;
        int xAdjustment = 0;
        int yAdjustment = 0;
        for (JsonObject bingoGoal : this.bingoGoals) {
            Item material;
            boolean dye = false;
            boolean completed = false;
            boolean communityGoal = false;
            if (bingoGoal.has("tiers")) {
                material = this.isCommunityGoalFinished(bingoGoal) ? Item.func_150898_a((Block)Blocks.field_150475_bE) : Item.func_150898_a((Block)Blocks.field_150339_S);
                RenderHelper.func_74520_c();
                completed = true;
                communityGoal = true;
                yAdjustment = -1;
                xAdjustment = -1;
            } else if (completedGoals.contains(bingoGoal.get("id").getAsString())) {
                material = Items.field_151100_aR;
                xAdjustment = -1;
                dye = true;
                completed = true;
            } else {
                material = Items.field_151121_aF;
            }
            ItemStack itemStack = new ItemStack(material);
            if (dye) {
                itemStack.func_77964_b(10);
            }
            int x = col == 0 ? initialX + xAdjustment : initialX + 24 * col + xAdjustment;
            int y = row == 0 ? initialY + yAdjustment : initialY + 24 * row + yAdjustment;
            Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStack, x, y);
            int n = y = communityGoal ? y - 1 : y;
            if (mouseX >= x && mouseX < x + 24 && mouseY >= y && mouseY <= y + 24) {
                Utils.drawHoveringText(this.getTooltip(bingoGoal, completed, communityGoal), mouseX, mouseY, width, height, -1);
            }
            if (++col != 5) continue;
            col = 0;
            ++row;
        }
        String totalPointsString = EnumChatFormatting.AQUA + "Collected Points: " + EnumChatFormatting.WHITE + lastEvent.get("points").getAsInt();
        int totalGoals = completedGoals.size();
        String personalGoalsString = totalGoals == 20 ? EnumChatFormatting.AQUA + "Personal Goals: " + EnumChatFormatting.GOLD + "20/20" : EnumChatFormatting.AQUA + "Personal Goals: " + EnumChatFormatting.WHITE + completedGoals.size() + EnumChatFormatting.GOLD + "/" + EnumChatFormatting.WHITE + 20;
        Utils.drawStringF(totalPointsString, guiLeft + 22, guiTop + 19, true, 0);
        Utils.drawStringF(personalGoalsString, guiLeft + 22, guiTop + 31, true, 0);
        GlStateManager.func_179145_e();
    }

    private boolean isCommunityGoalFinished(JsonObject goal) {
        JsonElement tier;
        long currentTier;
        JsonArray tiers = goal.get("tiers").getAsJsonArray();
        int totalTiers = tiers.size();
        long progress = goal.get("progress").getAsLong();
        int finalTier = 0;
        Iterator<JsonElement> iterator = tiers.iterator();
        while (iterator.hasNext() && progress >= (currentTier = (tier = iterator.next()).getAsLong())) {
            ++finalTier;
        }
        return finalTier == totalTiers;
    }

    private String generateProgressIndicator(double progress, double goal) {
        int totalFields = 20;
        double percentage = progress / goal * 100.0;
        int filled = percentage >= 100.0 ? 20 : (int)Math.round(percentage / 100.0 * 20.0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EnumChatFormatting.DARK_GREEN);
        for (int i = 0; i < totalFields; ++i) {
            stringBuilder.append("-");
            if (i <= filled) continue;
            stringBuilder.append(EnumChatFormatting.GRAY);
        }
        return stringBuilder.toString();
    }

    private List<String> getTooltip(JsonObject goal, boolean completed, boolean communityGoal) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (communityGoal) {
            JsonElement tier;
            double currentTier;
            JsonArray tiers = goal.get("tiers").getAsJsonArray();
            int totalTiers = tiers.size();
            double progress = goal.get("progress").getAsLong();
            int finalTier = 0;
            Iterator<JsonElement> iterator = tiers.iterator();
            while (iterator.hasNext() && !(progress < (currentTier = (double)(tier = iterator.next()).getAsLong()))) {
                ++finalTier;
            }
            double nextTier = finalTier < totalTiers ? (double)tiers.get(totalTiers - 1).getAsLong() : (double)tiers.get(finalTier - 1).getAsLong();
            int progressToNextTier = (int)Math.round(progress / nextTier * 100.0);
            if (progressToNextTier > 100) {
                progressToNextTier = 100;
            }
            String progressBar = this.generateProgressIndicator(progress, nextTier);
            String name = goal.get("name").getAsString();
            int nextTierNum = finalTier < totalTiers ? finalTier + 1 : totalTiers;
            String nextTierString = Utils.shortNumberFormat(nextTier, 0);
            String progressString = Utils.shortNumberFormat(progress, 0);
            tooltip.add(EnumChatFormatting.GREEN + name + " " + finalTier);
            tooltip.add(EnumChatFormatting.DARK_GRAY + "Community Goal");
            tooltip.add("");
            tooltip.add(EnumChatFormatting.GRAY + "Progress to " + name + " " + nextTierNum + ": " + EnumChatFormatting.YELLOW + progressToNextTier + EnumChatFormatting.GOLD + "%");
            tooltip.add(progressBar + EnumChatFormatting.YELLOW + " " + progressString + EnumChatFormatting.GOLD + "/" + EnumChatFormatting.YELLOW + nextTierString);
            tooltip.add("");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "Community Goals are");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "collaborative - anyone with a");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "Bingo profile can help to reach");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "the goal!");
            tooltip.add("");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "The more you contribute");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "towards the goal, the more you");
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + "will be rewarded");
            if (finalTier == totalTiers) {
                tooltip.add("");
                tooltip.add(EnumChatFormatting.GREEN + "GOAL REACHED");
            }
        } else {
            tooltip.add(EnumChatFormatting.GREEN + goal.get("name").getAsString());
            tooltip.add(EnumChatFormatting.DARK_GRAY + "Personal Goal");
            tooltip.add("");
            tooltip.add(goal.get("lore").getAsString());
            tooltip.add("");
            tooltip.add(EnumChatFormatting.GRAY + "Reward");
            tooltip.add(EnumChatFormatting.GOLD + "1 Bingo Point");
            if (completed) {
                tooltip.add("");
                tooltip.add(EnumChatFormatting.GREEN + "GOAL REACHED");
            } else {
                tooltip.add("");
                tooltip.add(EnumChatFormatting.RED + "You have not reached this goal!");
            }
        }
        return tooltip;
    }

    private void showMissingDataMessage(int guiLeft, int guiTop) {
        String message = EnumChatFormatting.RED + "No Bingo data for current event!";
        Utils.drawStringCentered(message, (float)guiLeft + 215.5f, (float)(guiTop + 101), true, 0);
    }

    private List<String> jsonArrayToStringList(JsonArray completedGoals) {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement completedGoal : completedGoals) {
            list.add(completedGoal.getAsString());
        }
        return list;
    }

    private List<JsonObject> jsonArrayToJsonObjectList(JsonArray goals) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (JsonElement goal : goals) {
            list.add(goal.getAsJsonObject());
        }
        return list;
    }

    private void loadBingoResources() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastResourceRequest < 120000L && this.bingoGoals != null) {
            return;
        }
        this.lastResourceRequest = currentTime;
        NotEnoughUpdates.INSTANCE.manager.apiUtils.newAnonymousHypixelApiRequest("resources/skyblock/bingo").requestJson().thenAccept(jsonObject -> {
            if (jsonObject.has("success") && jsonObject.get("success").getAsBoolean()) {
                this.bingoGoals = this.jsonArrayToJsonObjectList(jsonObject.get("goals").getAsJsonArray());
                this.currentEventId = jsonObject.get("id").getAsInt();
            }
        });
    }
}

