/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.commands.help.SettingsCommand;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C12PacketUpdateSign;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class SearchOverlayScreen
extends GuiEditSign {
    static final ResourceLocation SEARCH_OVERLAY_TEXTURE = new ResourceLocation("notenoughupdates:auc_search/ah_search_overlay.png");
    static final ResourceLocation SEARCH_OVERLAY_TEXTURE_TAB_COMPLETED = new ResourceLocation("notenoughupdates:auc_search/ah_search_overlay_tab_completed.png");
    static final ResourceLocation STAR = new ResourceLocation("notenoughupdates:auc_search/star.png");
    static final ResourceLocation MASTER_STAR = new ResourceLocation("notenoughupdates:auc_search/master_star.png");
    static final ResourceLocation STAR_BOARD = new ResourceLocation("notenoughupdates:auc_search/star_board.png");
    static final GuiElementTextField textField = new GuiElementTextField("", 200, 20, 0);
    static boolean searchFieldClicked = false;
    static String searchString = "";
    static String searchStringExtra = "";
    static final Splitter SPACE_SPLITTER = Splitter.on((String)" ").omitEmptyStrings().trimResults();
    static boolean tabCompleted = false;
    static int tabCompletionIndex = -1;
    TileEntitySign tileSign;
    private static final Pattern ENCHANTED_BOOK_PATTERN = Pattern.compile("(.*)( [IVX]+)");
    static int selectedStars = 0;
    static boolean atLeast = true;
    static boolean onlyLevel100 = false;
    final int AUTOCOMPLETE_HEIGHT = 118;
    GuiType guiType;
    static final Set<String> autocompletedItems = new LinkedHashSet<String>();
    static final ExecutorService searchES = Executors.newSingleThreadExecutor();
    static final AtomicInteger searchId = new AtomicInteger(0);

    public SearchOverlayScreen(TileEntitySign tileEntitySign) {
        super(tileEntitySign);
    }

    static String getItemIdAtIndex(int i) {
        if (!autocompletedItems.isEmpty()) {
            if (i > autocompletedItems.size() - 1 || i < 0 || i > 4) {
                return "";
            }
            String searchString = autocompletedItems.toArray()[i].toString();
            JsonObject repoObject = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(searchString);
            if (repoObject != null) {
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(repoObject);
                return Utils.cleanColour(stack.func_82833_r().replaceAll("\\[.+]", ""));
            }
        }
        return null;
    }

    static boolean updateTabCompletedSearch(int key) {
        if (key == 208 || key == 15) {
            String id = SearchOverlayScreen.getItemIdAtIndex(tabCompletionIndex + 1);
            if (id == null) {
                textField.setFocus(true);
                textField.setText(searchString);
                tabCompleted = false;
                tabCompletionIndex = -1;
                return true;
            }
            if (id.equals("")) {
                tabCompletionIndex = 0;
                return true;
            }
            searchString = id;
            ++tabCompletionIndex;
            return true;
        }
        if (key == 200) {
            String id = SearchOverlayScreen.getItemIdAtIndex(tabCompletionIndex - 1);
            if (id == null) {
                textField.setFocus(true);
                textField.setText(searchString);
                tabCompleted = false;
                tabCompletionIndex = -1;
                return true;
            }
            if (id.equals("")) {
                tabCompletionIndex = autocompletedItems.size() > 4 ? 4 : autocompletedItems.size() - 1;
                tabCompletionIndex = autocompletedItems.size() - 1;
                return true;
            }
            searchString = id;
            --tabCompletionIndex;
            return true;
        }
        return false;
    }

    public void func_73866_w_() {
    }

    public void func_146281_b() {
        if (this.tileSign == null) {
            return;
        }
        if (this.tileSign.field_145915_a[0].func_150260_c().isEmpty()) {
            return;
        }
        NetHandlerPlayClient netHandlerPlayClient = this.field_146297_k.func_147114_u();
        if (netHandlerPlayClient != null) {
            netHandlerPlayClient.func_147297_a((Packet)new C12PacketUpdateSign(this.tileSign.func_174877_v(), this.tileSign.field_145915_a));
        }
        this.tileSign.func_145913_a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(TileEntitySign tes) {
        if (tabCompleted) {
            tabCompletionIndex = -1;
            tabCompleted = false;
        }
        if (this.keepPreviousSearch()) {
            this.search();
        } else {
            Set<String> set = autocompletedItems;
            synchronized (set) {
                autocompletedItems.clear();
            }
        }
        StringBuilder stringBuilder = new StringBuilder(searchString.trim());
        if (!searchStringExtra.isEmpty()) {
            stringBuilder.append(searchStringExtra);
        }
        if (this.currentGuiType() == GuiType.AUCTION_HOUSE && onlyLevel100) {
            stringBuilder.insert(0, "[Lvl 100] ");
        }
        String search = stringBuilder.toString();
        if (!searchString.trim().isEmpty()) {
            ArrayList<String> previousSearches = this.previousSearches();
            previousSearches.remove(searchString);
            previousSearches.remove(searchString);
            previousSearches.add(0, searchString);
            while (previousSearches.size() > this.searchHistorySize()) {
                previousSearches.remove(previousSearches.size() - 1);
            }
        }
        if (tes != null) {
            if (search.length() <= 15) {
                tes.field_145915_a[0] = new ChatComponentText(search.substring(0, Math.min(search.length(), 15)));
            } else {
                ListIterator words = SPACE_SPLITTER.splitToList((CharSequence)search).listIterator();
                StringBuilder line0 = new StringBuilder();
                while (words.hasNext()) {
                    String word = (String)words.next();
                    if (line0.length() + word.length() > 15) {
                        words.previous();
                        break;
                    }
                    line0.append(word).append(' ');
                }
                StringBuilder line1 = new StringBuilder();
                while (words.hasNext()) {
                    String word = (String)words.next();
                    if (line1.length() + word.length() > 15) break;
                    line1.append(word).append(' ');
                }
                tes.field_145915_a[0] = new ChatComponentText(line0.toString().trim());
                tes.field_145915_a[1] = new ChatComponentText(line1.toString().trim());
            }
        } else if (!search.isEmpty()) {
            if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
                NotEnoughUpdates.INSTANCE.sendChatMessage("/ahs " + search);
            } else if (this.currentGuiType() == GuiType.BAZAAR) {
                NotEnoughUpdates.INSTANCE.sendChatMessage("/bz " + search);
            } else if (this.currentGuiType() == GuiType.RECIPE) {
                NotEnoughUpdates.INSTANCE.sendChatMessage("/recipe " + search);
            }
        }
        if (!this.keepPreviousSearch()) {
            searchString = "";
        }
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void search() {
        int thisSearchId = searchId.incrementAndGet();
        searchES.submit(() -> {
            if (thisSearchId != searchId.get()) {
                return;
            }
            ArrayList<String> title = new ArrayList<String>(NotEnoughUpdates.INSTANCE.manager.search("title:" + searchString.trim()));
            if (thisSearchId != searchId.get()) {
                return;
            }
            if (!searchString.trim().contains(" ")) {
                StringBuilder sb = new StringBuilder();
                for (char c : searchString.toCharArray()) {
                    sb.append(c).append(" ");
                }
                title.addAll(NotEnoughUpdates.INSTANCE.manager.search("title:" + sb.toString().trim()));
            }
            if (thisSearchId != searchId.get()) {
                return;
            }
            ArrayList<String> desc = new ArrayList<String>(NotEnoughUpdates.INSTANCE.manager.search("desc:" + searchString.trim()));
            desc.removeAll(title);
            if (thisSearchId != searchId.get()) {
                return;
            }
            if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
                Set<String> set = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBinKeySet();
                set.addAll(NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfoKeySet());
                if (!set.isEmpty()) {
                    title.retainAll(set);
                    desc.retainAll(set);
                    title.sort(this.getSearchComparator());
                    desc.sort(this.getSearchComparator());
                } else {
                    Set<String> bazaarItems = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarKeySet();
                    title.removeAll(bazaarItems);
                    desc.removeAll(bazaarItems);
                }
            } else if (this.currentGuiType() == GuiType.BAZAAR) {
                Set<String> set = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarKeySet();
                title.retainAll(set);
                desc.retainAll(set);
                title.sort(this.getSearchComparator());
                desc.sort(this.getSearchComparator());
            } else if (this.currentGuiType() == GuiType.RECIPE) {
                HashMap<String, Set<NeuRecipe>> hashMap = NotEnoughUpdates.INSTANCE.manager.getAllRecipes();
                ArrayList<String> keys = new ArrayList<String>();
                for (Map.Entry<String, Set<NeuRecipe>> entry : hashMap.entrySet()) {
                    for (NeuRecipe recipe : entry.getValue()) {
                        if (!(recipe instanceof CraftingRecipe) || !recipe.isAvailable()) continue;
                        keys.add(entry.getKey());
                    }
                }
                title.retainAll(keys);
                desc.retainAll(keys);
            }
            if (thisSearchId != searchId.get()) {
                return;
            }
            Set<String> set = autocompletedItems;
            synchronized (set) {
                autocompletedItems.clear();
                autocompletedItems.addAll(title);
                autocompletedItems.addAll(desc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int h = this.showPastSearches() ? 219 : 145;
        int topY = height / 4;
        if (scaledResolution.func_78325_e() >= 4) {
            topY = height / 2 - h / 2 + 5;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(width / 2 - 100, topY - 1, 203.0f, 145.0f, 0.0f, 0.39648438f, 0.0f, 0.56640625f, 9728);
        if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(STAR_BOARD);
            Utils.drawTexturedRect(width / 2 + 105, topY + 27, 105.0f, 13.0f, 9728);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(STAR);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int stars = atLeast && selectedStars > 0 ? 10 : selectedStars;
            for (int i = 0; i < stars; ++i) {
                if (i >= 5) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(MASTER_STAR);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (i >= selectedStars) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                }
                Utils.drawTexturedRect(width / 2 + 108 + 10 * i, topY + 29, 9.0f, 10.0f, 9728);
            }
            if (selectedStars < 6) {
                Gui.func_73734_a((int)(width / 2 + 106), (int)(topY + 42), (int)(width / 2 + 115), (int)(topY + 51), (int)-1);
                Gui.func_73734_a((int)(width / 2 + 107), (int)(topY + 43), (int)(width / 2 + 114), (int)(topY + 50), (int)-16777216);
                Minecraft.func_71410_x().field_71466_p.func_78276_b("At Least?", width / 2 + 117, topY + 43, 0xFFFFFF);
                if (atLeast) {
                    Gui.func_73734_a((int)(width / 2 + 108), (int)(topY + 44), (int)(width / 2 + 113), (int)(topY + 49), (int)-1);
                }
            }
            Gui.func_73734_a((int)(width / 2 + 106), (int)(topY + 53), (int)(width / 2 + 115), (int)(topY + 62), (int)-1);
            Gui.func_73734_a((int)(width / 2 + 107), (int)(topY + 54), (int)(width / 2 + 114), (int)(topY + 61), (int)-16777216);
            if (onlyLevel100) {
                Gui.func_73734_a((int)(width / 2 + 108), (int)(topY + 55), (int)(width / 2 + 113), (int)(topY + 60), (int)-1);
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b("Level 100 pets only?", width / 2 + 117, topY + 54, 0xFFFFFF);
        }
        Minecraft.func_71410_x().field_71466_p.func_175065_a("Enter Query:", (float)(width / 2 - 100), (float)(topY - 10), 0xDDDDDD, true);
        textField.setFocus(true);
        textField.setText(searchString);
        textField.setSize(149, 20);
        textField.setCustomBorderColour(0xFFFFFF);
        textField.render(width / 2 - 100 + 1, topY + 1);
        if (textField.getText().trim().isEmpty()) {
            autocompletedItems.clear();
        }
        List tooltipToDisplay = null;
        int num = 0;
        Set<String> set = autocompletedItems;
        synchronized (set) {
            String[] autoCompletedItemsArray = autocompletedItems.toArray(new String[0]);
            for (int i = 0; i < autoCompletedItemsArray.length; ++i) {
                String str = autoCompletedItemsArray[i];
                JsonObject obj = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(str);
                if (obj == null) continue;
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(obj, false, true);
                if (i == tabCompletionIndex) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE_TAB_COMPLETED);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Utils.drawTexturedRect(width / 2 - 96 + 1, topY + 30 + num * 22 + 1, 193.0f, 21.0f, 0.0f, 0.37695312f, 0.0f, 0.08203125f, 9728);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Utils.drawTexturedRect(width / 2 - 96 + 1, topY + 30 + num * 22 + 1, 193.0f, 21.0f, 0.41796875f, 0.7949219f, 0.0f, 0.08203125f, 9728);
                }
                String itemName = Utils.trimIgnoreColour(stack.func_82833_r().replaceAll("\\[.+]", ""));
                if (itemName.contains("Enchanted Book") && str.contains(";")) {
                    String[] lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p());
                    itemName = lore[0].trim();
                }
                Minecraft.func_71410_x().field_71466_p.func_175065_a(Minecraft.func_71410_x().field_71466_p.func_78269_a(itemName, 165), (float)(width / 2 - 74), (float)(topY + 35 + num * 22 + 1), 0xDDDDDD, true);
                GlStateManager.func_179126_j();
                Utils.drawItemStack(stack, width / 2 - 94 + 2, topY + 32 + num * 22 + 1);
                if (mouseX > width / 2 - 96 && mouseX < width / 2 + 96 && mouseY > topY + 30 + num * 22 && mouseY < topY + 30 + num * 22 + 20) {
                    tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                }
                if (++num >= 5) break;
            }
        }
        if (this.showPastSearches()) {
            Minecraft.func_71410_x().field_71466_p.func_175065_a("Past Searches:", (float)(width / 2 - 100), (float)(topY + 25 + 118 + 5), 0xDDDDDD, true);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE);
            Utils.drawTexturedRect(width / 2 - 100, topY - 1 + 160, 203.0f, 4.0f, 0.0f, 0.39648438f, 0.625f, 0.63671875f, 9728);
            for (int i = 0; i < this.searchHistorySize(); ++i) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE);
                Utils.drawTexturedRect(width / 2 - 100, topY - 1 + 160 + 4 + i * 10, 203.0f, 10.0f, 0.0f, 0.39648438f, 0.640625f, 0.6796875f, 9728);
                if (i >= this.previousSearches().size()) continue;
                String s = this.previousSearches().get(i);
                Minecraft.func_71410_x().field_71466_p.func_175065_a(s, (float)(width / 2 - 95 + 1), (float)(topY + 45 + 118 + i * 10 + 2), 0xDDDDDD, true);
            }
            int size = this.searchHistorySize();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_OVERLAY_TEXTURE);
            Utils.drawTexturedRect(width / 2 - 100, topY - 1 + 160 + 4 + size * 10, 203.0f, 4.0f, 0.0f, 0.39648438f, 0.83984375f, 0.85546875f, 9728);
            if (tooltipToDisplay != null) {
                Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        boolean ignoreKey = false;
        if (keyCode == 1) {
            searchStringExtra = "";
            if (this.escFullClose()) {
                Minecraft.func_71410_x().func_147108_a(null);
            } else {
                this.close(this.tileSign);
            }
            return;
        }
        if (keyCode == 28) {
            searchStringExtra = "";
            this.close(this.tileSign);
            return;
        }
        if (keyCode == 15 && !tabCompleted) {
            tabCompleted = true;
            ignoreKey = true;
            String id = SearchOverlayScreen.getItemIdAtIndex(0);
            if (id == null) {
                tabCompleted = false;
                textField.setFocus(true);
                textField.setText(searchString);
            } else {
                tabCompletionIndex = 0;
                searchString = id;
            }
        }
        if (Keyboard.getEventKeyState()) {
            if (tabCompleted) {
                if (!ignoreKey) {
                    boolean success = SearchOverlayScreen.updateTabCompletedSearch(keyCode);
                    if (success) {
                        return;
                    }
                    textField.setFocus(true);
                    textField.setText(searchString);
                    tabCompleted = false;
                    tabCompletionIndex = -1;
                } else {
                    return;
                }
            }
            textField.setFocus(true);
            textField.setText(searchString);
            textField.keyTyped(Keyboard.getEventCharacter(), keyCode);
            searchString = textField.getText();
            this.search();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146274_d() throws IOException {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        int h = this.showPastSearches() ? 219 : 145;
        int topY = height / 4;
        if (scaledResolution.func_78325_e() >= 4) {
            topY = height / 2 - h / 2 + 5;
        }
        if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
            if (Mouse.getEventButtonState() && mouseX > width / 2 + 105 && mouseX < width / 2 + 105 + 105 && mouseY > topY + 27 && mouseY < topY + 40) {
                int starClicked = 10;
                for (int i = 1; i <= 10; ++i) {
                    if (mouseX >= width / 2 + 108 + 10 * i) continue;
                    starClicked = i;
                    break;
                }
                selectedStars = selectedStars == starClicked ? 0 : starClicked;
                return;
            }
            if (Mouse.getEventButtonState() && mouseX >= width / 2 + 106 && mouseX <= width / 2 + 116 && mouseY >= topY + 42 && mouseY <= topY + 50) {
                atLeast = !atLeast;
                return;
            }
            if (Mouse.getEventButtonState() && mouseX >= width / 2 + 106 && mouseX <= width / 2 + 116 && mouseY >= topY + 53 && mouseY <= topY + 62) {
                onlyLevel100 = !onlyLevel100;
                return;
            }
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() == -1 && searchFieldClicked) {
            textField.mouseClickMove(mouseX - 2, topY + 10, 0, 0L);
        }
        if (Mouse.getEventButton() != -1) {
            searchFieldClicked = false;
        }
        if (Mouse.getEventButtonState()) {
            if (mouseY > topY && mouseY < topY + 20) {
                if (mouseX > width / 2 - 100) {
                    if (mouseX < width / 2 + 49) {
                        searchFieldClicked = true;
                        textField.mouseClicked(mouseX - 2, mouseY, Mouse.getEventButton());
                        if (Mouse.getEventButton() == 1) {
                            searchString = "";
                            Set<String> starClicked = autocompletedItems;
                            synchronized (starClicked) {
                                autocompletedItems.clear();
                            }
                        }
                    } else if (mouseX < width / 2 + 75) {
                        searchStringExtra = "";
                        this.close(this.tileSign);
                    } else if (mouseX < width / 2 + 100) {
                        searchString = "";
                        searchStringExtra = "";
                        this.close(this.tileSign);
                        if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
                            NotEnoughUpdates.INSTANCE.openGui = SettingsCommand.INSTANCE.createConfigScreen("AH Tweaks");
                        } else if (this.currentGuiType() == GuiType.BAZAAR) {
                            NotEnoughUpdates.INSTANCE.openGui = SettingsCommand.INSTANCE.createConfigScreen("Bazaar Tweaks");
                        } else if (this.currentGuiType() == GuiType.RECIPE) {
                            NotEnoughUpdates.INSTANCE.openGui = SettingsCommand.INSTANCE.createConfigScreen("Recipe Tweaks");
                        }
                    }
                }
            } else if (Mouse.getEventButton() == 0) {
                int num = 0;
                Set<String> i = autocompletedItems;
                synchronized (i) {
                    for (String str : autocompletedItems) {
                        JsonObject obj = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(str);
                        if (obj == null) continue;
                        ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(obj);
                        if (mouseX >= width / 2 - 96 && mouseX <= width / 2 + 96 && mouseY >= topY + 30 + num * 22 && mouseY <= topY + 30 + num * 22 + 20) {
                            JsonObject essenceCosts;
                            String[] lore;
                            searchString = Utils.cleanColour(stack.func_82833_r().replaceAll("\\[.+]", "")).trim();
                            if (searchString.contains("Enchanted Book") && str.contains(";") && (lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) != null) {
                                if (this.currentGuiType() == GuiType.AUCTION_HOUSE) {
                                    Object[] split = Utils.cleanColour(lore[0]).trim().split(" ");
                                    split[split.length - 1] = "";
                                    searchString = StringUtils.join((Object[])split, (String)" ").trim();
                                } else if (this.currentGuiType() == GuiType.BAZAAR) {
                                    searchString = Utils.cleanColour(lore[0]);
                                } else if (this.currentGuiType() == GuiType.RECIPE) {
                                    String bookName = Utils.cleanColour(lore[0]);
                                    Matcher matcher = ENCHANTED_BOOK_PATTERN.matcher(bookName);
                                    searchString = matcher.matches() ? matcher.group(1) : bookName;
                                }
                            }
                            searchStringExtra = " ";
                            if (this.currentGuiType() == GuiType.AUCTION_HOUSE && (essenceCosts = Constants.ESSENCECOSTS) != null && essenceCosts.has(str) && selectedStars > 0) {
                                for (int i2 = 0; i2 < selectedStars && i2 <= 4; ++i2) {
                                    searchStringExtra = searchStringExtra + "\u272a";
                                }
                                switch (selectedStars) {
                                    case 6: {
                                        searchStringExtra = searchStringExtra + "\u278a";
                                        break;
                                    }
                                    case 7: {
                                        searchStringExtra = searchStringExtra + "\u278b";
                                        break;
                                    }
                                    case 8: {
                                        searchStringExtra = searchStringExtra + "\u278c";
                                        break;
                                    }
                                    case 9: {
                                        searchStringExtra = searchStringExtra + "\u278d";
                                        break;
                                    }
                                    case 10: {
                                        searchStringExtra = searchStringExtra + "\u278e";
                                    }
                                }
                                if (selectedStars < 6 && !atLeast) {
                                    searchStringExtra = searchStringExtra + " ";
                                    searchStringExtra = searchStringExtra + stack.func_77973_b().func_77653_i(stack).substring(0, 1);
                                }
                            }
                            this.close(this.tileSign);
                            return;
                        }
                        if (++num < 5) continue;
                        break;
                    }
                }
                if (this.showPastSearches()) {
                    for (int i3 = 0; i3 < this.searchHistorySize() && i3 < this.previousSearches().size(); ++i3) {
                        String s = this.previousSearches().get(i3);
                        if (mouseX < width / 2 - 95 || mouseX > width / 2 + 95 || mouseY < topY + 45 + 118 + i3 * 10 || mouseY > topY + 45 + 118 + i3 * 10 + 10) continue;
                        searchString = s;
                        searchStringExtra = "";
                        this.close(this.tileSign);
                        return;
                    }
                }
            }
        }
    }

    public Comparator<String> getSearchComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return 0;
            }
        };
    }

    public boolean enableSearchOverlay() {
        return false;
    }

    public ArrayList<String> previousSearches() {
        return new ArrayList<String>();
    }

    public int searchHistorySize() {
        return 0;
    }

    public boolean showPastSearches() {
        return false;
    }

    public boolean escFullClose() {
        return false;
    }

    public boolean keepPreviousSearch() {
        return false;
    }

    public boolean disableClientSideGUI() {
        return Loader.isModLoaded((String)"skyblockcatia") || NotEnoughUpdates.INSTANCE.config.hidden.disableClientSideSearch;
    }

    public GuiType currentGuiType() {
        return GuiType.UNKNOWN;
    }

    public static enum GuiType {
        AUCTION_HOUSE,
        BAZAAR,
        RECIPE,
        UNKNOWN;

    }
}

