/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.options;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.GuiPositionEditor;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Config;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Social;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.Category;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiScreenElementWrapper;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MoulConfigEditor;
import io.github.moulberry.notenoughupdates.dungeons.GuiDungeonMapEditor;
import io.github.moulberry.notenoughupdates.miscfeatures.FairySouls;
import io.github.moulberry.notenoughupdates.miscfeatures.HotmDesires;
import io.github.moulberry.notenoughupdates.miscfeatures.IQTest;
import io.github.moulberry.notenoughupdates.miscgui.GuiEnchantColour;
import io.github.moulberry.notenoughupdates.miscgui.GuiInvButtonEditor;
import io.github.moulberry.notenoughupdates.miscgui.NEUOverlayPlacements;
import io.github.moulberry.notenoughupdates.miscgui.customtodos.CustomTodo;
import io.github.moulberry.notenoughupdates.options.customtypes.NEUDebugFlag;
import io.github.moulberry.notenoughupdates.options.separatesections.AHGraph;
import io.github.moulberry.notenoughupdates.options.separatesections.AHTweaks;
import io.github.moulberry.notenoughupdates.options.separatesections.About;
import io.github.moulberry.notenoughupdates.options.separatesections.AccessoryBag;
import io.github.moulberry.notenoughupdates.options.separatesections.ApiData;
import io.github.moulberry.notenoughupdates.options.separatesections.BazaarTweaks;
import io.github.moulberry.notenoughupdates.options.separatesections.Calendar;
import io.github.moulberry.notenoughupdates.options.separatesections.CustomArmour;
import io.github.moulberry.notenoughupdates.options.separatesections.DungeonMapConfig;
import io.github.moulberry.notenoughupdates.options.separatesections.Dungeons;
import io.github.moulberry.notenoughupdates.options.separatesections.Enchanting;
import io.github.moulberry.notenoughupdates.options.separatesections.Fishing;
import io.github.moulberry.notenoughupdates.options.separatesections.Garden;
import io.github.moulberry.notenoughupdates.options.separatesections.ImprovedSBMenu;
import io.github.moulberry.notenoughupdates.options.separatesections.InventoryButtons;
import io.github.moulberry.notenoughupdates.options.separatesections.ItemOverlays;
import io.github.moulberry.notenoughupdates.options.separatesections.Itemlist;
import io.github.moulberry.notenoughupdates.options.separatesections.LocationEdit;
import io.github.moulberry.notenoughupdates.options.separatesections.Mining;
import io.github.moulberry.notenoughupdates.options.separatesections.MinionHelper;
import io.github.moulberry.notenoughupdates.options.separatesections.Misc;
import io.github.moulberry.notenoughupdates.options.separatesections.MiscOverlays;
import io.github.moulberry.notenoughupdates.options.separatesections.Museum;
import io.github.moulberry.notenoughupdates.options.separatesections.Notifications;
import io.github.moulberry.notenoughupdates.options.separatesections.PetOverlay;
import io.github.moulberry.notenoughupdates.options.separatesections.ProfileViewer;
import io.github.moulberry.notenoughupdates.options.separatesections.RecipeTweaks;
import io.github.moulberry.notenoughupdates.options.separatesections.SkillOverlays;
import io.github.moulberry.notenoughupdates.options.separatesections.SlayerOverlay;
import io.github.moulberry.notenoughupdates.options.separatesections.SlotLocking;
import io.github.moulberry.notenoughupdates.options.separatesections.StorageGUI;
import io.github.moulberry.notenoughupdates.options.separatesections.Toolbar;
import io.github.moulberry.notenoughupdates.options.separatesections.TooltipTweaks;
import io.github.moulberry.notenoughupdates.options.separatesections.TradeMenu;
import io.github.moulberry.notenoughupdates.options.separatesections.WardrobeKeybinds;
import io.github.moulberry.notenoughupdates.options.separatesections.WorldConfig;
import io.github.moulberry.notenoughupdates.overlays.MiningOverlay;
import io.github.moulberry.notenoughupdates.overlays.OverlayManager;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import org.jetbrains.annotations.Nullable;

public class NEUConfig
extends Config {
    @Expose
    @Category(name="About", desc="")
    public About about = new About();
    @Expose
    @Category(name="Misc", desc="Miscellaneous options which don't fit into any other category")
    public Misc misc = new Misc();
    @Expose
    @Category(name="GUI Locations", desc="Edit the GUI locations of everything here")
    public LocationEdit locationedit = new LocationEdit();
    @Expose
    @Category(name="Notifications", desc="Notifications")
    public Notifications notifications = new Notifications();
    @Expose
    @Category(name="Item List", desc="Item List")
    public Itemlist itemlist = new Itemlist();
    @Expose
    @Category(name="Toolbar", desc="Toolbar")
    public Toolbar toolbar = new Toolbar();
    @Expose
    @Category(name="Inventory Buttons", desc="Inventory Buttons")
    public InventoryButtons inventoryButtons = new InventoryButtons();
    @Expose
    @Category(name="Slot Locking", desc="Slot Locking")
    public SlotLocking slotLocking = new SlotLocking();
    @Expose
    @Category(name="Tooltip Tweaks", desc="Tooltip Tweaks")
    public TooltipTweaks tooltipTweaks = new TooltipTweaks();
    @Expose
    @Category(name="Item Overlays", desc="Item Overlays")
    public ItemOverlays itemOverlays = new ItemOverlays();
    @Expose
    @Category(name="Skill Overlays", desc="Skill Overlays")
    public SkillOverlays skillOverlays = new SkillOverlays();
    @Expose
    @Category(name="Todo Overlays", desc="Todo Overlays")
    public MiscOverlays miscOverlays = new MiscOverlays();
    @Expose
    @Category(name="Slayer Overlay", desc="Slayer Overlay")
    public SlayerOverlay slayerOverlay = new SlayerOverlay();
    @Expose
    @Category(name="Storage GUI", desc="Storage GUI")
    public StorageGUI storageGUI = new StorageGUI();
    @Expose
    @Category(name="Dungeons", desc="Dungeons")
    public Dungeons dungeons = new Dungeons();
    @Expose
    @Category(name="Enchanting GUI/Solvers", desc="Enchanting GUI/Solvers")
    public Enchanting enchantingSolvers = new Enchanting();
    @Expose
    @Category(name="Mining", desc="Mining")
    public Mining mining = new Mining();
    @Expose
    @Category(name="Fishing", desc="Fishing")
    public Fishing fishing = new Fishing();
    @Expose
    @Category(name="Garden", desc="Garden")
    public Garden garden = new Garden();
    @Expose
    @Category(name="Improved SB Menus", desc="Improved SB Menus")
    public ImprovedSBMenu improvedSBMenu = new ImprovedSBMenu();
    @Expose
    @Category(name="Equipment Hud", desc="Equipment Hud")
    public CustomArmour customArmour = new CustomArmour();
    @Expose
    @Category(name="Calendar", desc="Calendar")
    public Calendar calendar = new Calendar();
    @Expose
    @Category(name="Trade Menu", desc="Trade Menu")
    public TradeMenu tradeMenu = new TradeMenu();
    @Expose
    @Category(name="Pet Overlay", desc="Pet Overlay")
    public PetOverlay petOverlay = new PetOverlay();
    @Expose
    @Category(name="World Renderer", desc="In World Renderers")
    public WorldConfig world = new WorldConfig();
    @Expose
    @Category(name="AH Tweaks", desc="Tweaks for The Auction House")
    public AHTweaks ahTweaks = new AHTweaks();
    @Expose
    @Category(name="Bazaar Tweaks", desc="Tweaks for the Bazaar")
    public BazaarTweaks bazaarTweaks = new BazaarTweaks();
    @Expose
    @Category(name="Recipe Tweaks", desc="Tweaks for the Recipe Search")
    public RecipeTweaks recipeTweaks = new RecipeTweaks();
    @Expose
    @Category(name="Price Graph", desc="Graph of auction and bazaar prices")
    public AHGraph ahGraph = new AHGraph();
    @Expose
    @Category(name="Wardrobe Keybinds", desc="Keybinds for your wardrobe")
    public WardrobeKeybinds wardrobeKeybinds = new WardrobeKeybinds();
    @Expose
    @Category(name="Accessory Bag Overlay", desc="Accessory Bag Overlay")
    public AccessoryBag accessoryBag = new AccessoryBag();
    @Expose
    @Category(name="Museum", desc="Museum overlays")
    public Museum museum = new Museum();
    @Expose
    @Category(name="Profile Viewer", desc="Profile Viewer")
    public ProfileViewer profileViewer = new ProfileViewer();
    @Expose
    @Category(name="Minion Helper", desc="Minion Helper")
    public MinionHelper minionHelper = new MinionHelper();
    @Expose
    @Category(name="Apis", desc="Api Data")
    public ApiData apiData = new ApiData();
    @Expose
    public LegacyApiKey apiKey = null;
    @Expose
    public Hidden hidden = new Hidden();
    @Expose
    public DungeonMapConfig dungeonMap = new DungeonMapConfig();

    public void editOverlay() {
        LinkedHashMap<TextOverlay, Position> overlayPositions = new LinkedHashMap<TextOverlay, Position>();
        for (TextOverlay overlay : OverlayManager.textOverlays) {
            overlayPositions.put(overlay, overlay.getPosition());
        }
        GuiScreen savedGui = Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPositionEditor(overlayPositions, () -> {}, () -> {
            NotEnoughUpdates.INSTANCE.openGui = savedGui;
        }));
    }

    public static GuiScreen editOverlayForCommand() {
        LinkedHashMap<TextOverlay, Position> overlayPositions = new LinkedHashMap<TextOverlay, Position>();
        for (TextOverlay overlay : OverlayManager.textOverlays) {
            overlayPositions.put(overlay, overlay.getPosition());
        }
        return new GuiPositionEditor(overlayPositions, () -> {}, () -> {});
    }

    @Override
    public void saveNow() {
        NotEnoughUpdates.INSTANCE.saveConfig();
    }

    private Social social(final String name, final String iconName, final String link) {
        return new Social(){

            @Override
            public void onClick() {
                Utils.openUrl(link);
            }

            @Override
            public List<String> getTooltip() {
                return Arrays.asList(name, "\u00a77Open " + link);
            }

            @Override
            public ResourceLocation getIcon() {
                return new ResourceLocation("notenoughupdates:social/" + iconName + ".png");
            }
        };
    }

    @Override
    public List<Social> getSocials() {
        return Arrays.asList(this.social("Twitch", "twitch", "https://twitch.tv/moulberry2"), this.social("Patreon", "patreon", "https://patreon.com/moulberry"), this.social("YouTube", "youtube", "https://www.youtube.com/channel/UCPh-OKmRSS3IQi9p6YppLcw"), this.social("Twitter", "twitter", "https://twitter.com/moulberry/"), this.social("GitHub", "github", "https://github.com/NotEnoughUpdates/NotEnoughUpdates"), this.social("Discord", "discord", "https://discord.gg/moulberry"));
    }

    @Override
    public String getTitle() {
        return "\u00a77NotEnoughUpdates 2.4.0 by \u00a75Moulberry";
    }

    @Override
    public void executeRunnable(int runnableId) {
        String activeConfigCategory = null;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiScreenElementWrapper) {
            GuiScreenElementWrapper wrapper2 = (GuiScreenElementWrapper)Minecraft.func_71410_x().field_71462_r;
            if (wrapper2.element instanceof MoulConfigEditor) {
                activeConfigCategory = ((MoulConfigEditor)wrapper2.element).getSelectedCategory();
            }
        }
        switch (runnableId) {
            case -1: {
                return;
            }
            case 0: {
                GuiScreen savedGui = Minecraft.func_71410_x().field_71462_r;
                NotEnoughUpdates.INSTANCE.openGui = new GuiDungeonMapEditor(() -> {
                    NotEnoughUpdates.INSTANCE.openGui = savedGui;
                });
                return;
            }
            case 1: 
            case 4: {
                this.editOverlay();
                return;
            }
            case 6: {
                NotEnoughUpdates.INSTANCE.openGui = new NEUOverlayPlacements();
                return;
            }
            case 7: {
                NotEnoughUpdates.INSTANCE.openGui = new GuiInvButtonEditor();
                return;
            }
            case 8: {
                NotEnoughUpdates.INSTANCE.openGui = new GuiEnchantColour();
                return;
            }
            case 12: {
                this.executeRunnableCommand("/dn");
                return;
            }
            case 13: {
                this.executeRunnableCommand("/pv");
                return;
            }
            case 15: {
                String command2 = NotEnoughUpdates.INSTANCE.config.misc.fariySoul ? "/neusouls on" : "/neusouls off";
                this.executeRunnableCommand(command2);
                return;
            }
            case 16: {
                this.executeRunnableCommand("/neusouls clear");
                return;
            }
            case 17: {
                this.executeRunnableCommand("/neusouls unclear");
                return;
            }
            case 20: {
                FairySouls.getInstance().setTrackFairySouls(NotEnoughUpdates.INSTANCE.config.misc.trackFairySouls);
                return;
            }
            case 21: {
                NotEnoughUpdates.INSTANCE.overlay.updateSearch();
                return;
            }
            case 22: {
                NotEnoughUpdates.INSTANCE.manager.userFacingRepositoryReload().thenAccept(strings -> NotificationHandler.displayNotification(strings, true, true));
                Minecraft.func_71410_x().func_147108_a(null);
                return;
            }
            case 23: {
                NotEnoughUpdates.INSTANCE.config.apiData.repoUser = "NotEnoughUpdates";
                NotEnoughUpdates.INSTANCE.config.apiData.repoName = "NotEnoughUpdates-REPO";
                NotEnoughUpdates.INSTANCE.config.apiData.repoBranch = "master";
                return;
            }
            case 26: {
                OverlayManager.powderGrindingOverlay.reset();
                return;
            }
            case 27: {
                IQTest.testIQ();
                return;
            }
            case 28: {
                this.executeRunnableCommand("/neuresetslotlocking");
                return;
            }
        }
        System.err.printf("Unknown runnableId = %d in category %s%n", runnableId, activeConfigCategory);
    }

    private void executeRunnableCommand(String command2) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            System.err.println("Command (" + command2 + ") not executed since you are not in a world.");
            return;
        }
        ClientCommandHandler.instance.func_71556_a((ICommandSender)Minecraft.func_71410_x().field_71439_g, command2);
    }

    public static ArrayList<String> createDefaultEnchantColours() {
        return Lists.newArrayList((Object[])new String[]{"[a-zA-Z\\- ]+:>:9:6:0", "[a-zA-Z\\- ]+:>:6:c:0", "[a-zA-Z\\- ]+:>:5:5:0", "Experience:>:3:5:0", "Life Steal:>:3:5:0", "Scavenger:>:3:5:0", "Looting:>:3:5:0"});
    }

    private static ArrayList<String> createDefaultQuickCommands() {
        return new ArrayList<String>(){
            {
                this.add("/warp home:Warp Home:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzljODg4MWU0MjkxNWE5ZDI5YmI2MWExNmZiMjZkMDU5OTEzMjA0ZDI2NWRmNWI0MzliM2Q3OTJhY2Q1NiJ9fX0=");
                this.add("/warp hub:Warp Hub:eyJ0aW1lc3RhbXAiOjE1NTkyMTU0MTY5MDksInByb2ZpbGVJZCI6IjQxZDNhYmMyZDc0OTQwMGM5MDkwZDU0MzRkMDM4MzFiIiwicHJvZmlsZU5hbWUiOiJNZWdha2xvb24iLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Q3Y2M2Njg3NDIzZDA1NzBkNTU2YWM1M2UwNjc2Y2I1NjNiYmRkOTcxN2NkODI2OWJkZWJlZDZmNmQ0ZTdiZjgifX19");
                this.add("/warp dungeon_hub:Dungeon Hub:eyJ0aW1lc3RhbXAiOjE1Nzg0MDk0MTMxNjksInByb2ZpbGVJZCI6IjQxZDNhYmMyZDc0OTQwMGM5MDkwZDU0MzRkMDM4MzFiIiwicHJvZmlsZU5hbWUiOiJNZWdha2xvb24iLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzliNTY4OTViOTY1OTg5NmFkNjQ3ZjU4NTk5MjM4YWY1MzJkNDZkYjljMWIwMzg5YjhiYmViNzA5OTlkYWIzM2QiLCJtZXRhZGF0YSI6eyJtb2RlbCI6InNsaW0ifX19fQ==");
                this.add("/craft:Crafting Table:CRAFTING_TABLE");
                this.add("/storage:Storage:CHEST");
                this.add("/wardrobe:Wardrobe:LEATHER_CHESTPLATE");
                this.add("/pets:Pets:BONE");
                this.add("/bz:Bazaar:GOLD_BARDING");
            }
        };
    }

    @Nullable
    public HiddenProfileSpecific getProfileSpecific() {
        if (SBInfo.getInstance().currentProfile == null) {
            return null;
        }
        return this.hidden.profileSpecific.computeIfAbsent(SBInfo.getInstance().currentProfile, k -> new HiddenProfileSpecific());
    }

    public HiddenLocationSpecific getLocationSpecific() {
        String location = SBInfo.getInstance().getLocation();
        if (location == null || location.isEmpty()) {
            return null;
        }
        return this.getLocationSpecific(location);
    }

    public HiddenLocationSpecific getLocationSpecific(String location) {
        return this.hidden.locationSpecific.computeIfAbsent(location, k -> new HiddenLocationSpecific());
    }

    public static List<InventoryButton> createDefaultInventoryButtons() {
        return new ArrayList<InventoryButton>(){
            {
                int y;
                int i;
                this.add(new InventoryButton(87, 63, null, true, false, false, 0, ""));
                this.add(new InventoryButton(108, 63, null, true, false, false, 0, ""));
                this.add(new InventoryButton(129, 63, null, true, false, false, 0, ""));
                this.add(new InventoryButton(150, 63, null, true, false, false, 0, ""));
                this.add(new InventoryButton(87, 5, null, true, false, false, 0, ""));
                this.add(new InventoryButton(108, 5, null, true, false, false, 0, ""));
                this.add(new InventoryButton(129, 5, null, true, false, false, 0, ""));
                this.add(new InventoryButton(150, 5, null, true, false, false, 0, ""));
                this.add(new InventoryButton(87, 25, null, true, false, false, 0, ""));
                this.add(new InventoryButton(105, 25, null, true, false, false, 0, ""));
                this.add(new InventoryButton(87, 43, null, true, false, false, 0, ""));
                this.add(new InventoryButton(105, 43, null, true, false, false, 0, ""));
                this.add(new InventoryButton(143, 35, null, true, false, false, 0, ""));
                this.add(new InventoryButton(60, 8, null, true, false, false, 0, ""));
                this.add(new InventoryButton(60, 60, null, true, false, false, 0, ""));
                this.add(new InventoryButton(26, 8, null, true, false, false, 0, ""));
                this.add(new InventoryButton(26, 60, null, true, false, false, 0, ""));
                for (i = 0; i < 8; ++i) {
                    y = 2 + 20 * i;
                    if (y < 80) {
                        this.add(new InventoryButton(2, 2 + 20 * i, null, false, true, false, 0, ""));
                        continue;
                    }
                    this.add(new InventoryButton(2, 2 + 20 * i - 166, null, false, true, true, 0, ""));
                }
                for (i = 0; i < 8; ++i) {
                    this.add(new InventoryButton(4 + 21 * i, -19, null, false, false, false, 0, ""));
                }
                for (i = 0; i < 8; ++i) {
                    y = 2 + 20 * i;
                    if (y < 80) {
                        this.add(new InventoryButton(-19, 2 + 20 * i, null, false, false, false, 0, ""));
                        continue;
                    }
                    this.add(new InventoryButton(-19, 2 + 20 * i - 166, null, false, false, true, 0, ""));
                }
                for (i = 0; i < 8; ++i) {
                    this.add(new InventoryButton(4 + 21 * i, 2, null, false, false, true, 0, ""));
                }
            }
        };
    }

    static /* synthetic */ ArrayList access$000() {
        return NEUConfig.createDefaultQuickCommands();
    }

    public static class InventoryButton {
        @Expose
        public int x;
        @Expose
        public int y;
        @Expose
        public boolean playerInvOnly;
        @Expose
        public boolean anchorRight;
        @Expose
        public boolean anchorBottom;
        @Expose
        public int backgroundIndex;
        @Expose
        public String command;
        @Expose
        public String icon;

        public boolean isActive() {
            return this.command.trim().length() > 0;
        }

        public InventoryButton(int x, int y, String icon, boolean playerInvOnly, boolean anchorRight, boolean anchorBottom, int backgroundIndex, String command2) {
            this.x = x;
            this.y = y;
            this.icon = icon;
            this.playerInvOnly = playerInvOnly;
            this.anchorRight = anchorRight;
            this.anchorBottom = anchorBottom;
            this.backgroundIndex = backgroundIndex;
            this.command = command2;
        }
    }

    public static class HiddenLocationSpecific {
        @Expose
        public Map<String, Integer> commissionMaxes = new HashMap<String, Integer>();
    }

    public static class HiddenProfileSpecific {
        @Expose
        public long godPotionDuration = 0L;
        @Expose
        public long puzzlerCompleted = 0L;
        @Expose
        public long firstCakeAte = 0L;
        @Expose
        public long fetchurCompleted = 0L;
        @Expose
        public long commissionsCompleted = 0L;
        @Expose
        public long lastFreeRiftInfusionApplied = 0L;
        @Expose
        public long experimentsCompleted = 0L;
        @Expose
        public long cookieBuffRemaining = 0L;
        @Expose
        public List<MiningOverlay.ForgeItem> forgeItems = new ArrayList<MiningOverlay.ForgeItem>();
        @Expose
        public Map<String, HotmDesires.Desire> hotmDesires = new HashMap<String, HotmDesires.Desire>();
        @Expose
        public int commissionMilestone = 0;
        @Expose
        public HashMap<String, Boolean> automatonParts = new HashMap<String, Boolean>(){
            {
                this.put("Electron Transmitter", false);
                this.put("FTX 3070", false);
                this.put("Robotron Reflector", false);
                this.put("Superlite Motor", false);
                this.put("Control Switch", false);
                this.put("Synthetic Heart", false);
            }
        };
        @Expose
        public HashMap<String, Boolean> divanMinesParts = new HashMap<String, Boolean>(){
            {
                this.put("Scavenged Lapis Sword", false);
                this.put("Scavenged Golden Hammer", false);
                this.put("Scavenged Diamond Axe", false);
                this.put("Scavenged Emerald Hammer", false);
            }
        };
        @Expose
        public HashMap<String, Integer> crystals = new HashMap<String, Integer>(){
            {
                this.put("Jade", 0);
                this.put("Amber", 0);
                this.put("Amethyst", 0);
                this.put("Sapphire", 0);
                this.put("Topaz", 0);
            }
        };
        @Expose
        public long dailyGemstonePowderCompleted = 0L;
        @Expose
        public long dailyMithrilPowerCompleted = 0L;
        @Expose
        public Set<String> nonUnlockedWarpScrolls = new HashSet<String>();
        @Expose
        public long dailyHeavyPearlCompleted = 0L;
        @Expose
        public long questBoardCompleted = 0L;
        @Expose
        public long dailyShopLimitCompleted = 0L;
        @Expose
        public HashMap<Integer, JsonObject> savedEquipment = new HashMap();
        @Expose
        public int magicalPower = 0;
        @Expose
        public int chestCount = 0;
        @Expose
        public int openedChestCount = 0;
        @Expose
        public int mithrilPowderFound = 0;
        @Expose
        public int gemstonePowderFound = 0;
        @Expose
        public List<String> abiphoneFavouriteContacts = new ArrayList<String>();
        @Expose
        public boolean abiphoneShowOnlyFavourites = false;
        @Expose
        public Map<String, Integer> hotmTree = new HashMap<String, Integer>();
        @Expose
        public boolean hasConsumedRiftPrism = false;
        @Expose
        public int abiphoneMagicPower = 0;
    }

    public static class Hidden {
        @Expose
        public List<CustomTodo> customTodos = new ArrayList<CustomTodo>();
        @Expose
        public HashMap<String, HiddenProfileSpecific> profileSpecific = new HashMap();
        @Expose
        public HashMap<String, HiddenLocationSpecific> locationSpecific = new HashMap();
        @Expose
        public List<InventoryButton> inventoryButtons = NEUConfig.createDefaultInventoryButtons();
        @Expose
        public EnumSet<NEUDebugFlag> debugFlags = EnumSet.noneOf(NEUDebugFlag.class);
        @Expose
        public boolean cacheRenderedItempane = true;
        @Expose
        public String overlaySearchBar = "";
        @Expose
        public String overlayQuickCommand = "";
        @Expose
        public boolean dev = false;
        @Expose
        public boolean loadedModBefore = false;
        @Expose
        public String selectedCape = null;
        @Expose
        public int compareMode = 0;
        @Expose
        public String customUserAgent = null;
        @Expose
        public int sortMode = 0;
        @Expose
        public ArrayList<Boolean> compareAscending = Lists.newArrayList((Object[])new Boolean[]{true, true, true});
        @Expose
        public ArrayList<String> favourites = new ArrayList();
        @Expose
        public ArrayList<String> previousAuctionSearches = new ArrayList();
        @Expose
        public ArrayList<String> previousBazaarSearches = new ArrayList();
        @Expose
        public ArrayList<String> previousProfileSearches = new ArrayList();
        @Expose
        public ArrayList<String> previousRecipeSearches = new ArrayList();
        @Expose
        public ArrayList<String> eventFavourites = new ArrayList();
        @Expose
        public ArrayList<String> quickCommands = NEUConfig.access$000();
        @Expose
        public ArrayList<String> enchantColours = NEUConfig.createDefaultEnchantColours();
        @Expose
        public Set<String> dynamicLightItems = new HashSet<String>();
        @Expose
        public boolean firstTimeSearchFocus = true;
        @Expose
        public boolean disableBrokenCapes = false;
        @Expose
        public boolean npcRetextureOnSelf = false;
        @Expose
        public boolean hasOpenedWaypointMenu = false;
        @Expose
        public String externalEditor = null;
        @Expose
        public boolean disableClientSideSearch = false;
    }

    public static class LegacyApiKey {
        @Expose
        public String apiKey = null;
    }
}

