/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.render;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.ArrowPagesUtils;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.miscgui.TrophyRewardOverlay;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.MinionHelperOverlayHover;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.renderables.OverviewLine;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.renderables.OverviewText;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.NpcSource;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class MinionHelperOverlay {
    private final ResourceLocation minionOverlayImage = new ResourceLocation("notenoughupdates:minion_overlay.png");
    private final ResourceLocation greenCheckImage = new ResourceLocation("notenoughupdates:dungeon_map/green_check.png");
    private final ResourceLocation whiteCheckImage = new ResourceLocation("notenoughupdates:dungeon_map/white_check.png");
    private final MinionHelperManager manager;
    private final MinionHelperOverlayHover hover;
    private int[] topLeft = new int[]{237, 110};
    private LinkedHashMap<String, OverviewLine> cacheRenderMap = null;
    private int cacheTotalPages = -1;
    private boolean filterEnabled = true;
    private boolean useInstantBuyPrice = true;
    private int maxPerPage = 7;
    private int currentPage = 0;

    public MinionHelperOverlay(MinionHelperManager manager) {
        this.manager = manager;
        this.hover = new MinionHelperOverlayHover(this, manager);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        this.resetCache();
    }

    public void resetCache() {
        this.cacheRenderMap = null;
        this.cacheTotalPages = -1;
    }

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (this.manager.inCraftedMinionsInventory() && NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight(), event.getGuiBaseRect().getTop(), 172, 128), ButtonExclusionZoneEvent.PushDirection.TOWARDS_RIGHT);
        }
    }

    @SubscribeEvent
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!this.manager.inCraftedMinionsInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        if (this.manager.isInvalidApiKey()) {
            LinkedHashMap<String, OverviewLine> map2 = new LinkedHashMap<String, OverviewLine>();
            map2.put("\u00a7cNo data found, try running /pv", new OverviewText(Collections.emptyList(), () -> {}));
            this.render(map2);
            return;
        }
        if (this.manager.notReady()) {
            LinkedHashMap<String, OverviewLine> map3 = new LinkedHashMap<String, OverviewLine>();
            map3.put("\u00a7cLoading...", new OverviewText(Collections.emptyList(), () -> {}));
            this.render(map3);
            return;
        }
        if (this.manager.getApi().isNotifyNoCollectionApi()) {
            NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"", "\u00a7cCollection API is disabled!", "\u00a7cMinion Helper will not filter minions that", "\u00a7cdo not meet the collection requirements!"}), false, true);
            this.manager.getApi().setNotifyNoCollectionApi(false);
        }
        LinkedHashMap<String, OverviewLine> renderMap = this.getRenderMap();
        this.hover.renderHover(renderMap);
        this.render(renderMap);
        this.renderArrows();
    }

    private void renderArrows() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof AccessorGuiContainer) {
            AccessorGuiContainer container = (AccessorGuiContainer)gui;
            int guiLeft = container.getGuiLeft();
            int guiTop = container.getGuiTop();
            int totalPages = this.getTotalPages();
            ArrowPagesUtils.onDraw(guiLeft, guiTop, this.topLeft, this.currentPage, totalPages);
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        int guiTop;
        int guiLeft;
        if (!this.manager.inCraftedMinionsInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        if (this.manager.notReady()) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        OverviewLine overviewLine = this.getObjectOverMouse(this.getRenderMap());
        if (overviewLine != null) {
            overviewLine.onClick();
            event.setCanceled(true);
        }
        int totalPages = this.getTotalPages();
        if (event.gui instanceof AccessorGuiContainer && ArrowPagesUtils.onPageSwitchMouse(guiLeft = ((AccessorGuiContainer)event.gui).getGuiLeft(), guiTop = ((AccessorGuiContainer)event.gui).getGuiTop(), this.topLeft, this.currentPage, totalPages, pageChange -> {
            this.currentPage = pageChange;
            this.resetCache();
        })) {
            event.setCanceled(true);
        }
        this.checkButtonClick();
    }

    private void checkButtonClick() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        int x = guiLeft + xSize + 4 + 149 - 3;
        int y = guiTop + 109 - 3;
        if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
            this.toggleShowAvailable();
        }
        x = guiLeft + xSize + 4 + 149 - 3 - 16 - 3;
        y = guiTop + 109 - 3;
        if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
            this.toggleUseInstantBuyPrice();
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!this.manager.inCraftedMinionsInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        if (this.manager.notReady()) {
            return;
        }
        int totalPages = this.getTotalPages();
        if (ArrowPagesUtils.onPageSwitchKey(this.currentPage, totalPages, pageChange -> {
            this.currentPage = pageChange;
            this.resetCache();
        })) {
            event.setCanceled(true);
        }
    }

    private Map<Minion, Double> getMissing() {
        HashMap<Minion, Double> prices = new HashMap<Minion, Double>();
        for (Minion minion : this.manager.getAllMinions().values()) {
            if (!minion.doesMeetRequirements() && this.filterEnabled || minion.isCrafted()) continue;
            double price = this.manager.getPriceCalculation().calculateUpgradeCosts(minion, true);
            prices.put(minion, price);
        }
        return prices;
    }

    private void render(Map<String, OverviewLine> renderMap) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        minecraft.func_110434_K().func_110577_a(this.minionOverlayImage);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 168.0f, 128.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
        if (this.filterEnabled) {
            minecraft.func_110434_K().func_110577_a(this.greenCheckImage);
        } else {
            minecraft.func_110434_K().func_110577_a(this.whiteCheckImage);
        }
        Utils.drawTexturedRect(guiLeft + xSize + 4 + 149, guiTop + 109, 10.0f, 10.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
        GlStateManager.func_179140_f();
        RenderHelper.func_74520_c();
        ItemStack itemStack = this.useInstantBuyPrice ? ItemUtils.getCoinItemStack(1.0E7) : ItemUtils.getCoinItemStack(100000.0);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStack, guiLeft + xSize + 4 + 149 - 3 - 16 - 3, guiTop + 109 - 3);
        RenderHelper.func_74518_a();
        int x = guiLeft + xSize + 10;
        int i = 0;
        int y = guiTop + 6;
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        for (Map.Entry<String, OverviewLine> entry : renderMap.entrySet()) {
            String line = entry.getKey();
            if (line.contains("\u00a76")) {
                String[] split = line.split("\u00a76");
                line = split[0];
                String price = "\u00a76\u00a7l" + split[1];
                if (price.contains("\u00a78")) {
                    split = price.split("\u00a78");
                    String newPrice = split[0];
                    String stuffBehindPricePart = "\u00a78" + price.substring(newPrice.length() + 2);
                    price = newPrice;
                    int lineLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(line + price);
                    fontRendererObj.func_175065_a(stuffBehindPricePart, (float)(x + lineLen), (float)y, -1, false);
                }
                int lineLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(line);
                fontRendererObj.func_175065_a(price, (float)(x + lineLen), (float)y, -1, true);
            }
            fontRendererObj.func_175065_a(line, (float)x, (float)y, -1, false);
            if (++i == 3) {
                y += 13;
                continue;
            }
            y += 10;
        }
    }

    private LinkedHashMap<String, OverviewLine> getRenderMap() {
        if (this.cacheRenderMap != null) {
            return this.cacheRenderMap;
        }
        Map<Minion, Double> prices = this.getMissing();
        LinkedHashMap<String, OverviewLine> renderMap = new LinkedHashMap<String, OverviewLine>();
        this.addTitle(prices, renderMap);
        this.addNeedToNextSlot(prices, renderMap);
        if (!prices.isEmpty()) {
            this.addMinions(prices, renderMap);
        }
        this.cacheRenderMap = renderMap;
        return renderMap;
    }

    private void addNeedToNextSlot(Map<Minion, Double> prices, LinkedHashMap<String, OverviewLine> renderMap) {
        int neededForNextSlot = this.manager.getNeedForNextSlot();
        if (neededForNextSlot == -1) {
            renderMap.put("\u00a78Next slot: ?", new OverviewText(Collections.emptyList(), () -> {}));
            return;
        }
        double priceNeeded = 0.0;
        int peltsNeeded = 0;
        int northStarsNeeded = 0;
        int xpGain = 0;
        int index = 0;
        for (Minion minion : TrophyRewardOverlay.sortByValue(prices).keySet()) {
            Double price = prices.get(minion);
            priceNeeded += price.doubleValue();
            xpGain += minion.getXpGain();
            peltsNeeded += MinionHelperOverlay.getSpecialItemNeeds(minion, "SKYBLOCK_PELT");
            northStarsNeeded += MinionHelperOverlay.getSpecialItemNeeds(minion, "SKYBLOCK_NORTH_STAR");
            if (++index != neededForNextSlot) continue;
            break;
        }
        String costFormat = this.manager.getPriceCalculation().formatCoins(priceNeeded);
        costFormat = costFormat.replace(" coins", "");
        if (peltsNeeded > 0) {
            costFormat = costFormat + " \u00a78+ \u00a75" + peltsNeeded + " Pelts";
        }
        if (northStarsNeeded > 0) {
            costFormat = costFormat + " \u00a78+ \u00a7d" + northStarsNeeded + " North Stars";
        }
        List<String> lore = xpGain == 0 ? (index == 0 ? Arrays.asList("\u00a7aAll minions bought!", "\u00a7cNo more SkyBlock XP to gain!") : Collections.singletonList("\u00a7cCould not load SkyBlock XP for next slot!")) : Arrays.asList(EnumChatFormatting.DARK_AQUA.toString() + xpGain + " Skyblock XP \u00a7efor next slot", "\u00a78DISCLAIMER: This only works if", "\u00a78you follow the helper.");
        OverviewText overviewText = new OverviewText(lore, () -> {});
        renderMap.put("\u00a78Next slot: \u00a73" + neededForNextSlot + " minions", overviewText);
        renderMap.put("\u00a78Cost: " + costFormat, overviewText);
    }

    private static int getSpecialItemNeeds(Minion minion, String specialItem) {
        NpcSource source;
        ArrayListMultimap<String, Integer> items2;
        int count = 0;
        MinionSource minionSource = minion.getMinionSource();
        if (minionSource instanceof NpcSource && (items2 = (source = (NpcSource)minionSource).getItems()).containsKey((Object)specialItem)) {
            for (Integer amount : items2.get((Object)specialItem)) {
                count += amount.intValue();
            }
        }
        return count;
    }

    private void addTitle(Map<Minion, Double> prices, LinkedHashMap<String, OverviewLine> renderMap) {
        String name = "\u00a78" + prices.size() + " " + (this.filterEnabled ? "craftable" : "total") + " minions";
        renderMap.put(name, new OverviewText(Collections.emptyList(), () -> {}));
    }

    private void addMinions(Map<Minion, Double> prices, LinkedHashMap<String, OverviewLine> renderMap) {
        int skipPreviousPages = this.currentPage * this.maxPerPage;
        int i = 0;
        Map<Minion, Double> sort2 = TrophyRewardOverlay.sortByValue(prices);
        for (Minion minion : sort2.keySet()) {
            if (i >= skipPreviousPages) {
                String displayName = minion.getDisplayName();
                if (displayName == null) {
                    if (!NotEnoughUpdates.INSTANCE.config.hidden.dev) continue;
                    Utils.addChatMessage("\u00a7cDisplayname is null for " + minion.getInternalName());
                    continue;
                }
                displayName = displayName.replace(" Minion", "");
                String format2 = this.manager.getPriceCalculation().calculateUpgradeCostsFormat(minion, true);
                format2 = format2.replace(" coins", "");
                String requirementFormat = minion.doesMeetRequirements() ? "\u00a79" : "\u00a7c";
                renderMap.put(requirementFormat + displayName + " " + minion.getTier() + " \u00a78- " + format2, minion);
            }
            if (++i != (this.currentPage + 1) * this.maxPerPage) continue;
            break;
        }
    }

    private int getTotalPages() {
        if (this.cacheTotalPages != -1) {
            return this.cacheTotalPages;
        }
        Map<Minion, Double> prices = this.getMissing();
        int totalPages = (int)((double)prices.size() / (double)this.maxPerPage);
        if (prices.size() % this.maxPerPage != 0) {
            ++totalPages;
        }
        this.cacheTotalPages = totalPages;
        return totalPages;
    }

    private void toggleShowAvailable() {
        this.filterEnabled = !this.filterEnabled;
        this.currentPage = 0;
        this.resetCache();
    }

    private void toggleUseInstantBuyPrice() {
        this.useInstantBuyPrice = !this.useInstantBuyPrice;
        this.currentPage = 0;
        this.resetCache();
        this.manager.getPriceCalculation().resetCache();
    }

    OverviewLine getObjectOverMouse(LinkedHashMap<String, OverviewLine> renderMap) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiChest)) {
            return null;
        }
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        int x = guiLeft + xSize + 9;
        int y = guiTop + 5;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        int i = 0;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (Map.Entry<String, OverviewLine> entry : renderMap.entrySet()) {
            String text = entry.getKey();
            int width = fontRenderer.func_78256_a(StringUtils.cleanColour(text));
            if (mouseX > x && mouseX < x + width + 4 && mouseY > y && mouseY < y + 11) {
                return entry.getValue();
            }
            if (++i == 3) {
                y += 13;
                continue;
            }
            y += 10;
        }
        return null;
    }

    public void onProfileSwitch() {
        this.currentPage = 0;
        this.filterEnabled = true;
        this.useInstantBuyPrice = true;
    }

    public void setMaxPerPage(int maxPerPage) {
        this.maxPerPage = maxPerPage;
    }

    public void setTopLeft(int[] topLeft) {
        this.topLeft = topLeft;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public boolean isUseInstantBuyPrice() {
        return this.useInstantBuyPrice;
    }
}

