/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.ApiData;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.MinionHelperApiLoader;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.MinionHelperChatLoader;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.MinionHelperInventoryLoader;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.repo.MinionHelperRepoLoader;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.MinionHelperOverlay;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.MinionHelperTooltips;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CustomSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.util.MinionHelperPriceCalculation;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.util.MinionHelperRequirementsManager;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraftforge.common.MinecraftForge;

public class MinionHelperManager {
    private static MinionHelperManager instance = null;
    private final Map<String, Minion> minions = new HashMap<String, Minion>();
    private int needForNextSlot = -1;
    private int localPelts = -1;
    private final MinionHelperPriceCalculation priceCalculation = new MinionHelperPriceCalculation(this);
    private final MinionHelperRequirementsManager requirementsManager = new MinionHelperRequirementsManager(this);
    private final MinionHelperApiLoader api = new MinionHelperApiLoader(this);
    private final MinionHelperRepoLoader repo = new MinionHelperRepoLoader(this);
    private final MinionHelperOverlay overlay = new MinionHelperOverlay(this);
    private final MinionHelperInventoryLoader inventoryLoader = new MinionHelperInventoryLoader(this);
    private String debugPlayerUuid;
    private String debugProfileName;
    private int debugNeedForNextSlot = -1;

    public static MinionHelperManager getInstance() {
        if (instance == null) {
            instance = new MinionHelperManager();
        }
        return instance;
    }

    private MinionHelperManager() {
        MinecraftForge.EVENT_BUS.register((Object)this.priceCalculation);
        MinecraftForge.EVENT_BUS.register((Object)this.api);
        MinecraftForge.EVENT_BUS.register((Object)this.repo);
        MinecraftForge.EVENT_BUS.register((Object)this.overlay);
        MinecraftForge.EVENT_BUS.register((Object)new MinionHelperTooltips(this));
        MinecraftForge.EVENT_BUS.register((Object)new MinionHelperChatLoader(this));
        MinecraftForge.EVENT_BUS.register((Object)this.inventoryLoader);
    }

    public boolean inCraftedMinionsInventory() {
        if (!NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.field_71439_g == null) {
            return false;
        }
        Container inventoryContainer = minecraft.field_71439_g.field_71070_bA;
        if (!(inventoryContainer instanceof ContainerChest)) {
            return false;
        }
        ContainerChest containerChest = (ContainerChest)inventoryContainer;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        return name.equalsIgnoreCase("Crafted Minions");
    }

    public boolean notReady() {
        return !this.repo.isReadyToUse() || !this.api.isReadyToUse();
    }

    public boolean isInvalidApiKey() {
        return this.api.isInvalidApiKey();
    }

    public Minion getMinionById(String internalName) {
        if (this.minions.containsKey(internalName)) {
            return this.minions.get(internalName);
        }
        System.err.println("Cannot get minion for id '" + internalName + "'!");
        return null;
    }

    public Minion getMinionByName(String displayName, int tier) {
        for (Minion minion : this.minions.values()) {
            if (!displayName.equals(minion.getDisplayName()) || minion.getTier() != tier) continue;
            return minion;
        }
        System.err.println("Cannot get minion for display name '" + displayName + "'!");
        return null;
    }

    public void createMinion(String internalName, int tier, int xpGain) {
        this.minions.put(internalName, new Minion(internalName, tier, xpGain));
    }

    public String formatInternalName(String minionName) {
        return minionName.toUpperCase(Locale.ROOT).replace(" ", "_");
    }

    private List<Minion> getChildren(Minion minion) {
        ArrayList<Minion> list = new ArrayList<Minion>();
        for (Minion other : this.minions.values()) {
            if (minion != other.getParent()) continue;
            list.add(other);
            list.addAll(this.getChildren(other));
            break;
        }
        return list;
    }

    public void onProfileSwitch() {
        for (Minion minion : this.minions.values()) {
            minion.setCrafted(false);
            minion.setMeetRequirements(false);
        }
        this.needForNextSlot = -1;
        this.api.onProfileSwitch();
        this.overlay.onProfileSwitch();
        this.inventoryLoader.onProfileSwitch();
    }

    public void reloadData() {
        this.requirementsManager.reloadRequirements();
        ApiData apiData = this.api.getApiData();
        if (apiData != null) {
            for (String minion : apiData.getCraftedMinions()) {
                this.setCrafted(this.getMinionById(minion));
            }
        }
    }

    public void setCrafted(Minion minion) {
        minion.setCrafted(true);
        if (minion.getCustomSource() != null) {
            minion.setMeetRequirements(true);
            for (Minion child : this.getChildren(minion)) {
                child.setMeetRequirements(true);
            }
        }
    }

    public void handleCommand(String[] args) {
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            Utils.addChatMessage("\u00a7e[NEU] Minion Helper gui is disabled!");
            return;
        }
        if (args.length > 1) {
            String parameter = args[1];
            if (parameter.equals("debugplayer")) {
                if (args.length == 3 && args[2].equals("reset")) {
                    Utils.addChatMessage("\u00a7e[NEU] Minion debug player reset.");
                    this.setDebugPlayer(null, null, -1);
                    return;
                }
                if (args.length < 4) {
                    Utils.addChatMessage("\u00a7c[NEU] Usage: /neudevtest minion setplayer <player-uuid> <player-profile-name> [need-for-next-slot]");
                    return;
                }
                String playerUuid = args[2];
                String playerProfileName = args[3];
                int need = args.length == 5 ? Integer.parseInt(args[4]) : -1;
                this.setDebugPlayer(playerUuid, playerProfileName, need);
                Utils.addChatMessage("\u00a7e[NEU] Minion debug player set.");
                return;
            }
            if (args.length == 2) {
                if (parameter.equals("clearminion")) {
                    this.minions.clear();
                    Utils.addChatMessage("minion map cleared");
                    return;
                }
                if (parameter.equals("reloadrepo")) {
                    this.repo.setDirty();
                    Utils.addChatMessage("repo reload requested");
                    return;
                }
                if (parameter.equals("reloadapi")) {
                    this.api.resetData();
                    this.api.setDirty();
                    Utils.addChatMessage("api reload requested");
                    return;
                }
                if (parameter.equals("clearapi")) {
                    this.api.resetData();
                    Utils.addChatMessage("api data cleared");
                    return;
                }
            }
            if (args.length == 3 && parameter.equals("maxperpage")) {
                this.api.resetData();
                int maxPerPage = Integer.parseInt(args[2]);
                Utils.addChatMessage("set max per page to " + maxPerPage);
                this.overlay.setMaxPerPage(maxPerPage);
                return;
            }
            if (args.length == 4 && parameter.equals("arrowpos")) {
                int x = Integer.parseInt(args[2]);
                int y = Integer.parseInt(args[3]);
                Utils.addChatMessage("set page pos to " + x + ";" + y);
                this.overlay.setTopLeft(new int[]{x, y});
                return;
            }
        }
        Utils.addChatMessage("");
        Utils.addChatMessage("\u00a73NEU Minion Helper commands: \u00a7c(for testing only!)");
        Utils.addChatMessage("\u00a76/neudevtest minion clearminion \u00a77Clears the minion map");
        Utils.addChatMessage("\u00a76/neudevtest minion reloadrepo \u00a77Manually loading the data from repo");
        Utils.addChatMessage("\u00a76/neudevtest minion reloadapi \u00a77Manually loading the data from api");
        Utils.addChatMessage("\u00a76/neudevtest minion clearapi \u00a77Clears the api data");
        Utils.addChatMessage("\u00a76/neudevtest minion maxperpage <number> \u00a77Changes the max minions per page number");
        Utils.addChatMessage("\u00a76/neudevtest minion arrowpos <x, y> \u00a77Changes the position of the page numbers");
        Utils.addChatMessage("\u00a76/neudevtest minion debugplayer <player-uuid> <player-profile-name> [need-for-next-slot] \u00a77See the Minions missing of other player");
        Utils.addChatMessage("");
    }

    private void setDebugPlayer(String playerUuid, String playerProfileName, int fakeNeedForNextSlot) {
        this.debugPlayerUuid = playerUuid;
        this.debugProfileName = playerProfileName;
        this.debugNeedForNextSlot = fakeNeedForNextSlot;
        this.onProfileSwitch();
    }

    public MinionHelperPriceCalculation getPriceCalculation() {
        return this.priceCalculation;
    }

    public MinionHelperRequirementsManager getRequirementsManager() {
        return this.requirementsManager;
    }

    public MinionHelperApiLoader getApi() {
        return this.api;
    }

    public MinionHelperOverlay getOverlay() {
        return this.overlay;
    }

    public Map<String, Minion> getAllMinions() {
        return this.minions;
    }

    public void setNeedForNextSlot(int needForNextSlot) {
        this.needForNextSlot = needForNextSlot;
        this.overlay.resetCache();
    }

    public int getNeedForNextSlot() {
        return this.needForNextSlot;
    }

    public void setCustomSource(Minion minion, CustomSource customSource) {
        MinionSource minionSource = minion.getMinionSource();
        if (minionSource == null) {
            minion.setMinionSource(customSource);
        }
        minion.setCustomSource(customSource);
    }

    public int getLocalPelts() {
        return this.localPelts;
    }

    public void setLocalPelts(int pelts) {
        ApiData apiData;
        this.localPelts = pelts;
        if (this.localPelts != -1 && (apiData = this.api.getApiData()) != null) {
            apiData.setPeltCount(this.localPelts);
        }
    }

    public String getDebugPlayerUuid() {
        return this.debugPlayerUuid;
    }

    public String getDebugProfileName() {
        return this.debugProfileName;
    }

    public int getDebugNeedForNextSlot() {
        return this.debugNeedForNextSlot;
    }
}

