/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.itemcustomization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.dev.AnimatedSkullExporter;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.DyeMode;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizationUtils;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class ItemCustomizeManager {
    public static boolean disableTextureBinding = false;
    private static ResourceLocation CUSTOM_GLINT_TEXTURE = new ResourceLocation("notenoughupdates:dynamic/custom_glint_texture");
    private static boolean loadedCustomGlintTexture = false;
    public static final String DEFAULT_GLINT_COLOR = ChromaColour.special(0, 204, 6560255);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ItemDataMap itemDataMap = new ItemDataMap();
    static Random random = new Random();
    static HashMap<Integer, Long> lastUpdate = new HashMap();
    static HashMap<Integer, Integer> damageMap = new HashMap();
    public static HashMap<String, AnimatedSkull> customSkulls = new HashMap();

    public static void putItemData(String uuid, ItemData data) {
        ItemCustomizeManager.itemDataMap.itemData.put(uuid, data);
    }

    public static void setCustomBlendFunc(String colour) {
        GL14.glBlendFuncSeparate((int)770, (int)32771, (int)1, (int)771);
    }

    private static void renderEffect(Consumer<Integer> renderModelCallback, int color) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ItemCustomizeManager.getCustomGlintTexture());
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelCallback.accept(color);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelCallback.accept(color);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glPopMatrix();
    }

    private static void renderArmorGlint(Runnable renderModelCallback, float existed, int color) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ItemCustomizeManager.getCustomGlintTexture());
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        float f1 = 0.5f;
        GlStateManager.func_179131_c((float)f1, (float)f1, (float)f1, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f3 = 0.33333334f;
            GlStateManager.func_179152_a((float)f3, (float)f3, (float)f3);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(existed * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            renderModelCallback.run();
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
    }

    public static void pre() {
        GlStateManager.func_179128_n((int)5888);
    }

    public static boolean render3DGlint(String customEnchantGlint, float existed, Runnable renderModelCallback) {
        if (customEnchantGlint != null) {
            int colour = ChromaColour.specialToChromaRGB(customEnchantGlint);
            float[] hsv = Color.RGBtoHSB(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, null);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hsv[2]);
            GlStateManager.func_179120_a((int)0, (int)771, (int)0, (int)771);
            int alphaValue = (int)((1.0f - hsv[2] * hsv[2]) * 255.0f) * (colour >> 24 & 0xFF) / 255;
            ItemCustomizeManager.renderArmorGlint(renderModelCallback, existed, alphaValue << 24);
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)1);
            ItemCustomizeManager.renderArmorGlint(renderModelCallback, existed, colour);
            return true;
        }
        return false;
    }

    public static boolean renderEffectHook(String customEnchantGlint, Consumer<Integer> renderModelCallback) {
        if (customEnchantGlint != null) {
            int colour = ChromaColour.specialToChromaRGB(customEnchantGlint);
            float[] hsv = Color.RGBtoHSB(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, null);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hsv[2]);
            GL11.glPushMatrix();
            GlStateManager.func_179120_a((int)0, (int)771, (int)0, (int)771);
            int alphaValue = (int)((1.0f - hsv[2] * hsv[2]) * 255.0f) * (colour >> 24 & 0xFF) / 255;
            ItemCustomizeManager.renderEffect(renderModelCallback, alphaValue << 24);
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)1);
            ItemCustomizeManager.renderEffect(renderModelCallback, colour);
            GL11.glPopMatrix();
            return true;
        }
        return false;
    }

    public static ResourceLocation getCustomGlintTexture() {
        if (!loadedCustomGlintTexture) {
            loadedCustomGlintTexture = true;
            ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
            try {
                BufferedImage originalGlint = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(RES_ITEM_GLINT).func_110527_b());
                BufferedImage newGlint = new BufferedImage(originalGlint.getWidth(), originalGlint.getHeight(), 2);
                for (int x = 0; x < originalGlint.getWidth(); ++x) {
                    for (int y = 0; y < originalGlint.getHeight(); ++y) {
                        int argb = originalGlint.getRGB(x, y);
                        int avgRGB = ((argb >> 16 & 0xFF) + (argb >> 8 & 0xFF) + (argb & 0xFF)) / 3 & 0xFF;
                        int newArgb = avgRGB << 24 | avgRGB << 16 | avgRGB << 8 | avgRGB;
                        newGlint.setRGB(x, y, newArgb);
                    }
                }
                Minecraft.func_71410_x().func_110434_K().func_110579_a(CUSTOM_GLINT_TEXTURE, (ITextureObject)new DynamicTexture(newGlint));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                CUSTOM_GLINT_TEXTURE = RES_ITEM_GLINT;
            }
        }
        return CUSTOM_GLINT_TEXTURE;
    }

    public static ItemData getDataForItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        String uuid = NEUManager.getUUIDForItem(stack);
        if (uuid == null) {
            return null;
        }
        return ItemCustomizeManager.itemDataMap.itemData.get(uuid);
    }

    public static void tick() {
        disableTextureBinding = false;
    }

    public static void loadCustomization(File file) {
        itemDataMap = ConfigUtil.loadConfig(ItemDataMap.class, file, GSON);
        if (itemDataMap == null) {
            itemDataMap = new ItemDataMap();
        }
    }

    public static void saveCustomization(File file) {
        ConfigUtil.saveConfig(itemDataMap, file, GSON);
    }

    public static Item getCustomItem(ItemStack stack) {
        ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data == null || data.customItem == null || data.customItem.length() == 0 || data.customItem.split(":").length == 0) {
            return stack.func_77973_b();
        }
        Item newItem = Item.func_111206_d((String)data.customItem.split(":")[0]);
        if (newItem == null) {
            return stack.func_77973_b();
        }
        return newItem;
    }

    public static Item getCustomItem(ItemStack stack, String newItemString) {
        if (newItemString.split(":").length == 0) {
            return stack.func_77973_b();
        }
        Item newItem = Item.func_111206_d((String)newItemString.split(":")[0]);
        if (newItem == null) {
            return stack.func_77973_b();
        }
        return newItem;
    }

    public static int getCustomItemDamage(ItemStack stack) {
        ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data == null || data.customItem == null || data.customItem.length() == 0) {
            return stack.func_77960_j();
        }
        try {
            String damageString = data.customItem.split(":")[1];
            if (damageString.equals("?")) {
                ArrayList list = new ArrayList();
                ItemCustomizeManager.getCustomItem(stack).func_150895_a(ItemCustomizeManager.getCustomItem(stack), null, list);
                if (damageMap.get(stack.func_77978_p().hashCode()) == null || System.currentTimeMillis() - lastUpdate.get(stack.func_77978_p().hashCode()) > 250L) {
                    damageMap.put(stack.func_77978_p().hashCode(), random.nextInt(list.size()));
                    lastUpdate.put(stack.func_77978_p().hashCode(), System.currentTimeMillis());
                }
                return damageMap.get(stack.func_77978_p().hashCode());
            }
            if (ItemCustomizeManager.getCustomItem(stack) == Items.field_151144_bL) {
                String itemID = damageString.toUpperCase(Locale.ROOT).replace(" ", "_");
                ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItem(itemID);
                if (itemStack != null && itemStack.func_77973_b() == Items.field_151144_bL) {
                    return 3;
                }
                NBTTagCompound animatedCustomSkull = ItemCustomizeManager.getAnimatedCustomSkull(itemID, "");
                if (animatedCustomSkull != null) {
                    return 3;
                }
            }
            return Integer.parseInt(data.customItem.split(":")[1]);
        }
        catch (Exception e2) {
            if (Item.func_111206_d((String)data.defaultItem) == Items.field_151144_bL && ItemCustomizeManager.getCustomItem(stack) != Items.field_151144_bL) {
                return 0;
            }
            return stack.func_77960_j();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        damageMap.clear();
        lastUpdate.clear();
    }

    public static boolean shouldRenderLeatherColour(ItemStack stack) {
        ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data == null || data.customItem == null || data.customItem.length() == 0) {
            return stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
        }
        Item item = Item.func_111206_d((String)data.customItem);
        if (item == null) {
            return stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
        }
        return item instanceof ItemArmor && ((ItemArmor)item).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
    }

    public static boolean hasCustomItem(ItemStack stack) {
        ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data == null || data.customItem == null || data.customItem.length() == 0 || data.defaultItem == null || data.customItem.equals(data.defaultItem) || data.customItem.split(":").length == 0) {
            return false;
        }
        Item item = Item.func_111206_d((String)data.customItem.split(":")[0]);
        Item defaultItem = Item.func_111206_d((String)data.defaultItem);
        if (item == null) {
            data.customItem = null;
            return false;
        }
        if (item == defaultItem && ItemCustomizeManager.getCustomSkull(stack) != null) {
            return true;
        }
        return defaultItem != item;
    }

    public static ItemStack useCustomArmour(LayerArmorBase<?> instance, EntityLivingBase entitylivingbaseIn, int armorSlot) {
        NBTTagCompound customSkull;
        ItemStack stack = instance.func_177176_a(entitylivingbaseIn, armorSlot);
        if (stack == null || ItemCustomizeManager.getDataForItem(stack) == null) {
            return stack;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.func_150996_a(ItemCustomizeManager.getCustomItem(newStack));
        newStack.func_77964_b(ItemCustomizeManager.getCustomItemDamage(newStack));
        if (newStack.func_77942_o() && (customSkull = ItemCustomizeManager.getCustomSkull(newStack)) != null) {
            newStack.func_77978_p().func_82580_o("SkullOwner");
            newStack.func_77978_p().func_74782_a("SkullOwner", (NBTBase)customSkull);
        }
        if (armorSlot != 4 && !(newStack.func_77973_b() instanceof ItemArmor)) {
            newStack = stack;
        }
        if (newStack.func_77973_b() == stack.func_77973_b() && newStack.func_77952_i() == stack.func_77952_i()) {
            return stack;
        }
        return newStack;
    }

    public static ItemStack useCustomItem(ItemStack stack) {
        NBTTagCompound customSkull;
        if (stack == null) {
            return stack;
        }
        if (!ItemCustomizeManager.hasCustomItem(stack)) {
            return stack;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.func_150996_a(ItemCustomizeManager.getCustomItem(newStack));
        newStack.func_77964_b(ItemCustomizeManager.getCustomItemDamage(newStack));
        NBTTagCompound tagCompound = newStack.func_77978_p();
        if (tagCompound != null && (customSkull = ItemCustomizeManager.getCustomSkull(newStack)) != null) {
            tagCompound.func_82580_o("SkullOwner");
            tagCompound.func_74782_a("SkullOwner", (NBTBase)customSkull);
        }
        return newStack;
    }

    public static ItemStack setHeadArmour(EntityLivingBase instance, int i) {
        NBTTagCompound customSkull;
        if (instance.func_82169_q(3) == null) {
            return null;
        }
        ItemStack stack = instance.func_82169_q(3).func_77946_l();
        stack.func_150996_a(ItemCustomizeManager.getCustomItem(stack));
        stack.func_77964_b(ItemCustomizeManager.getCustomItemDamage(stack));
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && (customSkull = ItemCustomizeManager.getCustomSkull(stack)) != null) {
            tagCompound.func_82580_o("SkullOwner");
            tagCompound.func_74782_a("SkullOwner", (NBTBase)customSkull);
        }
        return stack;
    }

    public static NBTTagCompound getCustomSkull(ItemStack stack) {
        ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data == null || data.customItem == null || data.customItem.isEmpty()) {
            return null;
        }
        try {
            String[] customItemSegments = data.customItem.split(":");
            String damageString = customItemSegments[1];
            String index = "";
            if (customItemSegments.length > 2) {
                index = customItemSegments[2];
            }
            if (ItemCustomizeManager.getCustomItem(stack) == Items.field_151144_bL) {
                String itemID = damageString.toUpperCase(Locale.ROOT).replace(" ", "_");
                NBTTagCompound animatedCustomSkull = ItemCustomizeManager.getAnimatedCustomSkull(itemID, index);
                if (animatedCustomSkull != null) {
                    return animatedCustomSkull;
                }
                ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItem(itemID);
                if (itemStack != null && itemStack.func_77973_b() == Items.field_151144_bL) {
                    return itemStack.func_77978_p().func_74775_l("SkullOwner");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @SubscribeEvent
    public void onRepoReload(RepositoryReloadEvent event) {
        customSkulls.clear();
    }

    public static NBTTagCompound getAnimatedCustomSkull(String itemID, String textureIndex) {
        int presetIndex = -1;
        if (!textureIndex.isEmpty()) {
            try {
                presetIndex = Integer.parseInt(textureIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<String> testSkulls = AnimatedSkullExporter.lastSkullsList;
        if ("TEST".equals(itemID) && !testSkulls.isEmpty()) {
            int animatedIndex = ItemCustomizationUtils.getTicksForList(2, testSkulls.size(), presetIndex);
            String skullTexture = testSkulls.get(animatedIndex);
            ItemStack skull = Utils.createSkull("test", skullTexture.split(":")[0], skullTexture.split(":")[1]);
            return skull.func_77978_p().func_74775_l("SkullOwner");
        }
        if (customSkulls.containsKey(itemID)) {
            AnimatedSkull animatedSkull = customSkulls.get(itemID);
            int ticks = animatedSkull.ticks;
            int animatedIndex = ItemCustomizationUtils.getTicksForList(ticks, animatedSkull.skullOwners.size(), presetIndex);
            return animatedSkull.skullOwners.get(animatedIndex);
        }
        JsonObject animatedSkulls = Constants.ANIMATEDSKULLS;
        if (animatedSkulls == null) {
            return null;
        }
        if (!animatedSkulls.has("skins")) {
            return null;
        }
        if (!animatedSkulls.get("skins").getAsJsonObject().has(itemID)) {
            return null;
        }
        JsonObject skin = animatedSkulls.get("skins").getAsJsonObject().get(itemID).getAsJsonObject();
        if (!skin.has("textures")) {
            return null;
        }
        JsonArray skullTextures = skin.get("textures").getAsJsonArray();
        int ticks = skin.get("ticks").getAsInt();
        int animatedIndex = ItemCustomizationUtils.getTicksForList(ticks, skullTextures.size(), presetIndex);
        AnimatedSkull animatedSkull = new AnimatedSkull();
        animatedSkull.ticks = ticks;
        animatedSkull.skullOwners = new ArrayList();
        for (JsonElement skullTexture : skullTextures) {
            String texture = skullTexture.getAsString();
            ItemStack skull = Utils.createSkull("test", texture.split(":")[0], texture.split(":")[1]);
            animatedSkull.skullOwners.add(skull.func_77978_p().func_74775_l("SkullOwner"));
        }
        customSkulls.put(itemID, animatedSkull);
        return animatedSkull.skullOwners.get(animatedIndex);
    }

    public static List<String> getAnimatedSkullHelp(String damageString) {
        if (damageString.replace(":", "").equals("skull")) {
            return ItemCustomizationUtils.skullGuide;
        }
        JsonObject animatedSkulls = Constants.ANIMATEDSKULLS;
        if (animatedSkulls == null) {
            return null;
        }
        if (!animatedSkulls.has("help")) {
            return null;
        }
        String[] split = damageString.split(":");
        if (split.length == 1) {
            return null;
        }
        String itemID = split[1].toUpperCase(Locale.ROOT).replace(" ", "_");
        if (!animatedSkulls.get("help").getAsJsonObject().has(itemID)) {
            return null;
        }
        JsonArray helpLines = animatedSkulls.get("help").getAsJsonObject().get(itemID).getAsJsonArray();
        ArrayList<String> helpLinesStrings = new ArrayList<String>();
        for (int i = 0; i < helpLines.size(); ++i) {
            helpLinesStrings.add(helpLines.get(i).getAsString());
        }
        return helpLinesStrings;
    }

    static class AnimatedSkull {
        ArrayList<NBTTagCompound> skullOwners;
        int ticks;

        AnimatedSkull() {
        }
    }

    public static class ItemData {
        public String customName = null;
        public String customNamePrefix = "";
        public boolean overrideEnchantGlint = false;
        public boolean enchantGlintValue;
        public String customGlintColour = DEFAULT_GLINT_COLOR;
        public String customLeatherColour = null;
        public String[] animatedLeatherColours = null;
        public int animatedDyeTicks = 2;
        public DyeMode dyeMode = DyeMode.CYCLING;
        public String defaultItem = null;
        public String customItem = null;
    }

    public static class ItemDataMap {
        public HashMap<String, ItemData> itemData = new HashMap();
    }

    public static class ReloadListener
    implements IResourceManagerReloadListener {
        public void func_110549_a(IResourceManager resourceManager) {
            loadedCustomGlintTexture = false;
        }
    }
}

