/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.hex;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.hex.ItemType;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.StringUtils;

public class HexItem {
    public int slotIndex;
    public String itemName;
    public String itemId;
    public List<String> displayLore;
    public int level;
    public int price = -1;
    public boolean overMaxLevel = false;
    public boolean conflicts = false;
    public ItemType itemType;
    public int gemstoneLevel = -1;

    public HexItem(int slotIndex, String itemName, String itemId, List<String> displayLore, boolean useMaxLevelForCost, boolean checkConflicts) {
        JsonObject bazaarInfo;
        this.slotIndex = slotIndex;
        this.itemName = itemName;
        this.itemId = itemId.replace("'S", "");
        this.displayLore = displayLore;
        switch (itemId) {
            default: {
                this.itemType = ItemType.UNKNOWN;
                break;
            }
            case "HOT_POTATO_BOOK": {
                this.itemType = ItemType.HOT_POTATO;
                break;
            }
            case "FUMING_POTATO_BOOK": {
                this.itemType = ItemType.FUMING_POTATO;
                break;
            }
            case "BOOK_OF_STATS": {
                this.itemType = ItemType.BOOK_OF_STATS;
                break;
            }
            case "THE_ART_OF_WAR": {
                this.itemType = ItemType.ART_OF_WAR;
                break;
            }
            case "FARMING_FOR_DUMMIES": {
                this.itemType = ItemType.FARMING_DUMMY;
                break;
            }
            case "THE_ART_OF_PEACE": {
                this.itemType = ItemType.ART_OF_PEACE;
                break;
            }
            case "RECOMBOBULATOR_3000": {
                this.itemType = ItemType.RECOMB;
                break;
            }
            case "SILEX": {
                this.itemId = "SIL_EX";
                this.itemType = ItemType.SILEX;
                break;
            }
            case "RUBY_POWER_SCROLL": {
                this.itemType = ItemType.RUBY_SCROLL;
                break;
            }
            case "SAPPHIRE_POWER_SCROLL": {
                this.itemType = ItemType.SAPPHIRE_SCROLL;
                break;
            }
            case "JASPER_POWER_SCROLL": {
                this.itemType = ItemType.JASPER_SCROLL;
                break;
            }
            case "AMETHYST_POWER_SCROLL": {
                this.itemType = ItemType.AMETHYST_SCROLL;
                break;
            }
            case "AMBER_POWER_SCROLL": {
                this.itemType = ItemType.AMBER_SCROLL;
                break;
            }
            case "OPAL_POWER_SCROLL": {
                this.itemType = ItemType.OPAL_SCROLL;
                break;
            }
            case "FIRST_MASTER_STAR": {
                this.itemType = ItemType.FIRST_MASTER_STAR;
                break;
            }
            case "SECOND_MASTER_STAR": {
                this.itemType = ItemType.SECOND_MASTER_STAR;
                break;
            }
            case "THIRD_MASTER_STAR": {
                this.itemType = ItemType.THIRD_MASTER_STAR;
                break;
            }
            case "FOURTH_MASTER_STAR": {
                this.itemType = ItemType.FOURTH_MASTER_STAR;
                break;
            }
            case "FIFTH_MASTER_STAR": {
                this.itemType = ItemType.FIFTH_MASTER_STAR;
                break;
            }
            case "WOOD_SINGULARITY": {
                this.itemType = ItemType.WOOD_SINGULARITY;
                break;
            }
            case "IMPLOSION": {
                this.itemType = ItemType.IMPLOSION_SCROLL;
                break;
            }
            case "WITHER_SHIELD": {
                this.itemType = ItemType.WITHER_SHIELD_SCROLL;
                break;
            }
            case "SHADOW_WARP": {
                this.itemType = ItemType.SHADOW_WARP_SCROLL;
                break;
            }
            case "TRANSMISSION_TUNER": {
                this.itemType = ItemType.TUNER;
                break;
            }
            case "RANDOM_REFORGE": {
                this.itemType = ItemType.RANDOM_REFORGE;
                break;
            }
            case "MANA_DISINTEGRATOR": {
                this.itemType = ItemType.MANA_DISINTEGRATOR;
                break;
            }
            case "TOTAL_UPGRADES": {
                this.itemType = ItemType.TOTAL_UPGRADES;
                break;
            }
            case "CONVERT_TO_DUNGEON": {
                this.itemType = ItemType.CONVERT_TO_DUNGEON;
                break;
            }
            case "EXPERIENCE_BOTTLE": {
                this.itemType = ItemType.EXPERIENCE_BOTTLE;
                break;
            }
            case "GRAND_EXPERIENCE_BOTTLE": {
                this.itemType = ItemType.GRAND_EXPERIENCE_BOTTLE;
                break;
            }
            case "TITANIC_EXPERIENCE_BOTTLE": {
                this.itemType = ItemType.TITANIC_EXPERIENCE_BOTTLE;
                break;
            }
            case "COLOSSAL_EXPERIENCE_BOTTLE": {
                this.itemType = ItemType.COLOSSAL_EXPERIENCE_BOTTLE;
                break;
            }
            case "FEROCITY_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_FEROCITY;
                break;
            }
            case "SEA_CREATURE_CHANCE_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_SCC;
                break;
            }
            case "ATTACK_SPEED_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_ATTACK_SPEED;
                break;
            }
            case "SPEED_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_SPEED;
                break;
            }
            case "INTELLIGENCE_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_INTELLIGENCE;
                break;
            }
            case "CRITICAL_DAMAGE_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_CRIT_DAMAGE;
                break;
            }
            case "STRENGTH_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_STRENGTH;
                break;
            }
            case "DEFENSE_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_DEFENSE;
                break;
            }
            case "HEALTH_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_HEALTH;
                break;
            }
            case "MAGIC_FIND_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_MAGIC_FIND;
                break;
            }
            case "CRITICAL_CHANCE_ENRICHMENT": {
                this.itemType = ItemType.ENRICHMENT_CRIT_CHANCE;
            }
        }
        if (this.itemType == ItemType.UNKNOWN) {
            for (String string : displayLore) {
                if ((!string.contains("Applies the") || !string.contains("reforge")) && !string.contains("reforge when combined")) continue;
                this.itemType = ItemType.REFORGE;
                break;
            }
        }
        if (!this.isMasterStar() && itemId.contains("\u272a")) {
            if (itemId.contains("\u272a\u272a\u272a\u272a\u272a")) {
                this.itemType = ItemType.FIFTH_STAR;
            } else if (itemId.contains("\u272a\u272a\u272a\u272a")) {
                this.itemType = ItemType.FOURTH_STAR;
            } else if (itemId.contains("\u272a\u272a\u272a")) {
                this.itemType = ItemType.THIRD_STAR;
            } else if (itemId.contains("\u272a\u272a")) {
                this.itemType = ItemType.SECOND_STAR;
            } else if (itemId.contains("\u272a")) {
                this.itemType = ItemType.FIRST_STAR;
            }
        }
        if (this.itemId.contains("EXPERIENCE_BOTTLE")) {
            this.itemId = this.itemId.replace("EXPERIENCE_BOTTLE", "EXP_BOTTLE");
        }
        if (this.itemId.contains("END_STONE_GEODE")) {
            this.itemId = this.itemId.replace("END_STONE_GEODE", "ENDSTONE_GEODE");
        }
        if (itemId.contains("HEX_ITEM")) {
            this.itemType = ItemType.HEX_ITEM;
        }
        if ((bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(this.itemId)) != null && bazaarInfo.get("curr_buy") != null) {
            this.price = bazaarInfo.get("curr_buy").getAsInt();
        }
        if ("SIL_EX".equals(this.itemId)) {
            this.itemId = "SILEX";
        }
        if (itemName.contains("Amethyst Gemstone")) {
            this.itemType = ItemType.AMETHYST_GEMSTONE;
        }
        if (itemName.contains("Ruby Gemstone")) {
            this.itemType = ItemType.RUBY_GEMSTONE;
        }
        if (itemName.contains("Sapphire Gemstone")) {
            this.itemType = ItemType.SAPPHIRE_GEMSTONE;
        }
        if (itemName.contains("Jasper Gemstone")) {
            this.itemType = ItemType.JASPER_GEMSTONE;
        }
        if (itemName.contains("Jade Gemstone")) {
            this.itemType = ItemType.JADE_GEMSTONE;
        }
        if (itemName.contains("Amber Gemstone")) {
            this.itemType = ItemType.AMBER_GEMSTONE;
        }
        if (itemName.contains("Opal Gemstone")) {
            this.itemType = ItemType.OPAL_GEMSTONE;
        }
        if (itemName.contains("Topaz Gemstone")) {
            this.itemType = ItemType.TOPAZ_GEMSTONE;
        }
        if (itemName.contains("Onyx Gemstone")) {
            this.itemType = ItemType.ONYX_GEMSTONE;
        }
        if (itemName.contains("Aquamarine Gemstone")) {
            this.itemType = ItemType.AQUAMARINE_GEMSTONE;
        }
        if (itemName.contains("Citrine Gemstone")) {
            this.itemType = ItemType.CITRINE_GEMSTONE;
        }
        if (itemName.contains("Peridot Gemstone")) {
            this.itemType = ItemType.PERIDOT_GEMSTONE;
        }
        if (itemName.contains("Gemstone Slot")) {
            this.itemType = ItemType.GEMSTONE_SLOT;
        }
        if (this.itemName.contains(" Gemstone")) {
            this.itemName = this.itemName.replace(" Gemstone", "").substring(2);
        } else if (this.itemName.contains(" Experience Bottle")) {
            this.itemName = this.itemName.replace("Experience Bottle", "");
        } else if (this.itemName.equals("Experience Bottle")) {
            this.itemName = "Exp Bottle";
        }
        if (this.isGemstone()) {
            if (this.itemName.contains("Rough")) {
                this.gemstoneLevel = 0;
            }
            if (this.itemName.contains("Flawed")) {
                this.gemstoneLevel = 1;
            }
            if (this.itemName.contains("Fine")) {
                this.gemstoneLevel = 2;
            }
            if (this.itemName.contains("Flawless")) {
                this.gemstoneLevel = 3;
            }
            if (this.itemName.contains("Perfect")) {
                this.gemstoneLevel = 4;
            }
        }
    }

    public boolean isPowerScroll() {
        return this.itemType == ItemType.RUBY_SCROLL || this.itemType == ItemType.SAPPHIRE_SCROLL || this.itemType == ItemType.JASPER_SCROLL || this.itemType == ItemType.AMETHYST_SCROLL || this.itemType == ItemType.AMBER_SCROLL || this.itemType == ItemType.OPAL_SCROLL;
    }

    public boolean isDungeonStar() {
        return this.itemType == ItemType.FIRST_STAR || this.itemType == ItemType.SECOND_STAR || this.itemType == ItemType.THIRD_STAR || this.itemType == ItemType.FOURTH_STAR || this.itemType == ItemType.FIFTH_STAR;
    }

    public boolean isMasterStar() {
        return this.itemType == ItemType.FIRST_MASTER_STAR || this.itemType == ItemType.SECOND_MASTER_STAR || this.itemType == ItemType.THIRD_MASTER_STAR || this.itemType == ItemType.FOURTH_MASTER_STAR || this.itemType == ItemType.FIFTH_MASTER_STAR;
    }

    public String getReforge() {
        JsonObject reforgeInfo;
        JsonObject reforgeStones = Constants.REFORGESTONES;
        if (reforgeStones != null && reforgeStones.has(this.itemId.toUpperCase(Locale.ROOT)) && (reforgeInfo = reforgeStones.get(this.itemId.toUpperCase(Locale.ROOT)).getAsJsonObject()) != null) {
            return Utils.getElementAsString(reforgeInfo.get("reforgeName"), "");
        }
        return "";
    }

    public int getPrice() {
        if (this.itemType == ItemType.RANDOM_REFORGE) {
            for (String string : this.displayLore) {
                if (!string.contains("Coins")) continue;
                try {
                    this.price = Integer.parseInt(StringUtils.func_76338_a((String)string).replace(" Coins", "").replace(",", "").trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return this.price;
    }

    public boolean isHypeScroll() {
        return this.itemType == ItemType.IMPLOSION_SCROLL || this.itemType == ItemType.WITHER_SHIELD_SCROLL || this.itemType == ItemType.SHADOW_WARP_SCROLL;
    }

    public boolean isGemstone() {
        return this.itemType == ItemType.RUBY_GEMSTONE || this.itemType == ItemType.AMETHYST_GEMSTONE || this.itemType == ItemType.SAPPHIRE_GEMSTONE || this.itemType == ItemType.JASPER_GEMSTONE || this.itemType == ItemType.JADE_GEMSTONE || this.itemType == ItemType.AMBER_GEMSTONE || this.itemType == ItemType.OPAL_GEMSTONE || this.itemType == ItemType.TOPAZ_GEMSTONE || this.itemType == ItemType.ONYX_GEMSTONE || this.itemType == ItemType.AQUAMARINE_GEMSTONE || this.itemType == ItemType.CITRINE_GEMSTONE || this.itemType == ItemType.PERIDOT_GEMSTONE;
    }

    public boolean isEnrichment() {
        return this.itemType == ItemType.ENRICHMENT_DEFENSE || this.itemType == ItemType.ENRICHMENT_SCC || this.itemType == ItemType.ENRICHMENT_HEALTH || this.itemType == ItemType.ENRICHMENT_STRENGTH || this.itemType == ItemType.ENRICHMENT_SPEED || this.itemType == ItemType.ENRICHMENT_CRIT_DAMAGE || this.itemType == ItemType.ENRICHMENT_CRIT_CHANCE || this.itemType == ItemType.ENRICHMENT_ATTACK_SPEED || this.itemType == ItemType.ENRICHMENT_INTELLIGENCE || this.itemType == ItemType.ENRICHMENT_MAGIC_FIND || this.itemType == ItemType.ENRICHMENT_FEROCITY;
    }
}

