/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.world;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SpawnParticleEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.world.GenericBlockHighlighter;
import io.github.moulberry.notenoughupdates.util.MathUtil;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GlowingMushroomHighlighter
extends GenericBlockHighlighter {
    @SubscribeEvent
    public void onParticleSpawn(SpawnParticleEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getParticleTypes() == EnumParticleTypes.SPELL_MOB && MathUtil.isDecimalPartApproximately(event.getXCoord(), 0.5) && MathUtil.isDecimalPartApproximately(event.getYCoord(), 0.1) && MathUtil.isDecimalPartApproximately(event.getZCoord(), 0.5)) {
            this.tryRegisterInterest(event.getXCoord(), event.getYCoord(), event.getZCoord());
        }
    }

    @Override
    protected boolean isEnabled() {
        return "farming_1".equals(SBInfo.getInstance().getLocation()) && NotEnoughUpdates.INSTANCE.config.world.highlightGlowingMushrooms;
    }

    @Override
    protected boolean isValidHighlightSpot(BlockPos key) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return false;
        }
        Block b = w.func_180495_p(key).func_177230_c();
        return b == Blocks.field_150338_P || b == Blocks.field_150337_Q;
    }

    @Override
    protected int getColor(BlockPos blockPos) {
        return SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.world.glowingMushroomColor2);
    }
}

