/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.world;

import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class GenericBlockHighlighter {
    public final Set<BlockPos> highlightedBlocks = new HashSet<BlockPos>();

    protected abstract boolean isEnabled();

    protected abstract boolean isValidHighlightSpot(BlockPos var1);

    protected abstract int getColor(BlockPos var1);

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        for (BlockPos blockPos : this.highlightedBlocks) {
            RenderUtils.renderBoundingBox(blockPos, this.getColor(blockPos), event.partialTicks, true);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        this.highlightedBlocks.removeIf(it -> !this.isValidHighlightSpot((BlockPos)it) || !this.canPlayerSeeNearBlocks(it.func_177958_n(), it.func_177956_o(), it.func_177952_p()));
    }

    protected boolean canPlayerSeeBlock(double xCoord, double yCoord, double zCoord) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return false;
        }
        Vec3 playerPosition = new Vec3(p.field_70165_t, p.field_70163_u + (double)p.eyeHeight, p.field_70161_v);
        MovingObjectPosition hitResult = GenericBlockHighlighter.rayTraceBlocks(p.field_70170_p, playerPosition, xCoord + 0.5, yCoord + 0.5, zCoord + 0.5);
        return GenericBlockHighlighter.canSee(hitResult, new BlockPos(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5));
    }

    protected boolean canPlayerSeeNearBlocks(double x, double y, double z) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return false;
        }
        World world = p.field_70170_p;
        Vec3 playerPosition = new Vec3(p.field_70165_t, p.field_70163_u + (double)p.eyeHeight, p.field_70161_v);
        BlockPos blockPos = new BlockPos(x, y, z);
        MovingObjectPosition hitResult1 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x, y, z);
        if (GenericBlockHighlighter.canSee(hitResult1, blockPos)) {
            return true;
        }
        MovingObjectPosition hitResult2 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x + 1.0, y, z);
        if (GenericBlockHighlighter.canSee(hitResult2, blockPos.func_177982_a(1, 0, 1))) {
            return true;
        }
        MovingObjectPosition hitResult3 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x + 1.0, y + 1.0, z);
        if (GenericBlockHighlighter.canSee(hitResult3, blockPos.func_177982_a(1, 1, 0))) {
            return true;
        }
        MovingObjectPosition hitResult4 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x + 1.0, y + 1.0, z + 1.0);
        if (GenericBlockHighlighter.canSee(hitResult4, blockPos.func_177982_a(1, 1, 1))) {
            return true;
        }
        MovingObjectPosition hitResult5 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x, y + 1.0, z + 1.0);
        if (GenericBlockHighlighter.canSee(hitResult5, blockPos.func_177982_a(0, 1, 1))) {
            return true;
        }
        MovingObjectPosition hitResult6 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x, y + 1.0, z);
        if (GenericBlockHighlighter.canSee(hitResult6, blockPos.func_177982_a(0, 1, 0))) {
            return true;
        }
        MovingObjectPosition hitResult7 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x + 1.0, y, z + 1.0);
        if (GenericBlockHighlighter.canSee(hitResult7, blockPos.func_177982_a(1, 0, 1))) {
            return true;
        }
        MovingObjectPosition hitResult8 = GenericBlockHighlighter.rayTraceBlocks(world, playerPosition, x, y + 1.0, z);
        return GenericBlockHighlighter.canSee(hitResult8, blockPos.func_177982_a(0, 1, 0));
    }

    private static boolean canSee(MovingObjectPosition hitResult, BlockPos bp) {
        return hitResult == null || hitResult.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || bp.equals((Object)hitResult.func_178782_a());
    }

    private static MovingObjectPosition rayTraceBlocks(World world, Vec3 playerPosition, double x, double y, double z) {
        return world.func_147447_a(playerPosition, new Vec3(x, y, z), false, true, true);
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Unload event) {
        this.highlightedBlocks.clear();
    }

    public boolean tryRegisterInterest(BlockPos pos) {
        return this.tryRegisterInterest(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean tryRegisterInterest(double x, double y, double z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        boolean contains = this.highlightedBlocks.contains(blockPos);
        if (!contains) {
            boolean canSee = this.canPlayerSeeNearBlocks(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            if (this.isValidHighlightSpot(blockPos) && canSee) {
                this.highlightedBlocks.add(blockPos);
            }
        }
        return contains;
    }
}

