/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.world;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.world.GenericBlockHighlighter;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FrozenTreasuresHighlighter
extends GenericBlockHighlighter {
    private static final FrozenTreasuresHighlighter INSTANCE = new FrozenTreasuresHighlighter();
    private static final List<String> rideablePetTextureUrls = new ArrayList<String>(){
        {
            this.add("http://textures.minecraft.net/texture/c1eb6df4736ae24dd12a3d00f91e6e3aa7ade6bbefb0978afef2f0f92461018f");
            this.add("http://textures.minecraft.net/texture/cb2b5d48e57577563aca31735519cb622219bc058b1f34648b67b8e71bc0fa");
            this.add("http://textures.minecraft.net/texture/a8abb471db0ab78703011979dc8b40798a941f3a4dec3ec61cbeec2af8cffe8");
            this.add("http://textures.minecraft.net/texture/41b830eb4082acec836bc835e40a11282bb51193315f91184337e8d3555583");
        }
    };

    public static FrozenTreasuresHighlighter getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean isEnabled() {
        return SBInfo.getInstance().getScoreboardLocation().equals("Glacial Cave") && NotEnoughUpdates.INSTANCE.config.world.highlightFrozenTreasures;
    }

    @Override
    protected boolean isValidHighlightSpot(BlockPos key) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return false;
        }
        Block b = w.func_180495_p(key).func_177230_c();
        return b == Blocks.field_150432_aD;
    }

    @SubscribeEvent
    public void onTickNew(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !this.isEnabled()) {
            return;
        }
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        List entities = w.func_72910_y();
        for (Entity entity : entities) {
            if (!(entity instanceof EntityArmorStand) || ((EntityArmorStand)entity).func_82169_q(3) == null) continue;
            if (((EntityArmorStand)entity).func_82169_q(3).func_77942_o()) {
                NBTTagCompound nbtTagCompound = ((EntityArmorStand)entity).func_82169_q(3).func_77978_p();
                String textureValue = nbtTagCompound.func_74775_l("SkullOwner").func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
                String trimmedJson = new String(Base64.getDecoder().decode(textureValue.replace(";", ""))).replace(" ", "");
                String textureUrl = "";
                if (trimmedJson.contains("url")) {
                    textureUrl = trimmedJson.substring(trimmedJson.indexOf("url") + 6, trimmedJson.substring(trimmedJson.indexOf("url") + 6).indexOf("\"") + trimmedJson.indexOf("url") + 6);
                }
                if (rideablePetTextureUrls.contains(textureUrl)) continue;
                this.highlightedBlocks.add(entity.func_180425_c().func_177982_a(0, 1, 0));
                continue;
            }
            this.highlightedBlocks.add(entity.func_180425_c().func_177982_a(0, 1, 0));
        }
    }

    @Override
    protected int getColor(BlockPos blockPos) {
        return SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.world.frozenTreasuresColor2);
    }
}

