/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.BestiaryData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.Category;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.FamilyData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.Mob;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryPage;", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewerPage;", "instance", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;", "(Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;)V", "bestiaryLevel", "", "bestiaryTexture", "Lnet/minecraft/util/ResourceLocation;", "computedCategories", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/Category;", "lastProfileName", "", "mobListXCount", "", "mobListXPadding", "", "mobListYCount", "mobListYPadding", "selectedCategory", "selectedSubCategory", "tooltipToDisplay", "drawPage", "", "mouseX", "mouseY", "partialTicks", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nBestiaryPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BestiaryPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryPage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n223#2,2:426\n223#2,2:429\n1#3:428\n*S KotlinDebug\n*F\n+ 1 BestiaryPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryPage\n*L\n197#1:426,2\n315#1:429,2\n*E\n"})
public final class BestiaryPage
extends GuiProfileViewerPage {
    @NotNull
    private String selectedCategory = "dynamic";
    @NotNull
    private String selectedSubCategory = "";
    @NotNull
    private List<String> tooltipToDisplay = new ArrayList();
    private double bestiaryLevel;
    @NotNull
    private List<Category> computedCategories = new ArrayList();
    @NotNull
    private String lastProfileName = "";
    @NotNull
    private final ResourceLocation bestiaryTexture = new ResourceLocation("notenoughupdates:pv_bestiary_tab.png");
    private final int mobListXCount;
    private final int mobListYCount;
    private final float mobListXPadding = (float)(240 - this.mobListXCount * 20) / (float)(this.mobListXCount + 1);
    private final float mobListYPadding = (float)(202 - this.mobListYCount * 20) / (float)(this.mobListYCount + 1);

    public BestiaryPage(@Nullable GuiProfileViewer instance) {
        super(instance);
        this.mobListXCount = 9;
        this.mobListYCount = 5;
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        List<Mob> list;
        Object $this$first$iv;
        Object i2;
        Object object;
        Object element$iv2;
        Color color;
        int height;
        int width;
        int guiTop;
        int guiLeft;
        block38: {
            guiLeft = GuiProfileViewer.getGuiLeft();
            guiTop = GuiProfileViewer.getGuiTop();
            SkyblockProfiles.SkyblockProfile skyblockProfile = GuiProfileViewer.getSelectedProfile();
            if (skyblockProfile == null) {
                return;
            }
            SkyblockProfiles.SkyblockProfile selectedProfile = skyblockProfile;
            JsonObject jsonObject = selectedProfile.getProfileJson();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"selectedProfile.profileJson");
            JsonObject profileInfo2 = jsonObject;
            String profileName = GuiProfileViewer.getProfileName();
            if (!BestiaryData.INSTANCE.hasMigrated(profileInfo2) || Constants.BESTIARY == null) {
                Utils.drawStringCentered(EnumChatFormatting.RED + "No valid bestiary data!", (float)guiLeft + 215.5f, (float)(guiTop + 101), true, 0);
                Intrinsics.checkNotNullExpressionValue((Object)profileName, (String)"profileName");
                this.lastProfileName = profileName;
                return;
            }
            if (this.computedCategories.isEmpty() || !Intrinsics.areEqual((Object)this.lastProfileName, (Object)profileName)) {
                this.computedCategories = BestiaryData.parseBestiaryData(profileInfo2);
                this.bestiaryLevel = BestiaryData.calculateTotalBestiaryTiers(this.computedCategories);
            }
            if (this.computedCategories.isEmpty() || Constants.BESTIARY == null) {
                Utils.drawStringCentered(EnumChatFormatting.RED + "No valid bestiary data!", (float)guiLeft + 215.5f, (float)(guiTop + 101), true, 0);
                Intrinsics.checkNotNullExpressionValue((Object)profileName, (String)"profileName");
                this.lastProfileName = profileName;
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)profileName, (String)"profileName");
            this.lastProfileName = profileName;
            int bestiarySize = this.computedCategories.size();
            int bestiaryXSize = (int)(350.0f / ((float)(bestiarySize - 1) + 1.0E-7f));
            Iterator<Category> iterator = this.computedCategories.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int categoryXIndex = n++;
                Category category = iterator.next();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                if (mouseX > guiLeft + 30 + bestiaryXSize * categoryXIndex && mouseX < guiLeft + 30 + bestiaryXSize * categoryXIndex + 20 && mouseY > guiTop + 10 && mouseY < guiTop + 10 + 20) {
                    this.tooltipToDisplay.add(EnumChatFormatting.GRAY.toString() + category.getName());
                    if (Mouse.getEventButtonState() && !Intrinsics.areEqual((Object)this.selectedCategory, (Object)category.getId())) {
                        this.selectedCategory = category.getId();
                        Utils.playPressSound();
                    }
                }
                if (Intrinsics.areEqual((Object)category.getId(), (Object)this.selectedCategory)) {
                    Utils.drawTexturedRect(guiLeft + 30 + bestiaryXSize * categoryXIndex, guiTop + 10, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
                } else {
                    Utils.drawTexturedRect(guiLeft + 30 + bestiaryXSize * categoryXIndex, guiTop + 10, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                }
                Utils.drawItemStack(category.getIcon(), guiLeft + 32 + bestiaryXSize * categoryXIndex, guiTop + 12);
            }
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bestiaryTexture);
            Utils.drawTexturedRect(guiLeft, guiTop, 431.0f, 202.0f, 9728);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            color = new Color(128, 128, 128, 255);
            Utils.renderAlignedString(EnumChatFormatting.RED.toString() + "Milestone: ", "" + EnumChatFormatting.GRAY + this.bestiaryLevel / (double)10, guiLeft + 280, guiTop + 50, 110);
            Iterable $this$first$iv2 = this.computedCategories;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv2) {
                Category it = (Category)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.selectedCategory)) continue;
                break block38;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Category selectedCategory = (Category)element$iv2;
        if (!((Collection)selectedCategory.getSubCategories()).isEmpty()) {
            if (Intrinsics.areEqual((Object)this.selectedSubCategory, (Object)"")) {
                this.selectedSubCategory = ((Category)CollectionsKt.first(selectedCategory.getSubCategories())).getId();
            }
            Utils.renderShadowedString(EnumChatFormatting.RED + "Subcategories", (float)(guiLeft + 317), (float)(guiTop + 165), 1000);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float xStart = guiLeft + 280;
            float y = guiTop + 175;
            object = selectedCategory.getSubCategories().iterator();
            int element$iv2 = 0;
            while (object.hasNext()) {
                int i2 = element$iv2++;
                Category subCategory = (Category)object.next();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                if (Intrinsics.areEqual((Object)subCategory.getId(), (Object)this.selectedSubCategory)) {
                    Utils.drawTexturedRect(xStart + (float)24 * (float)i2, y, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
                } else {
                    Utils.drawTexturedRect(xStart + (float)24 * (float)i2, y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                }
                Utils.drawItemStack(subCategory.getIcon(), (int)(xStart + (float)(24 * i2) + (float)2), (int)y + 2);
                if (!((float)mouseX > xStart + (float)(24 * i2)) || !((float)mouseX < xStart + (float)(24 * (i2 + 1))) || !((float)mouseY > y) || !((float)mouseY < y + (float)16)) continue;
                this.tooltipToDisplay.add(subCategory.getName());
                if (!Mouse.getEventButtonState() || Intrinsics.areEqual((Object)this.selectedSubCategory, (Object)subCategory.getId())) continue;
                this.selectedSubCategory = subCategory.getId();
                Utils.playPressSound();
            }
        } else {
            this.selectedSubCategory = "";
        }
        FamilyData catData = selectedCategory.getFamilyData();
        Utils.renderAlignedString(EnumChatFormatting.RED.toString() + "Families Found:", (catData.getFound() == catData.getTotal() ? "\u00a76" : "\u00a77") + catData.getFound() + '/' + catData.getTotal(), (float)guiLeft + 280.0f, (float)guiTop + 70.0f, 110);
        if (catData.getFound() == catData.getTotal()) {
            this.getInstance().renderGoldBar((float)guiLeft + 280.0f, (float)guiTop + 80.0f, 112.0f);
        } else {
            this.getInstance().renderBar((float)guiLeft + 280.0f, (float)guiTop + 80.0f, 112.0f, (float)catData.getFound() / (float)catData.getTotal());
        }
        Utils.renderAlignedString(EnumChatFormatting.RED.toString() + "Families Completed:", (catData.getCompleted() == catData.getTotal() ? "\u00a76" : "\u00a77") + catData.getCompleted() + '/' + catData.getTotal(), (float)guiLeft + 280.0f, (float)guiTop + 90.0f, 110);
        if (catData.getCompleted() == catData.getTotal()) {
            this.getInstance().renderGoldBar((float)guiLeft + 280.0f, (float)guiTop + 100.0f, 112.0f);
        } else {
            this.getInstance().renderBar((float)guiLeft + 280.0f, (float)guiTop + 100.0f, 112.0f, (float)catData.getCompleted() / (float)catData.getTotal());
        }
        if (!Intrinsics.areEqual((Object)this.selectedSubCategory, (Object)"")) {
            Object object2;
            block39: {
                object = selectedCategory.getSubCategories();
                Iterator element$iv2 = object.iterator();
                while (element$iv2.hasNext()) {
                    i2 = element$iv2.next();
                    Category it = (Category)i2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.selectedSubCategory)) continue;
                    object2 = i2;
                    break block39;
                }
                object2 = null;
            }
            Intrinsics.checkNotNull(object2);
            catData = ((Category)object2).getFamilyData();
            Utils.renderAlignedString(EnumChatFormatting.RED.toString() + "Families Found:", (catData.getFound() == catData.getTotal() ? "\u00a76" : "\u00a77") + catData.getFound() + '/' + catData.getTotal(), (float)guiLeft + 280.0f, (float)guiTop + 120.0f, 110);
            if (catData.getFound() == catData.getTotal()) {
                this.getInstance().renderGoldBar((float)guiLeft + 280.0f, (float)guiTop + 130.0f, 112.0f);
            } else {
                this.getInstance().renderBar((float)guiLeft + 280.0f, (float)guiTop + 130.0f, 112.0f, (float)catData.getFound() / (float)catData.getTotal());
            }
            Utils.renderAlignedString(EnumChatFormatting.RED.toString() + "Families Completed:", (catData.getCompleted() == catData.getTotal() ? "\u00a76" : "\u00a77") + catData.getCompleted() + '/' + catData.getTotal(), (float)guiLeft + 280.0f, (float)guiTop + 140.0f, 110);
            if (catData.getCompleted() == catData.getTotal()) {
                this.getInstance().renderGoldBar((float)guiLeft + 280.0f, (float)guiTop + 150.0f, 112.0f);
            } else {
                this.getInstance().renderBar((float)guiLeft + 280.0f, (float)guiTop + 150.0f, 112.0f, (float)catData.getCompleted() / (float)catData.getTotal());
            }
        }
        if (!Intrinsics.areEqual((Object)this.selectedSubCategory, (Object)"")) {
            Object element$iv3;
            block40: {
                $this$first$iv = selectedCategory.getSubCategories();
                boolean $i$f$first = false;
                i2 = $this$first$iv.iterator();
                while (i2.hasNext()) {
                    element$iv3 = i2.next();
                    Category it = (Category)element$iv3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.selectedSubCategory)) continue;
                    break block40;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            list = ((Category)element$iv3).getMobs();
        } else {
            list = selectedCategory.getMobs();
        }
        List<Mob> mobs = list;
        $this$first$iv = mobs.iterator();
        int n = 0;
        while ($this$first$iv.hasNext()) {
            int i3 = n++;
            Mob mob = (Mob)$this$first$iv.next();
            ItemStack stack = mob.getIcon();
            int xIndex = i3 % this.mobListXCount;
            int yIndex = i3 / this.mobListXCount;
            float x = (float)23 + this.mobListXPadding + (this.mobListXPadding + (float)20) * (float)xIndex;
            float y = (float)30 + this.mobListYPadding + (this.mobListYPadding + (float)20) * (float)yIndex;
            GlStateManager.func_179140_f();
            RenderHelper.func_74520_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            Utils.drawItemStack(stack, guiLeft + (int)x + 2, guiTop + (int)y + 2);
            double kills = mob.getKills();
            double deaths = mob.getDeaths();
            if (mouseX > guiLeft + (int)x + 2 && mouseX < guiLeft + (int)x + 18 && mouseY > guiTop + (int)y + 2 && mouseY < guiTop + (int)y + 18) {
                String col;
                int j;
                String bar;
                this.tooltipToDisplay = new ArrayList();
                this.tooltipToDisplay.add(mob.getName() + ' ' + mob.getMobLevelData().getLevel());
                this.tooltipToDisplay.add(EnumChatFormatting.GRAY.toString() + "Kills: " + EnumChatFormatting.GREEN + StringUtils.formatNumber(kills));
                this.tooltipToDisplay.add(EnumChatFormatting.GRAY.toString() + "Deaths: " + EnumChatFormatting.GREEN + StringUtils.formatNumber(deaths));
                this.tooltipToDisplay.add("");
                if (!mob.getMobLevelData().getMaxLevel()) {
                    this.tooltipToDisplay.add(EnumChatFormatting.GRAY.toString() + "Progress to Tier " + (mob.getMobLevelData().getLevel() + 1) + ": " + EnumChatFormatting.AQUA + mob.getMobLevelData().getProgress() + '%');
                    bar = "\u00a73\u00a7l\u00a7m";
                    for (j = 1; j < 15; ++j) {
                        col = "";
                        if (mob.getMobLevelData().getProgress() < (double)(j * 7)) {
                            col = "\u00a7f\u00a7l\u00a7m";
                        }
                        bar = bar + col + ' ';
                    }
                    this.tooltipToDisplay.add(bar + "\u00a7r\u00a7b " + StringUtils.formatNumber(mob.getMobLevelData().getMobKillData().getTierKills()) + '/' + StringUtils.formatNumber(mob.getMobLevelData().getMobKillData().getTierReq()));
                    this.tooltipToDisplay.add("");
                }
                this.tooltipToDisplay.add(EnumChatFormatting.GRAY.toString() + "Overall Progress: " + EnumChatFormatting.AQUA + mob.getMobLevelData().getTotalProgress() + '%' + (mob.getMobLevelData().getMaxLevel() ? " \u00a77(\u00a7c\u00a7lMAX!\u00a7r\u00a77)" : ""));
                bar = "\u00a73\u00a7l\u00a7m";
                for (j = 1; j < 15; ++j) {
                    col = "";
                    if (mob.getMobLevelData().getTotalProgress() < (double)(j * 7)) {
                        col = "\u00a7f\u00a7l\u00a7m";
                    }
                    bar = bar + col + ' ';
                }
                this.tooltipToDisplay.add(bar + "\u00a7r\u00a7b " + StringUtils.formatNumber(mob.getMobLevelData().getMobKillData().getCappedKills()) + '/' + StringUtils.formatNumber(mob.getMobLevelData().getMobKillData().getCap()));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawStringCentered(mob.getMobLevelData().getMaxLevel() ? "" + EnumChatFormatting.GOLD + mob.getMobLevelData().getLevel() : String.valueOf(mob.getMobLevelData().getLevel()), (float)guiLeft + x + (float)10, (float)guiTop + y + (float)26, true, color.getRGB());
        }
        if (!((Collection)this.tooltipToDisplay).isEmpty()) {
            List grayTooltip = new ArrayList(this.tooltipToDisplay.size());
            for (String line : this.tooltipToDisplay) {
                grayTooltip.add(EnumChatFormatting.GRAY.toString() + line);
            }
            Utils.drawHoveringText(grayTooltip, mouseX, mouseY, width, height, -1);
            this.tooltipToDisplay.clear();
        }
    }
}

