/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GuiElement;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.core.util.render.TextRenderUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class PresetWarning
extends GuiElement {
    private static final PresetWarning INSTANCE = new PresetWarning();
    private boolean showWarning = false;
    private String presetName = null;
    private int presetSlot = -1;

    public static PresetWarning getInstance() {
        return INSTANCE;
    }

    private boolean shouldPerformCheck() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            this.showWarning = false;
            return false;
        }
        if (Utils.getOpenChestName().startsWith("Plot Modification: ")) {
            return true;
        }
        this.showWarning = false;
        return false;
    }

    public boolean shouldShow() {
        return this.shouldPerformCheck() && this.showWarning;
    }

    @SubscribeEvent
    public void onMouseClick(SlotClickEvent event) {
        if (!this.shouldPerformCheck()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.garden.presetDeleteWarning) {
            return;
        }
        if (event.slotId == -999) {
            return;
        }
        if (event.clickedButton == 0) {
            return;
        }
        GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ItemStack clickedPreset = chest.field_147002_h.func_75139_a(event.slotId).func_75211_c();
        if (clickedPreset == null) {
            return;
        }
        List<String> list = ItemUtils.getLore(clickedPreset);
        if (list.isEmpty()) {
            return;
        }
        String last = list.get(list.size() - 1);
        if (last.contains("Right-Click to delete!")) {
            this.showWarning = true;
            this.presetName = clickedPreset.func_82833_r();
            this.presetSlot = event.slotId;
            event.setCanceled(true);
        }
    }

    public void overrideIsMouseOverSlot(Slot slot, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (this.shouldShow()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void render() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        Gui.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)Integer.MIN_VALUE);
        RenderUtils.drawFloatingRectDark(width / 2 - 90, height / 2 - 45, 180, 90);
        int neuLength = Minecraft.func_71410_x().field_71466_p.func_78256_a("\u00a7lNEU");
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a7lNEU", width / 2 + 90 - neuLength - 3, height / 2 - 45 + 4, -16777216);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Are you SURE?", Minecraft.func_71410_x().field_71466_p, width / 2, height / 2 - 45 + 10, false, 170, -49088);
        String sellLine = "\u00a77[ \u00a7r" + this.presetName + "\u00a77 ]";
        TextRenderUtils.drawStringCenteredScaledMaxWidth(sellLine, Minecraft.func_71410_x().field_71466_p, width / 2, height / 2 - 45 + 25, false, 170, -1);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Continue removing this preset?", Minecraft.func_71410_x().field_71466_p, width / 2, height / 2 - 45 + 50, false, 170, -6250336);
        RenderUtils.drawFloatingRectDark(width / 2 - 43, height / 2 + 23, 40, 16, false);
        RenderUtils.drawFloatingRectDark(width / 2 + 3, height / 2 + 23, 40, 16, false);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.GREEN + "[Y]es", Minecraft.func_71410_x().field_71466_p, width / 2 - 23, height / 2 + 31, true, 36, -16711936);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.RED + "[N]o", Minecraft.func_71410_x().field_71466_p, width / 2 + 23, height / 2 + 31, true, 36, -65536);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        if (Mouse.getEventButtonState()) {
            if (mouseY >= height / 2 + 23 && mouseY <= height / 2 + 23 + 16) {
                if (mouseX >= width / 2 - 43 && mouseX <= width / 2 - 3) {
                    this.makeClick();
                }
                this.showWarning = false;
            }
            if (mouseX < width / 2 - 90 || mouseX > width / 2 + 90 || mouseY < height / 2 - 45 || mouseY > height / 2 + 45) {
                this.showWarning = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (!Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 21 || Keyboard.getEventKey() == 28) {
                this.makeClick();
            }
            this.showWarning = false;
        }
        return false;
    }

    private void makeClick() {
        if (this.presetSlot != -1) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, this.presetSlot, 1, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.presetSlot = -1;
        }
    }
}

