/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class NPCRetexturing
implements IResourceManagerReloadListener {
    private static final NPCRetexturing INSTANCE = new NPCRetexturing();
    private static final ResourceLocation npcRetexturingJson = new ResourceLocation("notenoughupdates:npccustomtextures/config.json");
    private final Gson gson = new GsonBuilder().create();
    private final HashMap<AbstractClientPlayer, Skin> skinOverrideCache = new HashMap();
    private final HashMap<String, Skin> skinMap = new HashMap();
    private boolean gettingSkin = false;

    public Skin getSkin(AbstractClientPlayer player) {
        if (this.gettingSkin) {
            return null;
        }
        if (player.func_110124_au().version() == 4 && !NotEnoughUpdates.INSTANCE.config.hidden.npcRetextureOnSelf) {
            return null;
        }
        if (this.skinOverrideCache.containsKey(player)) {
            return this.skinOverrideCache.get(player);
        }
        this.gettingSkin = true;
        ResourceLocation loc = player.func_110306_p();
        this.gettingSkin = false;
        if (this.skinMap.containsKey(loc.func_110623_a()) && !NotEnoughUpdates.INSTANCE.config.misc.disableNPCRetexturing) {
            Skin skin = this.skinMap.get(loc.func_110623_a());
            this.skinOverrideCache.put(player, skin);
            return skin;
        }
        this.skinOverrideCache.put(player, null);
        return null;
    }

    public void tick() {
        this.skinOverrideCache.clear();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.skinMap.clear();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(npcRetexturingJson).func_110527_b(), StandardCharsets.UTF_8));){
            JsonObject json = this.gson.fromJson((Reader)reader, JsonObject.class);
            if (json == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                if (!entry.getValue().isJsonObject()) continue;
                JsonObject val = entry.getValue().getAsJsonObject();
                Skin skin = new Skin(new ResourceLocation(val.get("skin").getAsString()), val.get("skinny").getAsBoolean());
                this.skinMap.put("skins/" + entry.getKey(), skin);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NPCRetexturing getInstance() {
        return INSTANCE;
    }

    public static class Skin {
        public ResourceLocation skinLocation;
        public boolean skinny;

        public Skin(ResourceLocation skinLocation, boolean skinny) {
            this.skinLocation = skinLocation;
            this.skinny = skinny;
        }
    }
}

