/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.WarningPopUp;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\f\u00a8\u0006#"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/HexPriceWarning;", "Lio/github/moulberry/notenoughupdates/miscfeatures/WarningPopUp;", "()V", "coins", "Ljava/util/regex/Pattern;", "getCoins", "()Ljava/util/regex/Pattern;", "cost", "", "getCost", "()Ljava/lang/String;", "setCost", "(Ljava/lang/String;)V", "lastClickedSlot", "", "getLastClickedSlot", "()I", "setLastClickedSlot", "(I)V", "upgradeName", "getUpgradeName", "setUpgradeName", "confirmClick", "", "getItemName", "getLimit", "", "getWarningLines", "", "onClick", "event", "Lio/github/moulberry/notenoughupdates/events/SlotClickEvent;", "shouldCheck", "", "shouldShow", "NotEnoughUpdates"})
public final class HexPriceWarning
extends WarningPopUp {
    @NotNull
    public static final HexPriceWarning INSTANCE = new HexPriceWarning();
    private static int lastClickedSlot;
    @NotNull
    private static String cost;
    @NotNull
    private static String upgradeName;
    @NotNull
    private static final Pattern coins;

    private HexPriceWarning() {
    }

    public final boolean shouldCheck() {
        return this.getLimit() >= 1.0;
    }

    public final double getLimit() {
        return NotEnoughUpdates.INSTANCE.config.enchantingSolvers.hexOverpayWarning;
    }

    public final int getLastClickedSlot() {
        return lastClickedSlot;
    }

    public final void setLastClickedSlot(int n) {
        lastClickedSlot = n;
    }

    @NotNull
    public final String getCost() {
        return cost;
    }

    public final void setCost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        cost = string;
    }

    @NotNull
    public final String getUpgradeName() {
        return upgradeName;
    }

    public final void setUpgradeName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        upgradeName = string;
    }

    @Override
    public boolean shouldShow() {
        return this.shouldCheck() && super.shouldShow();
    }

    @Override
    @NotNull
    public String getItemName() {
        return upgradeName;
    }

    @Override
    @NotNull
    public List<String> getWarningLines() {
        return CollectionsKt.listOf((Object)("will cost you \u00a76" + cost + "\u00a7r coins"));
    }

    @Override
    public void confirmClick() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        Intrinsics.checkNotNull((Object)guiScreen, (String)"null cannot be cast to non-null type net.minecraft.client.gui.inventory.GuiChest");
        GuiChest chest = (GuiChest)guiScreen;
        Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, lastClickedSlot, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @SubscribeEvent
    public final void onClick(@NotNull SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        if (!this.shouldCheck()) {
            return;
        }
        if (this.isShowing()) {
            return;
        }
        ItemStack itemStack = event.slot.func_75211_c();
        if (itemStack == null) {
            return;
        }
        ItemStack stack = itemStack;
        List<String> list = ItemUtils.getLore(stack);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLore(stack)");
        List<String> lore = list;
        int bazaarPriceLine = lore.indexOf("\u00a77Bazaar Price");
        if (bazaarPriceLine >= 0) {
            int n = lore.size();
            int n2 = bazaarPriceLine + 1;
            boolean bl = 0 <= n2 ? n2 < n : false;
            if (bl) {
                String string = lore.get(bazaarPriceLine + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lore[bazaarPriceLine + 1]");
                String priceLine = string;
                Matcher priceMatcher = coins.matcher(priceLine);
                if (!priceMatcher.matches()) {
                    return;
                }
                String string2 = priceMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"priceMatcher.group(1)");
                double price = Double.parseDouble(StringsKt.replace$default((String)string2, (String)",", (String)"", (boolean)false, (int)4, null));
                if (price >= this.getLimit()) {
                    lastClickedSlot = event.slotId;
                    String string3 = priceMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"priceMatcher.group(1)");
                    cost = string3;
                    String string4 = ItemUtils.getDisplayName(stack.func_77978_p());
                    if (string4 == null) {
                        string4 = "<unnamed upgrade>";
                    }
                    upgradeName = string4;
                    this.show();
                    event.cancel();
                }
            }
        }
    }

    @NotNull
    public final Pattern getCoins() {
        return coins;
    }

    static {
        cost = "";
        upgradeName = "";
        String string = "\u00a76([,.0-9]+) Coins";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(this, flags)");
        coins = pattern;
    }
}

