/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.Tuple;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GardenNpcPrices {
    private final Pattern itemRegex = Pattern.compile("\u00a75\u00a7o \u00a7.([a-zA-Z \\-]+)(?:\u00a78x(\\d+))?");
    private final Gson gson = new GsonBuilder().create();
    private final Pattern copperRegex = Pattern.compile(".* \u00a78\\+\u00a7c(\\d+) Copper.*");
    private Map<List<String>, List<String>> prices = new HashMap<List<String>, List<String>>();
    private Map<String, SkyMartItem> skymart = null;

    @SubscribeEvent
    public void onRepoReload(RepositoryReloadEvent reload) {
        this.skymart = (Map)this.gson.fromJson((JsonElement)Utils.getConstant("skymart", NotEnoughUpdates.INSTANCE.manager.gson), new TypeToken<Map<String, SkyMartItem>>(){}.getType());
    }

    @SubscribeEvent
    public void onGardenNpcPrices(ItemTooltipEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.gardenNpcPrice) {
            return;
        }
        if (event.toolTip.size() <= 2 || event.itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150406_ce)) {
            return;
        }
        ArrayList tooltipCopy = new ArrayList(event.toolTip);
        if (this.prices.get(tooltipCopy) == null) {
            for (int i = 2; i < event.toolTip.size(); ++i) {
                Matcher matcher = this.itemRegex.matcher((CharSequence)event.toolTip.get(i));
                if (matcher.matches()) {
                    int amount = 1;
                    if (matcher.group(2) != null) {
                        amount = Integer.parseInt(matcher.group(2));
                    }
                    double cost = this.calculateCost(ItemResolutionQuery.findInternalNameByDisplayName(matcher.group(1).trim(), false), amount);
                    event.toolTip.set(i, (String)event.toolTip.get(i) + " \u00a77(\u00a76" + (cost == 0.0 ? "?" : Utils.shortNumberFormat(cost, 0)) + "\u00a77 coins)");
                    continue;
                }
                if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.copperCoins) {
                    Matcher copperMatcher = this.copperRegex.matcher((CharSequence)event.toolTip.get(i));
                    if (!copperMatcher.matches()) continue;
                    int amount = Integer.parseInt(copperMatcher.group(1));
                    Tuple<String, Double> copperMax = this.calculateCopper(amount);
                    event.toolTip.set(i, (String)event.toolTip.get(i) + " \u00a77(\u00a76" + Utils.shortNumberFormat((Double)copperMax.func_76340_b(), 0) + "\u00a77 selling " + (String)copperMax.func_76341_a() + "\u00a77)");
                    continue;
                }
                this.prices.put(tooltipCopy, event.toolTip);
            }
        } else {
            event.toolTip.clear();
            event.toolTip.addAll((Collection)this.prices.get(tooltipCopy));
        }
    }

    public Tuple<String, Double> calculateCopper(int amount) {
        if (this.skymart == null) {
            return new Tuple((Object)"NEU REPO error", (Object)0.0);
        }
        HashMap<String, Double> prices = new HashMap<String, Double>();
        for (Map.Entry<String, SkyMartItem> entry : this.skymart.entrySet()) {
            boolean isBazaar;
            String internalName = entry.getKey();
            SkyMartItem item = entry.getValue();
            if (!Objects.equals(item.currency, "copper")) continue;
            boolean bl = isBazaar = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(internalName) != null;
            if (!isBazaar && (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.ignoreAllAHItems || item.price <= NotEnoughUpdates.INSTANCE.config.tooltipTweaks.AHPriceIgnoreThreshold)) continue;
            double price = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarOrBin(internalName, false) / item.price * (double)amount;
            prices.put(item.display, price);
        }
        if (prices.isEmpty()) {
            return new Tuple((Object)"NEU REPO error", (Object)0.0);
        }
        Map.Entry maxPrice = Collections.max(prices.entrySet(), Map.Entry.comparingByValue());
        return new Tuple(maxPrice.getKey(), maxPrice.getValue());
    }

    public double calculateCost(String internalName, int amount) {
        double price = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarOrBin(internalName, false);
        if (price != -1.0) {
            return price * (double)amount;
        }
        return 0.0;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.prices.clear();
    }

    public class SkyMartItem {
        String currency;
        double price;
        String display;

        public String getCurrency() {
            return this.currency;
        }

        public double getPrice() {
            return this.price;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkyMartItem)) {
                return false;
            }
            SkyMartItem other = (SkyMartItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$display = this.getDisplay();
            String other$display = other.getDisplay();
            return !(this$display == null ? other$display != null : !this$display.equals(other$display));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SkyMartItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            long $price = Double.doubleToLongBits(this.getPrice());
            result2 = result2 * 59 + (int)($price >>> 32 ^ $price);
            String $currency = this.getCurrency();
            result2 = result2 * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $display = this.getDisplay();
            result2 = result2 * 59 + ($display == null ? 43 : $display.hashCode());
            return result2;
        }

        public String toString() {
            return "GardenNpcPrices.SkyMartItem(currency=" + this.getCurrency() + ", price=" + this.getPrice() + ", display=" + this.getDisplay() + ")";
        }
    }
}

