/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DefaultArmorColour {
    private static Map<String, Integer> armorColourCache = new HashMap<String, Integer>();
    private static Set<String> erroredItems = new HashSet<String>();

    public static int getDefaultArmorColour(ItemArmor item, ItemStack stack) {
        JsonObject itemJson = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveToItemListJson();
        if (itemJson == null) {
            return item.func_82814_b(stack);
        }
        String internalname = itemJson.get("internalname").getAsString();
        if (armorColourCache.containsKey(internalname)) {
            return armorColourCache.get(internalname);
        }
        if (erroredItems.contains(internalname)) {
            return item.func_82814_b(stack);
        }
        if (itemJson.has("nbttag")) {
            try {
                int colour;
                NBTTagCompound display;
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)itemJson.get("nbttag").getAsString());
                if (nbt.func_74764_b("display") && (display = nbt.func_74775_l("display")).func_74764_b("color") && (colour = display.func_74762_e("color")) != 0) {
                    armorColourCache.put(internalname, colour);
                    return colour;
                }
            }
            catch (NBTException exception) {
                erroredItems.add(internalname);
                System.out.println("[NEU] Ran into NBTException whilst converting Json into NBT with the JsonObject: " + itemJson);
                exception.printStackTrace();
            }
        }
        return item.func_82814_b(stack);
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Unload event) {
        armorColourCache.clear();
    }
}

