/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BetterContainers {
    private static final ResourceLocation TOGGLE_OFF = new ResourceLocation("notenoughupdates:dynamic_54/toggle_off.png");
    private static final ResourceLocation TOGGLE_ON = new ResourceLocation("notenoughupdates:dynamic_54/toggle_on.png");
    private static final ResourceLocation DYNAMIC_54_BASE = new ResourceLocation("notenoughupdates:dynamic_54/style1/dynamic_54.png");
    private static final ResourceLocation DYNAMIC_54_SLOT = new ResourceLocation("notenoughupdates:dynamic_54/style1/dynamic_54_slot_ctm.png");
    private static final ResourceLocation DYNAMIC_54_BUTTON = new ResourceLocation("notenoughupdates:dynamic_54/style1/dynamic_54_button_ctm.png");
    private static final ResourceLocation rl = new ResourceLocation("notenoughupdates:dynamic_chest_inventory.png");
    private static boolean loaded = false;
    private static DynamicTexture texture = null;
    private static int textColour = 0x404040;
    private static int lastClickedSlot = 0;
    private static int clickedSlot = 0;
    private static long clickedSlotMillis = 0L;
    public static long lastRenderMillis = 0L;
    private static int lastInvHashcode = 0;
    private static final int lastHashcodeCheck = 0;
    static BufferedImage bufferedImageOn = null;
    static BufferedImage bufferedImageOff = null;
    static BufferedImage bufferedImageBase = null;
    static BufferedImage bufferedImageSlot = null;
    static BufferedImage bufferedImageButton = null;
    static List<Slot> lastSlots = null;

    public static void clickSlot(int slot) {
        clickedSlotMillis = System.currentTimeMillis();
        clickedSlot = slot;
    }

    public static int getClickedSlot() {
        if (System.currentTimeMillis() - clickedSlotMillis < 500L) {
            return clickedSlot;
        }
        return -1;
    }

    public static void bindHook(TextureManager textureManager, ResourceLocation location) {
        long currentMillis = System.currentTimeMillis();
        if (BetterContainers.isChestOpen()) {
            int invHashcode = lastInvHashcode;
            if (currentMillis - 0L > 50L) {
                Container container = ((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
                invHashcode = container.func_75138_a().hashCode();
            }
            if (texture != null && lastClickedSlot != BetterContainers.getClickedSlot() || !loaded || lastInvHashcode != invHashcode) {
                lastInvHashcode = invHashcode;
                lastClickedSlot = BetterContainers.getClickedSlot();
                BetterContainers.generateTex();
            }
            if (texture != null && loaded) {
                lastRenderMillis = currentMillis;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                textureManager.func_110579_a(rl, (ITextureObject)texture);
                textureManager.func_110577_a(rl);
                return;
            }
        } else if (currentMillis - lastRenderMillis < 200L && texture != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            textureManager.func_110579_a(rl, (ITextureObject)texture);
            textureManager.func_110577_a(rl);
            return;
        }
        GlStateManager.func_179147_l();
        textureManager.func_110577_a(location);
    }

    public static boolean isBlacklistedInventory() {
        if (!BetterContainers.isChestOpen()) {
            return false;
        }
        GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
        String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
        return containerName.toLowerCase(Locale.ROOT).trim().startsWith("navigate the maze");
    }

    public static boolean isOverriding() {
        return BetterContainers.isChestOpen() && (loaded && texture != null || System.currentTimeMillis() - lastRenderMillis < 200L) && !BetterContainers.isBlacklistedInventory();
    }

    public static boolean isBlankStack(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) && stack.func_77952_i() == 15 && stack.func_82833_r() != null && stack.func_82833_r().trim().isEmpty();
    }

    public static boolean shouldRenderStack(int index, ItemStack stack) {
        return !BetterContainers.isBlankStack(index, stack) && !BetterContainers.isToggleOff(stack) && !BetterContainers.isToggleOn(stack);
    }

    public static boolean isButtonStack(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co) && NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack) == null && !BetterContainers.isToggleOn(stack) && !BetterContainers.isToggleOff(stack);
    }

    public static int getTextColour() {
        return textColour;
    }

    public static boolean isToggleOn(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("display", 10) && stack.func_77978_p().func_74775_l("display").func_150297_b("Lore", 9)) {
            NBTTagList lore = stack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
            return lore.func_74745_c() == 1 && lore.func_150307_f(0).equalsIgnoreCase(EnumChatFormatting.GRAY + "click to disable!");
        }
        return false;
    }

    public static boolean isToggleOff(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("display", 10) && stack.func_77978_p().func_74775_l("display").func_150297_b("Lore", 9)) {
            NBTTagList lore = stack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
            return lore.func_74745_c() == 1 && lore.func_150307_f(0).equalsIgnoreCase(EnumChatFormatting.GRAY + "click to enable!");
        }
        return false;
    }

    private static void generateBufferedImages() {
        try {
            int backgroundStyle = NotEnoughUpdates.INSTANCE.config.improvedSBMenu.backgroundStyle + 1;
            backgroundStyle = Math.max(1, Math.min(10, backgroundStyle));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:dynamic_54/style" + backgroundStyle + "/dynamic_config.json")).func_110527_b(), StandardCharsets.UTF_8));){
                JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)reader, JsonObject.class);
                String textColourS = json.get("text-colour").getAsString();
                textColour = (int)Long.parseLong(textColourS, 16);
            }
            catch (Exception e2) {
                textColour = 0x404040;
            }
            bufferedImageOn = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TOGGLE_ON).func_110527_b());
            bufferedImageOff = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TOGGLE_OFF).func_110527_b());
            bufferedImageBase = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(DYNAMIC_54_BASE).func_110527_b());
            bufferedImageSlot = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(DYNAMIC_54_SLOT).func_110527_b());
            bufferedImageButton = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(DYNAMIC_54_BUTTON).func_110527_b());
            try {
                bufferedImageBase = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:dynamic_54/style" + backgroundStyle + "/dynamic_54.png")).func_110527_b());
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                int buttonStyle = NotEnoughUpdates.INSTANCE.config.improvedSBMenu.buttonStyle + 1;
                buttonStyle = Math.max(1, Math.min(10, buttonStyle));
                bufferedImageSlot = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:dynamic_54/style" + buttonStyle + "/dynamic_54_slot_ctm.png")).func_110527_b());
            }
            catch (Exception buttonStyle) {
                // empty catch block
            }
            try {
                int buttonStyle = NotEnoughUpdates.INSTANCE.config.improvedSBMenu.buttonStyle + 1;
                buttonStyle = Math.max(1, Math.min(10, buttonStyle));
                bufferedImageButton = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:dynamic_54/style" + buttonStyle + "/dynamic_54_button_ctm.png")).func_110527_b());
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void generateTex() {
        if (!BetterContainers.hasItem()) {
            return;
        }
        loaded = true;
        Container container = ((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
        List inventorySlots = ((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h.field_75151_b;
        if (BetterContainers.hasNullPane() && container instanceof ContainerChest) {
            if (lastSlots != inventorySlots) {
                BetterContainers.generateBufferedImages();
                lastSlots = inventorySlots;
            }
            try {
                ItemStack stack;
                int index;
                int horzTexMult = bufferedImageBase.getWidth() / 256;
                int vertTexMult = bufferedImageBase.getWidth() / 256;
                BufferedImage bufferedImageNew = new BufferedImage(bufferedImageBase.getColorModel(), bufferedImageBase.copyData(null), bufferedImageBase.isAlphaPremultiplied(), null);
                IInventory lower2 = ((ContainerChest)container).func_85151_d();
                int size = lower2.func_70302_i_();
                boolean[][] slots = new boolean[9][size / 9];
                boolean[][] buttons = new boolean[9][size / 9];
                boolean ultrasequencer = lower2.func_145748_c_().func_150260_c().startsWith("Ultrasequencer") && !lower2.func_145748_c_().func_150260_c().contains("Stakes");
                boolean superpairs = lower2.func_145748_c_().func_150260_c().startsWith("Superpairs") && !lower2.func_145748_c_().func_150260_c().contains("Stakes");
                for (index = 0; index < size; ++index) {
                    stack = BetterContainers.getStackFromInvetory(lower2, index);
                    buttons[index % 9][index / 9] = BetterContainers.isButtonStack(index, stack);
                    if (ultrasequencer && stack.func_77973_b() == Items.field_151100_aR) {
                        buttons[index % 9][index / 9] = false;
                    }
                    if (superpairs && index > 9 && index < size - 9) {
                        buttons[index % 9][index / 9] = false;
                    }
                    if (buttons[index % 9][index / 9] && lastClickedSlot == index) continue;
                    slots[index % 9][index / 9] = !BetterContainers.isBlankStack(index, stack) && !buttons[index % 9][index / 9];
                }
                for (index = 0; index < size; ++index) {
                    int[] rgbs;
                    int ctmIndex;
                    boolean downleft;
                    boolean downright;
                    boolean upright;
                    boolean upleft;
                    boolean left;
                    boolean down;
                    boolean right;
                    boolean up;
                    stack = BetterContainers.getStackFromInvetory(lower2, index);
                    int xi = index % 9;
                    int yi = index / 9;
                    if (!slots[xi][yi] && !buttons[xi][yi]) continue;
                    int x = 7 * horzTexMult + xi * 18 * horzTexMult;
                    int y = 17 * vertTexMult + yi * 18 * vertTexMult;
                    boolean on = BetterContainers.isToggleOn(stack);
                    boolean off = BetterContainers.isToggleOff(stack);
                    if (on || off) {
                        for (int x2 = 0; x2 < 18; ++x2) {
                            for (int y2 = 0; y2 < 18; ++y2) {
                                BufferedImage toggle = on ? bufferedImageOn : bufferedImageOff;
                                Color c = new Color(toggle.getRGB(x2, y2), true);
                                if (c.getAlpha() < 10) continue;
                                bufferedImageNew.setRGB(x + x2, y + y2, c.getRGB());
                            }
                        }
                        continue;
                    }
                    if (buttons[xi][yi]) {
                        up = yi > 0 && buttons[xi][yi - 1];
                        right = xi < buttons.length - 1 && buttons[xi + 1][yi];
                        down = yi < buttons[xi].length - 1 && buttons[xi][yi + 1];
                        left = xi > 0 && buttons[xi - 1][yi];
                        upleft = yi > 0 && xi > 0 && buttons[xi - 1][yi - 1];
                        upright = yi > 0 && xi < buttons.length - 1 && buttons[xi + 1][yi - 1];
                        downright = xi < buttons.length - 1 && yi < buttons[xi + 1].length - 1 && buttons[xi + 1][yi + 1];
                        downleft = xi > 0 && yi < buttons[xi - 1].length - 1 && buttons[xi - 1][yi + 1];
                        ctmIndex = BetterContainers.getCTMIndex(up, right, down, left, upleft, upright, downright, downleft);
                        rgbs = bufferedImageButton.getRGB(ctmIndex % 12 * 19 * horzTexMult, ctmIndex / 12 * 19 * vertTexMult, 18 * horzTexMult, 18 * vertTexMult, null, 0, 18 * vertTexMult);
                        bufferedImageNew.setRGB(x, y, 18 * horzTexMult, 18 * vertTexMult, rgbs, 0, 18 * vertTexMult);
                        continue;
                    }
                    up = yi > 0 && slots[xi][yi - 1];
                    right = xi < slots.length - 1 && slots[xi + 1][yi];
                    down = yi < slots[xi].length - 1 && slots[xi][yi + 1];
                    left = xi > 0 && slots[xi - 1][yi];
                    upleft = yi > 0 && xi > 0 && slots[xi - 1][yi - 1];
                    upright = yi > 0 && xi < slots.length - 1 && slots[xi + 1][yi - 1];
                    downright = xi < slots.length - 1 && yi < slots[xi + 1].length - 1 && slots[xi + 1][yi + 1];
                    downleft = xi > 0 && yi < slots[xi - 1].length - 1 && slots[xi - 1][yi + 1];
                    ctmIndex = BetterContainers.getCTMIndex(up, right, down, left, upleft, upright, downright, downleft);
                    rgbs = bufferedImageSlot.getRGB(ctmIndex % 12 * 19 * horzTexMult, ctmIndex / 12 * 19 * vertTexMult, 18 * horzTexMult, 18 * vertTexMult, null, 0, 18 * vertTexMult);
                    bufferedImageNew.setRGB(x, y, 18 * horzTexMult, 18 * vertTexMult, rgbs, 0, 18 * vertTexMult);
                }
                if (texture != null) {
                    bufferedImageNew.getRGB(0, 0, bufferedImageNew.getWidth(), bufferedImageNew.getHeight(), texture.func_110565_c(), 0, bufferedImageNew.getWidth());
                    texture.func_110564_a();
                } else {
                    texture = new DynamicTexture(bufferedImageNew);
                }
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        texture = null;
    }

    public static void reset() {
        loaded = false;
        clickedSlot = -1;
        clickedSlotMillis = 0L;
    }

    private static boolean isChestOpen() {
        return Minecraft.func_71410_x().field_71462_r instanceof GuiChest && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() && NotEnoughUpdates.INSTANCE.config.improvedSBMenu.enableSbMenus;
    }

    private static boolean hasItem() {
        if (!BetterContainers.isChestOpen()) {
            return false;
        }
        Container container = ((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
        if (container instanceof ContainerChest) {
            IInventory lower2 = ((ContainerChest)container).func_85151_d();
            int size = lower2.func_70302_i_();
            for (int index = 0; index < size; ++index) {
                if (BetterContainers.getStackFromInvetory(lower2, index) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static ItemStack getStackFromInvetory(IInventory lower2, int index) {
        return lower2.func_70301_a(index);
    }

    private static boolean hasNullPane() {
        if (!BetterContainers.isChestOpen()) {
            return false;
        }
        Container container = ((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
        if (container instanceof ContainerChest) {
            IInventory lower2 = ((ContainerChest)container).func_85151_d();
            int size = lower2.func_70302_i_();
            for (int index = 0; index < size; ++index) {
                if (!BetterContainers.isBlankStack(index, BetterContainers.getStackFromInvetory(lower2, index))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCTMIndex(boolean up, boolean right, boolean down, boolean left, boolean upleft, boolean upright, boolean downright, boolean downleft) {
        if (up && right && down && left) {
            if (upleft && upright && downright && downleft) {
                return 26;
            }
            if (upleft && upright && downright && !downleft) {
                return 33;
            }
            if (upleft && upright && !downright && downleft) {
                return 32;
            }
            if (upleft && upright && !downright && !downleft) {
                return 11;
            }
            if (upleft && !upright && downright && downleft) {
                return 44;
            }
            if (upleft && !upright && downright && !downleft) {
                return 35;
            }
            if (upleft && !upright && !downright && downleft) {
                return 10;
            }
            if (upleft && !upright && !downright && !downleft) {
                return 20;
            }
            if (!upleft && upright && downright && downleft) {
                return 45;
            }
            if (!upleft && upright && downright && !downleft) {
                return 23;
            }
            if (!upleft && upright && !downright && downleft) {
                return 34;
            }
            if (!upleft && upright && !downright && !downleft) {
                return 8;
            }
            if (!upleft && !upright && downright && downleft) {
                return 22;
            }
            if (!upleft && !upright && downright && !downleft) {
                return 9;
            }
            if (!upleft && !upright && !downright && downleft) {
                return 21;
            }
            return 46;
        }
        if (up && right && down && !left) {
            if (!upright && !downright) {
                return 6;
            }
            if (!upright) {
                return 28;
            }
            if (!downright) {
                return 30;
            }
            return 25;
        }
        if (up && right && !down && left) {
            if (!upleft && !upright) {
                return 18;
            }
            if (!upleft) {
                return 40;
            }
            if (!upright) {
                return 42;
            }
            return 38;
        }
        if (up && right && !down && !left) {
            if (!upright) {
                return 16;
            }
            return 37;
        }
        if (up && !right && down && left) {
            if (!upleft && !downleft) {
                return 19;
            }
            if (!upleft) {
                return 43;
            }
            if (!downleft) {
                return 41;
            }
            return 27;
        }
        if (up && !right && down && !left) {
            return 24;
        }
        if (up && !right && !down && left) {
            if (!upleft) {
                return 17;
            }
            return 39;
        }
        if (up && !right && !down && !left) {
            return 36;
        }
        if (!up && right && down && left) {
            if (!downleft && !downright) {
                return 7;
            }
            if (!downleft) {
                return 31;
            }
            if (!downright) {
                return 29;
            }
            return 14;
        }
        if (!up && right && down && !left) {
            if (!downright) {
                return 4;
            }
            return 13;
        }
        if (!up && right && !down && left) {
            return 2;
        }
        if (!up && right && !down && !left) {
            return 1;
        }
        if (!up && !right && down && left) {
            if (!downleft) {
                return 5;
            }
            return 15;
        }
        if (!up && !right && down && !left) {
            return 12;
        }
        if (!up && !right && !down && left) {
            return 3;
        }
        return 0;
    }

    @SubscribeEvent
    public void onMouseClick(SlotClickEvent event) {
        if (!BetterContainers.isOverriding()) {
            return;
        }
        boolean isBlankStack = BetterContainers.isBlankStack(event.slot.field_75222_d, event.slot.func_75211_c());
        if (!isBlankStack && !BetterContainers.isButtonStack(event.slot.field_75222_d, event.slot.func_75211_c())) {
            return;
        }
        BetterContainers.clickSlot(event.slotId);
        if (isBlankStack) {
            event.usePickblockInstead();
        }
    }
}

